/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.ast.shireql;

import cc.unitmesh.devti.language.ast.shireql.ShireQLSchema;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcc/unitmesh/devti/language/ast/shireql/ShireDateSchema;", "Lcc/unitmesh/devti/language/ast/shireql/ShireQLSchema;", "<init>", "()V", "date", "Lkotlinx/datetime/Instant;", "now", "", "dayOfWeek", "", "year", "month", "dayOfMonth", "format", "", "outputFormat", "toString", "devins-lang"})
public final class ShireDateSchema
implements ShireQLSchema {
    @NotNull
    private final Instant date = Clock.System.INSTANCE.now();

    public final long now() {
        return this.date.toEpochMilliseconds();
    }

    public final int dayOfWeek() {
        return Calendar.getInstance().get(7);
    }

    public final int year() {
        return Calendar.getInstance().get(1);
    }

    public final int month() {
        return Calendar.getInstance().get(2) + 1;
    }

    public final int dayOfMonth() {
        return Calendar.getInstance().get(5);
    }

    @NotNull
    public final String format(@NotNull String outputFormat) {
        Intrinsics.checkNotNullParameter((Object)outputFormat, (String)"outputFormat");
        LocalDateTime localDateTime = TimeZoneKt.toLocalDateTime((Instant)this.date, (TimeZone)TimeZone.Companion.currentSystemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(outputFormat);
        String string = ConvertersKt.toJavaLocalDateTime((LocalDateTime)localDateTime).format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return "ShireDate(date=" + this.date + ")";
    }
}

