/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.ast;

import cc.unitmesh.devti.language.ast.Statement;
import cc.unitmesh.devti.language.ast.StringOperator;
import cc.unitmesh.devti.language.ast.StringOperatorStatement;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001d"}, d2={"Lcc/unitmesh/devti/language/ast/StringComparison;", "Lcc/unitmesh/devti/language/ast/Statement;", "variable", "", "operator", "Lcc/unitmesh/devti/language/ast/StringOperatorStatement;", "value", "<init>", "(Ljava/lang/String;Lcc/unitmesh/devti/language/ast/StringOperatorStatement;Ljava/lang/String;)V", "getVariable", "()Ljava/lang/String;", "getOperator", "()Lcc/unitmesh/devti/language/ast/StringOperatorStatement;", "getValue", "evaluate", "", "variables", "", "(Ljava/util/Map;)Ljava/lang/Boolean;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "devins-lang"})
public final class StringComparison
extends Statement {
    @NotNull
    private final String variable;
    @NotNull
    private final StringOperatorStatement operator;
    @NotNull
    private final String value;

    public StringComparison(@NotNull String variable, @NotNull StringOperatorStatement operator, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.variable = variable;
        this.operator = operator;
        this.value = value;
    }

    @NotNull
    public final String getVariable() {
        return this.variable;
    }

    @NotNull
    public final StringOperatorStatement getOperator() {
        return this.operator;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public Boolean evaluate(@NotNull Map<String, String> variables) {
        boolean bl;
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        StringOperator stringOperator = this.operator.getType();
        if (Intrinsics.areEqual((Object)stringOperator, (Object)StringOperator.Contains.INSTANCE)) {
            bl = StringsKt.contains$default((CharSequence)this.variable, (CharSequence)this.value, (boolean)false, (int)2, null);
        } else if (Intrinsics.areEqual((Object)stringOperator, (Object)StringOperator.StartsWith.INSTANCE)) {
            bl = StringsKt.startsWith$default((String)this.variable, (String)this.value, (boolean)false, (int)2, null);
        } else if (Intrinsics.areEqual((Object)stringOperator, (Object)StringOperator.EndsWith.INSTANCE)) {
            bl = StringsKt.endsWith$default((String)this.variable, (String)this.value, (boolean)false, (int)2, null);
        } else if (Intrinsics.areEqual((Object)stringOperator, (Object)StringOperator.Matches.INSTANCE)) {
            CharSequence charSequence = this.variable;
            Pattern pattern = Pattern.compile(this.value);
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            Pattern pattern2 = pattern;
            bl = new Regex(pattern2).matches(charSequence);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final String component1() {
        return this.variable;
    }

    @NotNull
    public final StringOperatorStatement component2() {
        return this.operator;
    }

    @NotNull
    public final String component3() {
        return this.value;
    }

    @NotNull
    public final StringComparison copy(@NotNull String variable, @NotNull StringOperatorStatement operator, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new StringComparison(variable, operator, value);
    }

    public static /* synthetic */ StringComparison copy$default(StringComparison stringComparison, String string, StringOperatorStatement stringOperatorStatement, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = stringComparison.variable;
        }
        if ((n & 2) != 0) {
            stringOperatorStatement = stringComparison.operator;
        }
        if ((n & 4) != 0) {
            string2 = stringComparison.value;
        }
        return stringComparison.copy(string, stringOperatorStatement, string2);
    }

    @NotNull
    public String toString() {
        return "StringComparison(variable=" + this.variable + ", operator=" + this.operator + ", value=" + this.value + ")";
    }

    public int hashCode() {
        int result = this.variable.hashCode();
        result = result * 31 + this.operator.hashCode();
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringComparison)) {
            return false;
        }
        StringComparison stringComparison = (StringComparison)other;
        if (!Intrinsics.areEqual((Object)this.variable, (Object)stringComparison.variable)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.operator, (Object)stringComparison.operator)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)stringComparison.value);
    }
}

