/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.ast;

import cc.unitmesh.devti.language.ast.OperatorType;
import cc.unitmesh.devti.language.ast.Statement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0013\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0001H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001d"}, d2={"Lcc/unitmesh/devti/language/ast/LogicalExpression;", "Lcc/unitmesh/devti/language/ast/Statement;", "left", "operator", "Lcc/unitmesh/devti/language/ast/OperatorType;", "right", "<init>", "(Lcc/unitmesh/devti/language/ast/Statement;Lcc/unitmesh/devti/language/ast/OperatorType;Lcc/unitmesh/devti/language/ast/Statement;)V", "getLeft", "()Lcc/unitmesh/devti/language/ast/Statement;", "getOperator", "()Lcc/unitmesh/devti/language/ast/OperatorType;", "getRight", "evaluate", "", "variables", "", "", "(Ljava/util/Map;)Ljava/lang/Boolean;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "devins-lang"})
public final class LogicalExpression
extends Statement {
    @NotNull
    private final Statement left;
    @NotNull
    private final OperatorType operator;
    @NotNull
    private final Statement right;

    public LogicalExpression(@NotNull Statement left, @NotNull OperatorType operator, @NotNull Statement right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @NotNull
    public final Statement getLeft() {
        return this.left;
    }

    @NotNull
    public final OperatorType getOperator() {
        return this.operator;
    }

    @NotNull
    public final Statement getRight() {
        return this.right;
    }

    @Override
    @NotNull
    public Boolean evaluate(@NotNull Map<String, String> variables) {
        boolean bl;
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Object object = this.left.evaluate(variables);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean leftValue = (Boolean)object;
        Object object2 = this.right.evaluate(variables);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
        boolean rightValue = (Boolean)object2;
        OperatorType operatorType = this.operator;
        if (Intrinsics.areEqual((Object)operatorType, (Object)OperatorType.And.INSTANCE)) {
            bl = leftValue && rightValue;
        } else if (Intrinsics.areEqual((Object)operatorType, (Object)OperatorType.Or.INSTANCE)) {
            bl = leftValue || rightValue;
        } else {
            throw new IllegalArgumentException("Invalid logical operator: " + this.operator);
        }
        return bl;
    }

    @NotNull
    public final Statement component1() {
        return this.left;
    }

    @NotNull
    public final OperatorType component2() {
        return this.operator;
    }

    @NotNull
    public final Statement component3() {
        return this.right;
    }

    @NotNull
    public final LogicalExpression copy(@NotNull Statement left, @NotNull OperatorType operator, @NotNull Statement right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new LogicalExpression(left, operator, right);
    }

    public static /* synthetic */ LogicalExpression copy$default(LogicalExpression logicalExpression, Statement statement, OperatorType operatorType, Statement statement2, int n, Object object) {
        if ((n & 1) != 0) {
            statement = logicalExpression.left;
        }
        if ((n & 2) != 0) {
            operatorType = logicalExpression.operator;
        }
        if ((n & 4) != 0) {
            statement2 = logicalExpression.right;
        }
        return logicalExpression.copy(statement, operatorType, statement2);
    }

    @NotNull
    public String toString() {
        return "LogicalExpression(left=" + this.left + ", operator=" + this.operator + ", right=" + this.right + ")";
    }

    public int hashCode() {
        int result = this.left.hashCode();
        result = result * 31 + this.operator.hashCode();
        result = result * 31 + this.right.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogicalExpression)) {
            return false;
        }
        LogicalExpression logicalExpression = (LogicalExpression)other;
        if (!Intrinsics.areEqual((Object)this.left, (Object)logicalExpression.left)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.operator, (Object)logicalExpression.operator)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.right, (Object)logicalExpression.right);
    }
}

