/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.ast;

import cc.unitmesh.devti.language.ast.FrontMatterType;
import cc.unitmesh.devti.language.ast.MethodCall;
import cc.unitmesh.devti.language.ast.Operator;
import cc.unitmesh.devti.language.ast.OperatorType;
import cc.unitmesh.devti.language.ast.Statement;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001e"}, d2={"Lcc/unitmesh/devti/language/ast/Comparison;", "Lcc/unitmesh/devti/language/ast/Statement;", "left", "Lcc/unitmesh/devti/language/ast/FrontMatterType;", "operator", "Lcc/unitmesh/devti/language/ast/Operator;", "right", "<init>", "(Lcc/unitmesh/devti/language/ast/FrontMatterType;Lcc/unitmesh/devti/language/ast/Operator;Lcc/unitmesh/devti/language/ast/FrontMatterType;)V", "getLeft", "()Lcc/unitmesh/devti/language/ast/FrontMatterType;", "getOperator", "()Lcc/unitmesh/devti/language/ast/Operator;", "getRight", "evaluate", "", "variables", "", "", "(Ljava/util/Map;)Ljava/lang/Boolean;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "devins-lang"})
@SourceDebugExtension(value={"SMAP\nShireExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShireExpression.kt\ncc/unitmesh/devti/language/ast/Comparison\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,381:1\n11#2:382\n*S KotlinDebug\n*F\n+ 1 ShireExpression.kt\ncc/unitmesh/devti/language/ast/Comparison\n*L\n181#1:382\n*E\n"})
public final class Comparison
extends Statement {
    @NotNull
    private final FrontMatterType left;
    @NotNull
    private final Operator operator;
    @NotNull
    private final FrontMatterType right;

    public Comparison(@NotNull FrontMatterType left, @NotNull Operator operator, @NotNull FrontMatterType right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    @NotNull
    public final FrontMatterType getLeft() {
        return this.left;
    }

    @NotNull
    public final Operator getOperator() {
        return this.operator;
    }

    @NotNull
    public final FrontMatterType getRight() {
        return this.right;
    }

    @Override
    @NotNull
    public Boolean evaluate(@NotNull Map<String, String> variables) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Object object2 = this.left.getValue();
        if (object2 instanceof MethodCall) {
            object = ((MethodCall)this.left.getValue()).evaluate(variables);
        } else if (object2 instanceof FrontMatterType.STRING) {
            object = ((FrontMatterType.STRING)this.left.getValue()).getValue();
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(Comparison.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Variable not found: " + this.left.getValue() + ", will use: " + variables.get(this.left.getValue()));
            object = variables.get(this.left.getValue());
        }
        Object variableValue = object;
        Object value = this.right.getValue();
        OperatorType operatorType = this.operator.getType();
        if (Intrinsics.areEqual((Object)operatorType, (Object)OperatorType.Equal.INSTANCE)) {
            bl = Intrinsics.areEqual((Object)variableValue, (Object)value);
        } else if (Intrinsics.areEqual((Object)operatorType, (Object)OperatorType.NotEqual.INSTANCE)) {
            bl = !Intrinsics.areEqual((Object)variableValue, (Object)value);
        } else if (Intrinsics.areEqual((Object)operatorType, (Object)OperatorType.LessThan.INSTANCE)) {
            Intrinsics.checkNotNull((Object)variableValue, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
            bl = ((Comparable)variableValue).compareTo(value) < 0;
        } else if (Intrinsics.areEqual((Object)operatorType, (Object)OperatorType.GreaterThan.INSTANCE)) {
            Intrinsics.checkNotNull((Object)variableValue, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
            bl = ((Comparable)variableValue).compareTo(value) > 0;
        } else if (Intrinsics.areEqual((Object)operatorType, (Object)OperatorType.LessEqual.INSTANCE)) {
            Intrinsics.checkNotNull((Object)variableValue, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
            bl = ((Comparable)variableValue).compareTo(value) <= 0;
        } else if (Intrinsics.areEqual((Object)operatorType, (Object)OperatorType.GreaterEqual.INSTANCE)) {
            Intrinsics.checkNotNull((Object)variableValue, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
            bl = ((Comparable)variableValue).compareTo(value) >= 0;
        } else {
            throw new IllegalArgumentException("Invalid comparison operator: " + this.operator.getType());
        }
        return bl;
    }

    @NotNull
    public final FrontMatterType component1() {
        return this.left;
    }

    @NotNull
    public final Operator component2() {
        return this.operator;
    }

    @NotNull
    public final FrontMatterType component3() {
        return this.right;
    }

    @NotNull
    public final Comparison copy(@NotNull FrontMatterType left, @NotNull Operator operator, @NotNull FrontMatterType right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        return new Comparison(left, operator, right);
    }

    public static /* synthetic */ Comparison copy$default(Comparison comparison, FrontMatterType frontMatterType, Operator operator, FrontMatterType frontMatterType2, int n, Object object) {
        if ((n & 1) != 0) {
            frontMatterType = comparison.left;
        }
        if ((n & 2) != 0) {
            operator = comparison.operator;
        }
        if ((n & 4) != 0) {
            frontMatterType2 = comparison.right;
        }
        return comparison.copy(frontMatterType, operator, frontMatterType2);
    }

    @NotNull
    public String toString() {
        return "Comparison(left=" + this.left + ", operator=" + this.operator + ", right=" + this.right + ")";
    }

    public int hashCode() {
        int result = this.left.hashCode();
        result = result * 31 + this.operator.hashCode();
        result = result * 31 + this.right.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Comparison)) {
            return false;
        }
        Comparison comparison = (Comparison)other;
        if (!Intrinsics.areEqual((Object)this.left, (Object)comparison.left)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.operator, (Object)comparison.operator)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.right, (Object)comparison.right);
    }
}

