/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.language.actions.input.inlay;

import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J,\u0010\u0014\u001a\u00020\u00152\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcc/unitmesh/devti/language/actions/input/inlay/InlayRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "component", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "getComponent", "()Ljava/awt/Component;", "setComponent", "inlaySize", "Ljava/awt/Dimension;", "getInlaySize", "()Ljava/awt/Dimension;", "setInlaySize", "(Ljava/awt/Dimension;)V", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "calcHeightInPixels", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "devins-lang"})
public final class InlayRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private Component component;
    @NotNull
    private Dimension inlaySize;

    public InlayRenderer(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.component = component2;
        this.inlaySize = new Dimension(0, 0);
    }

    @NotNull
    public final Component getComponent() {
        return this.component;
    }

    public final void setComponent(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"<set-?>");
        this.component = component2;
    }

    @NotNull
    public final Dimension getInlaySize() {
        return this.inlaySize;
    }

    public final void setInlaySize(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"<set-?>");
        this.inlaySize = dimension;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.inlaySize.width;
    }

    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return this.inlaySize.height;
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Rectangle rectangle = inlay.getBounds();
        if (rectangle == null) {
            return;
        }
        Rectangle bounds = rectangle;
        Point point = bounds.getLocation();
        if (point == null) {
            return;
        }
        Point inlayLocation = point;
        if (!Intrinsics.areEqual((Object)this.component.getLocation(), (Object)inlayLocation)) {
            this.component.setLocation(inlayLocation);
        }
    }
}

