/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.intentions.action.task;

import cc.unitmesh.devti.inlay.chunks.SimilarChunksWithPaths;
import cc.unitmesh.devti.intentions.action.task.BaseCompletionTask;
import cc.unitmesh.devti.intentions.action.task.CodeCompletionRequest;
import cc.unitmesh.devti.settings.AutoDevSettingsState;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcc/unitmesh/devti/intentions/action/task/SimilarCodeCompletionTask;", "Lcc/unitmesh/devti/intentions/action/task/BaseCompletionTask;", "request", "Lcc/unitmesh/devti/intentions/action/task/CodeCompletionRequest;", "<init>", "(Lcc/unitmesh/devti/intentions/action/task/CodeCompletionRequest;)V", "chunksString", "", "commenter", "Lcom/intellij/lang/Commenter;", "kotlin.jvm.PlatformType", "commentPrefix", "Lorg/jetbrains/annotations/Nullable;", "keepHistory", "", "start", "getStart", "()Ljava/lang/String;", "end", "getEnd", "promptText", "generatePrefix", "documentLength", "", "core"})
public final class SimilarCodeCompletionTask
extends BaseCompletionTask {
    @NotNull
    private final CodeCompletionRequest request;
    @Nullable
    private final String chunksString;
    private final Commenter commenter;
    @Nullable
    private final String commentPrefix;
    @NotNull
    private final String start;
    @NotNull
    private final String end;

    public SimilarCodeCompletionTask(@NotNull CodeCompletionRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        super(request2);
        this.request = request2;
        PsiElement psiElement = this.request.getElement();
        Intrinsics.checkNotNull((Object)psiElement);
        this.chunksString = SimilarChunksWithPaths.Companion.createQuery(psiElement, 60);
        PsiElement psiElement2 = this.request.getElement();
        Intrinsics.checkNotNull((Object)psiElement2);
        Commenter commenter = this.commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(psiElement2.getLanguage());
        this.commentPrefix = commenter != null ? commenter.getLineCommentPrefix() : null;
        this.start = "code complete for given code, just return rest part of code. \n";
        this.end = "\nreturn rest code:";
    }

    @Override
    public boolean keepHistory() {
        return false;
    }

    @NotNull
    public final String getStart() {
        return this.start;
    }

    @NotNull
    public final String getEnd() {
        return this.end;
    }

    @Override
    @NotNull
    public String promptText() {
        int documentLength = this.request.getEditor().getDocument().getTextLength();
        String prefix = this.generatePrefix(documentLength);
        return this.chunksString == null ? this.start + prefix + "\n" + this.end : this.start + ": \n" + this.commentPrefix + "\n" + this.chunksString + "\n" + prefix + "\n" + this.end;
    }

    private final String generatePrefix(int documentLength) {
        String string;
        if (this.request.getOffset() > documentLength) {
            string = this.request.getPrefix();
        } else {
            String string2 = this.request.getEditor().getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = string2;
            int n = 0;
            int n2 = this.request.getOffset();
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        }
        String prefix = string;
        String string5 = this.commentPrefix;
        String string6 = this.chunksString;
        int prefixMaxLength = AutoDevSettingsState.Companion.getMaxTokenLength() - this.start.length() - (string5 != null ? string5.length() : 0) - (string6 != null ? string6.length() : 0);
        if (prefix.length() >= prefixMaxLength) {
            String string7 = prefix.substring(prefix.length() - prefixMaxLength);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            return string7;
        }
        return prefix;
    }
}

