/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.intentions.action.task;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.custom.document.LivingDocumentationType;
import cc.unitmesh.devti.intentions.action.task.LivingDocPromptBuilder;
import cc.unitmesh.devti.llms.LLMProvider;
import cc.unitmesh.devti.llms.LlmFactory;
import cc.unitmesh.devti.provider.LivingDocumentation;
import cc.unitmesh.devti.statusbar.AutoDevStatus;
import cc.unitmesh.devti.statusbar.AutoDevStatusService;
import cc.unitmesh.devti.util.parser.CodeFence;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcc/unitmesh/devti/intentions/action/task/LivingDocumentationTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "target", "Lcom/intellij/psi/PsiElement;", "type", "Lcc/unitmesh/devti/custom/document/LivingDocumentationType;", "documentation", "Lcc/unitmesh/devti/provider/LivingDocumentation;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;Lcc/unitmesh/devti/custom/document/LivingDocumentationType;Lcc/unitmesh/devti/provider/LivingDocumentation;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getTarget", "()Lcom/intellij/psi/PsiElement;", "getType", "()Lcc/unitmesh/devti/custom/document/LivingDocumentationType;", "getDocumentation", "()Lcc/unitmesh/devti/provider/LivingDocumentation;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onThrowable", "error", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLivingDocumentationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LivingDocumentationTask.kt\ncc/unitmesh/devti/intentions/action/task/LivingDocumentationTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n11#2:71\n*S KotlinDebug\n*F\n+ 1 LivingDocumentationTask.kt\ncc/unitmesh/devti/intentions/action/task/LivingDocumentationTask\n*L\n66#1:71\n*E\n"})
public final class LivingDocumentationTask
extends Task.Backgroundable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final PsiElement target;
    @NotNull
    private final LivingDocumentationType type;
    @NotNull
    private final LivingDocumentation documentation;
    @NotNull
    private static final Logger logger;

    public LivingDocumentationTask(@NotNull Editor editor, @NotNull PsiElement target, @NotNull LivingDocumentationType type, @NotNull LivingDocumentation documentation) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)documentation, (String)"documentation");
        super(editor.getProject(), AutoDevBundle.message("intentions.request.background.process.title", new Object[0]));
        this.editor = editor;
        this.target = target;
        this.type = type;
        this.documentation = documentation;
    }

    public /* synthetic */ LivingDocumentationTask(Editor editor, PsiElement psiElement, LivingDocumentationType livingDocumentationType, LivingDocumentation livingDocumentation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            livingDocumentationType = LivingDocumentationType.COMMENT;
        }
        this(editor, psiElement, livingDocumentationType, livingDocumentation);
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final PsiElement getTarget() {
        return this.target;
    }

    @NotNull
    public final LivingDocumentationType getType() {
        return this.type;
    }

    @NotNull
    public final LivingDocumentation getDocumentation() {
        return this.documentation;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        LivingDocPromptBuilder builder = new LivingDocPromptBuilder(this.editor, this.target, this.documentation, this.type);
        String prompt2 = builder.buildPrompt(this.getProject(), this.target, "");
        AutoDevStatusService.Companion.notifyApplication$default(AutoDevStatusService.Companion, AutoDevStatus.InProgress, null, 2, null);
        logger.info("Prompt: " + prompt2);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Flow stream2 = LLMProvider.DefaultImpls.stream$default(LlmFactory.INSTANCE.create(project), prompt2, "", false, false, 8, null);
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = "";
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Flow<String>)stream2, (Ref.ObjectRef<String>)result, null){
            int label;
            final /* synthetic */ Flow<String> $stream;
            final /* synthetic */ Ref.ObjectRef<String> $result;
            {
                this.$stream = $stream;
                this.$result = $result;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$stream.collect(new FlowCollector(this.$result){
                            final /* synthetic */ Ref.ObjectRef<String> $result;
                            {
                                this.$result = $result;
                            }

                            public final Object emit(String it, Continuation<? super Unit> $completion) {
                                this.$result.element = this.$result.element + it;
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        logger.info("Result: " + result.element);
        if (StringsKt.startsWith$default((String)((String)result.element), (String)"```", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)((String)result.element), (String)"```", (boolean)false, (int)2, null)) {
            result.element = CodeFence.Companion.parse((String)result.element).getText();
        }
        this.documentation.updateDoc(this.target, (String)result.element, this.type, this.editor);
        AutoDevStatusService.Companion.notifyApplication$default(AutoDevStatusService.Companion, AutoDevStatus.Ready, null, 2, null);
    }

    public void onThrowable(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        super.onThrowable(error);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AutoDevNotifications.INSTANCE.error(project, "Failed to generate living documentation: " + error.getMessage());
        AutoDevStatusService.Companion.notifyApplication$default(AutoDevStatusService.Companion, AutoDevStatus.Error, null, 2, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LivingDocumentationTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LivingDocumentationTask.logger = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcc/unitmesh/devti/intentions/action/task/LivingDocumentationTask$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

