/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.intentions.action.task;

import cc.unitmesh.devti.context.ClassContext;
import cc.unitmesh.devti.context.ClassContextProvider;
import cc.unitmesh.devti.context.MethodContext;
import cc.unitmesh.devti.context.MethodContextProvider;
import cc.unitmesh.devti.context.VariableContext;
import cc.unitmesh.devti.context.VariableContextProvider;
import cc.unitmesh.devti.context.base.LLMCodeContext;
import cc.unitmesh.devti.context.base.LLMCodeContextProvider;
import cc.unitmesh.devti.custom.document.LivingDocumentationType;
import cc.unitmesh.devti.provider.LivingDocumentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0004J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020$H\u0002J\"\u0010%\u001a\u00020\u001c2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00180\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lcc/unitmesh/devti/intentions/action/task/LivingDocPromptBuilder;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "target", "Lcom/intellij/psi/PsiElement;", "documentation", "Lcc/unitmesh/devti/provider/LivingDocumentation;", "type", "Lcc/unitmesh/devti/custom/document/LivingDocumentationType;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;Lcc/unitmesh/devti/provider/LivingDocumentation;Lcc/unitmesh/devti/custom/document/LivingDocumentationType;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getTarget", "()Lcom/intellij/psi/PsiElement;", "getDocumentation", "()Lcc/unitmesh/devti/provider/LivingDocumentation;", "getType", "()Lcc/unitmesh/devti/custom/document/LivingDocumentationType;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "contextProviders", "", "Lcc/unitmesh/devti/context/base/LLMCodeContextProvider;", "getContextProviders", "()Ljava/util/List;", "contextInstruction", "", "context", "Lcc/unitmesh/devti/context/base/LLMCodeContext;", "variableInstruction", "Lcc/unitmesh/devti/context/VariableContext;", "classInstruction", "Lcc/unitmesh/devti/context/ClassContext;", "methodInstruction", "Lcc/unitmesh/devti/context/MethodContext;", "buildPrompt", "project", "Lcom/intellij/openapi/project/Project;", "fallbackText", "core"})
@SourceDebugExtension(value={"SMAP\nLivingDocPromptBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LivingDocPromptBuilder.kt\ncc/unitmesh/devti/intentions/action/task/LivingDocPromptBuilder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n11#2:152\n1855#3,2:153\n*S KotlinDebug\n*F\n+ 1 LivingDocPromptBuilder.kt\ncc/unitmesh/devti/intentions/action/task/LivingDocPromptBuilder\n*L\n46#1:152\n145#1:153,2\n*E\n"})
public class LivingDocPromptBuilder {
    @NotNull
    private final Editor editor;
    @NotNull
    private final PsiElement target;
    @NotNull
    private final LivingDocumentation documentation;
    @NotNull
    private final LivingDocumentationType type;
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<LLMCodeContextProvider<PsiElement>> contextProviders;

    public LivingDocPromptBuilder(@NotNull Editor editor, @NotNull PsiElement target, @NotNull LivingDocumentation documentation, @NotNull LivingDocumentationType type) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)documentation, (String)"documentation");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.editor = editor;
        this.target = target;
        this.documentation = documentation;
        this.type = type;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LivingDocPromptBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        Object[] objectArray = new LLMCodeContextProvider[]{new MethodContextProvider(true, false), new ClassContextProvider(false), new VariableContextProvider(false, false, false)};
        this.contextProviders = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public PsiElement getTarget() {
        return this.target;
    }

    @NotNull
    public LivingDocumentation getDocumentation() {
        return this.documentation;
    }

    @NotNull
    public final LivingDocumentationType getType() {
        return this.type;
    }

    @NotNull
    protected final List<LLMCodeContextProvider<PsiElement>> getContextProviders() {
        return this.contextProviders;
    }

    @Nullable
    protected final String contextInstruction(@Nullable LLMCodeContext context) {
        LLMCodeContext lLMCodeContext = context;
        return lLMCodeContext instanceof ClassContext ? this.classInstruction((ClassContext)context) : (lLMCodeContext instanceof MethodContext ? this.methodInstruction((MethodContext)context) : (lLMCodeContext instanceof VariableContext ? this.variableInstruction((VariableContext)context) : null));
    }

    private final String variableInstruction(VariableContext context) {
        if (context.getName() == null) {
            return null;
        }
        return "Write documentation for given variable " + context.getName() + ".";
    }

    private final String classInstruction(ClassContext context) {
        if (context.getName() == null) {
            return null;
        }
        return "Write documentation for given " + context.getRoot().getLanguage().getDisplayName() + " language class " + context.getName() + ".";
    }

    private final String methodInstruction(MethodContext context) {
        String returnType;
        CharSequence charSequence;
        if (context.getName() == null) {
            return null;
        }
        Object instruction = "Write documentation for given " + context.getRoot().getLanguage().getDisplayName() + " language method " + context.getName() + ".\n";
        if (!((Collection)context.getParamNames()).isEmpty() && this.getDocumentation().getParameterTagInstruction() != null) {
            String string = this.getDocumentation().getParameterTagInstruction();
            if (string == null) {
                string = "";
            }
            instruction = StringsKt.trimIndent((String)("\n                " + (String)instruction + "\n                " + string + "\n                "));
        }
        if (!((charSequence = (CharSequence)(returnType = context.getReturnType())) == null || charSequence.length() == 0) && this.getDocumentation().getReturnTagInstruction() != null) {
            String string = this.getDocumentation().getReturnTagInstruction();
            if (string == null) {
                string = "";
            }
            instruction = StringsKt.trimIndent((String)("\n                " + (String)instruction + "\n                " + string + "\n                "));
        }
        String related = "\nHere is related context information of the method\n\n```" + context.getLanguage() + "\n" + context.format() + "\n```\n";
        return ((Object)StringsKt.trimStart((CharSequence)((CharSequence)instruction))).toString() + related;
    }

    @NotNull
    public String buildPrompt(@Nullable Project project, @NotNull PsiElement target, @NotNull String fallbackText) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)fallbackText, (String)"fallbackText");
        Object object = ReadAction.compute(() -> LivingDocPromptBuilder.buildPrompt$lambda$2(fallbackText, this, target));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (String)object;
    }

    private static final String buildPrompt$lambda$2(String $fallbackText, LivingDocPromptBuilder this$0, PsiElement $target) {
        String string;
        Object object;
        String inOutString;
        StringBuilder instruction;
        block8: {
            instruction = new StringBuilder($fallbackText);
            inOutString = null;
            inOutString = "";
            for (LLMCodeContextProvider contextProvider : (Iterable)this$0.contextProviders) {
                Object object2;
                LLMCodeContext lLMCodeContext;
                boolean bl = false;
                try {
                    lLMCodeContext = contextProvider.from($target);
                }
                catch (Exception e) {
                    this$0.logger.info("Error while getting context for " + $target, (Throwable)e);
                    lLMCodeContext = null;
                }
                LLMCodeContext llmQueryContext = lLMCodeContext;
                if (llmQueryContext instanceof MethodContext) {
                    inOutString = ((MethodContext)llmQueryContext).inputOutputString();
                }
                if ((object2 = this$0.contextInstruction(llmQueryContext)) == null) continue;
                object = object2;
                break block8;
            }
            object = string = null;
        }
        if (object == null) {
            string = "Write documentation for given " + $target.getLanguage().getDisplayName() + " language code.";
        }
        String basicInstruction = string;
        instruction.append(basicInstruction);
        if (((CharSequence)inOutString).length() > 0) {
            instruction.append("\nCompare this snippet: \n");
            instruction.append(inOutString);
            instruction.append("\n");
        }
        instruction.append("```" + $target.getLanguage().getDisplayName() + "\n" + $target.getText() + "\n```");
        Pair<String, String> startEndString = this$0.getDocumentation().startEndString(this$0.type);
        if (startEndString != null) {
            instruction.append("\n\nStart your documentation with " + startEndString.getFirst() + " here, and ends with `" + startEndString.getSecond() + "`.\n");
        }
        Iterable $this$forEach$iv = this$0.getDocumentation().getForbiddenRules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            instruction.append("\n- " + it + "\n");
        }
        return instruction.toString();
    }
}

