/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.intentions.action.base;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.gui.SendToWindowKt;
import cc.unitmesh.devti.gui.chat.message.ChatActionType;
import cc.unitmesh.devti.intentions.action.ElementSelectionForChat;
import cc.unitmesh.devti.intentions.action.ElementSelectionForChatKt;
import cc.unitmesh.devti.provider.ContextPrompter;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.usageView.UsageViewTypeLocation;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J%\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J.\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcc/unitmesh/devti/intentions/action/base/ChatBaseIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "priority", "", "getActionType", "Lcc/unitmesh/devti/gui/chat/message/ChatActionType;", "prompt", "", "getPrompt", "()Ljava/lang/String;", "startInWriteAction", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "elementWithRange", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "computeTitle", "psiFile", "range", "Lcom/intellij/openapi/util/TextRange;", "getDescription", "element", "core"})
public abstract class ChatBaseIntention
implements IntentionAction {
    @NotNull
    private final String prompt;

    public ChatBaseIntention() {
        this.prompt = "Code completion";
    }

    public abstract int priority();

    @NotNull
    public ChatActionType getActionType() {
        return ChatActionType.CODE_COMPLETE;
    }

    @NotNull
    public String getPrompt() {
        return this.prompt;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return editor != null && file != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || file == null) {
            return;
        }
        Pair<String, PsiElement> pair = this.elementWithRange(editor, file, project);
        if (pair == null) {
            return;
        }
        Pair<String, PsiElement> withRange = pair;
        String selectedText = (String)withRange.getFirst();
        PsiElement psiElement = (PsiElement)withRange.getSecond();
        ChatActionType actionType = this.getActionType();
        String string = file.getLanguage().getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        ContextPrompter prompter = ContextPrompter.Companion.prompter(string);
        prompter.initContext(actionType, selectedText, file, project, editor.getCaretModel().getOffset(), psiElement);
        SendToWindowKt.sendToChatPanel(project, actionType, prompter);
    }

    @Nullable
    public final Pair<String, PsiElement> elementWithRange(@NotNull Editor editor, @NotNull PsiFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String selectedText = editor.getSelectionModel().getSelectedText();
        PsiElement psiElement = ElementSelectionForChatKt.getElementToAction(project, editor);
        if (selectedText == null) {
            if (psiElement == null) {
                return null;
            }
            ElementSelectionForChat.INSTANCE.selectElement(psiElement, editor);
            selectedText = editor.getSelectionModel().getSelectedText();
        }
        if (selectedText == null) {
            return null;
        }
        return new Pair((Object)selectedText, (Object)psiElement);
    }

    @NotNull
    public final String computeTitle(@NotNull Project project, @NotNull PsiFile psiFile2, @NotNull TextRange range) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        String defaultTitle = AutoDevBundle.message("intentions.chat.selected.code.name", new Object[0]);
        if (!range.isEmpty()) {
            return defaultTitle;
        }
        PsiElement psiElement = ElementSelectionForChatKt.calculateFrontendElementToExplain(project, psiFile2, range);
        if (psiElement == null) {
            return defaultTitle;
        }
        PsiElement element = psiElement;
        if (element instanceof PsiFile) {
            if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment((PsiFile)element)) {
                String string2 = element.getLanguage().getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
                String displayName = string2;
                Object[] objectArray = new Object[]{displayName};
                return AutoDevBundle.message("intentions.chat.selected.fragment.name", objectArray);
            }
            String string3 = ((PsiFile)element).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            String name = string3;
            Object[] objectArray = new Object[]{name, this.getDescription(element)};
            return AutoDevBundle.message("intentions.chat.selected.element.name", objectArray);
        }
        if (element instanceof PsiNameIdentifierOwner && ((PsiNameIdentifierOwner)element).getName() != null) {
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNull((Object)((PsiNameIdentifierOwner)element).getName());
            objectArray[1] = this.getDescription(element);
            string = AutoDevBundle.message("intentions.chat.selected.element.name", objectArray);
        } else {
            string = defaultTitle;
        }
        return string;
    }

    private final String getDescription(PsiElement element) {
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementDescription(...)");
        return string;
    }
}

