/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.intentions.action;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"getElementToAction", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "calculateFrontendElementToExplain", "psiFile", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "core"})
public final class ElementSelectionForChatKt {
    @Nullable
    public static final PsiElement getElementToAction(@Nullable Project project, @Nullable Editor editor) {
        PsiNameIdentifierOwner identifierOwner;
        if (project == null || editor == null) {
            return null;
        }
        PsiElement psiElement = PsiUtilBase.getElementAtCaret((Editor)editor);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        PsiFile psiFile2 = element.getContainingFile();
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(psiFile2)) {
            return (PsiElement)psiFile2;
        }
        PsiNameIdentifierOwner psiNameIdentifierOwner = identifierOwner = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNameIdentifierOwner.class);
        return psiNameIdentifierOwner != null ? (PsiElement)psiNameIdentifierOwner : element;
    }

    @Nullable
    public static final PsiElement calculateFrontendElementToExplain(@Nullable Project project, @NotNull PsiFile psiFile2, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (project == null || !psiFile2.isValid()) {
            return null;
        }
        PsiElement psiElement = PsiUtilBase.getElementAtOffset((PsiFile)psiFile2, (int)range.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        PsiElement element = psiElement;
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(psiFile2)) {
            return (PsiElement)psiFile2;
        }
        PsiElement injected = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(psiFile2, range.getStartOffset());
        if (injected != null) {
            return (PsiElement)injected.getContainingFile();
        }
        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)element, PsiNameIdentifierOwner.class);
        PsiElement psiElement3 = psiElement2;
        if (psiElement3 == null) {
            psiElement3 = element;
        }
        return psiElement3;
    }
}

