/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.intentions.action;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.intentions.action.base.ChatBaseIntention;
import cc.unitmesh.devti.intentions.action.task.CodeCompletionRequest;
import cc.unitmesh.devti.intentions.action.task.RelatedCodeCompletionTask;
import cc.unitmesh.devti.intentions.action.task.SimilarCodeCompletionTask;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingService;
import cc.unitmesh.devti.settings.coder.AutoDevCoderSettingServiceKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J%\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002\u00a8\u0006\u0011"}, d2={"Lcc/unitmesh/devti/intentions/action/CodeCompletionBaseIntention;", "Lcc/unitmesh/devti/intentions/action/base/ChatBaseIntention;", "<init>", "()V", "priority", "", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "core"})
public final class CodeCompletionBaseIntention
extends ChatBaseIntention {
    @Override
    public int priority() {
        return 981;
    }

    @NotNull
    public String getText() {
        return AutoDevBundle.message("intentions.chat.code.complete.name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return AutoDevBundle.message("intentions.chat.code.complete.family.name", new Object[0]);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        int suffixEnd;
        int promptStart;
        boolean isOutBoundary;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || file == null) {
            return;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int offset = editor.getCaretModel().getOffset();
        int promptLength = 512;
        boolean bl = isOutBoundary = !EditorActionUtil.isWordBoundary((CharSequence)editor.getDocument().getText(), (int)promptStart, (boolean)false, (boolean)false);
        for (promptStart = RangesKt.coerceAtLeast((int)(offset - promptLength), (int)0); promptStart < offset && isOutBoundary; ++promptStart) {
        }
        if (promptStart == offset) {
            promptStart = RangesKt.coerceAtLeast((int)(offset - promptLength), (int)0);
        }
        String string = document2.getText(TextRange.create((int)promptStart, (int)offset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String prefix = string;
        int suffixLength = 256;
        for (suffixEnd = (int)Math.min((double)(offset + suffixLength), (double)document2.getTextLength()); suffixEnd > offset && !EditorActionUtil.isWordBoundary((CharSequence)editor.getDocument().getText(), (int)suffixEnd, (boolean)false, (boolean)false); --suffixEnd) {
        }
        PsiElement psiElement = PsiUtilBase.getElementAtCaret((Editor)editor);
        if (psiElement == null) {
            psiElement = (PsiElement)file;
        }
        PsiElement element = psiElement;
        String string2 = document2.getText(new TextRange(offset, suffixEnd));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String suffix = string2;
        CodeCompletionRequest codeCompletionRequest = CodeCompletionRequest.Companion.create$default(CodeCompletionRequest.Companion, editor, offset, element, prefix, suffix, false, 32, null);
        if (codeCompletionRequest == null) {
            return;
        }
        CodeCompletionRequest request2 = codeCompletionRequest;
        if (((AutoDevCoderSettingService.AutoDevCoderSettings)AutoDevCoderSettingServiceKt.getCoderSetting(project).getState()).getInEditorCompletion()) {
            RelatedCodeCompletionTask task2 = new RelatedCodeCompletionTask(request2);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task2, (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task2));
        } else {
            SimilarCodeCompletionTask task3 = new SimilarCodeCompletionTask(request2);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task3, (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task3));
        }
    }
}

