/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.inline;

import cc.unitmesh.devti.inline.AutoDevInlineChatPanel;
import cc.unitmesh.devti.inline.AutoDevInlineChatServiceKt;
import cc.unitmesh.devti.prompting.SimpleDevinPrompter;
import cc.unitmesh.devti.template.TemplateRender;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcc/unitmesh/devti/inline/AutoDevInlineChatService;", "Lcom/intellij/openapi/Disposable;", "Lcc/unitmesh/devti/prompting/SimpleDevinPrompter;", "<init>", "()V", "allChats", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcc/unitmesh/devti/inline/AutoDevInlineChatPanel;", "templateRender", "Lcc/unitmesh/devti/template/TemplateRender;", "getTemplateRender", "()Lcc/unitmesh/devti/template/TemplateRender;", "template", "getTemplate", "()Ljava/lang/String;", "showInlineChat", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "dispose", "closeInlineChat", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nAutoDevInlineChatService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoDevInlineChatService.kt\ncc/unitmesh/devti/inline/AutoDevInlineChatService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1855#2,2:81\n*S KotlinDebug\n*F\n+ 1 AutoDevInlineChatService.kt\ncc/unitmesh/devti/inline/AutoDevInlineChatService\n*L\n49#1:81,2\n*E\n"})
public final class AutoDevInlineChatService
extends SimpleDevinPrompter
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, AutoDevInlineChatPanel> allChats = new ConcurrentHashMap();
    @NotNull
    private final TemplateRender templateRender = new TemplateRender("/code");
    @NotNull
    private final String template = this.getTemplateRender().getTemplate("inline-chat.devin");

    @Override
    @NotNull
    public TemplateRender getTemplateRender() {
        return this.templateRender;
    }

    @Override
    @NotNull
    public String getTemplate() {
        return this.template;
    }

    public final void showInlineChat(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        boolean canShowInlineChat = true;
        if (this.allChats.containsKey(AutoDevInlineChatServiceKt.fileUrl(editor))) {
            AutoDevInlineChatPanel autoDevInlineChatPanel = this.allChats.get(AutoDevInlineChatServiceKt.fileUrl(editor));
            Intrinsics.checkNotNull((Object)autoDevInlineChatPanel);
            AutoDevInlineChatPanel chatPanel = autoDevInlineChatPanel;
            Inlay<?> inlay = chatPanel.getInlay();
            canShowInlineChat = !(inlay != null ? inlay.getOffset() == editor.getCaretModel().getPrimaryCaret().getOffset() : false);
            this.closeInlineChat(editor);
        }
        if (canShowInlineChat) {
            if (editor.getComponent() instanceof AutoDevInlineChatPanel) {
                return;
            }
            AutoDevInlineChatPanel panel2 = new AutoDevInlineChatPanel(editor);
            editor.getContentComponent().add(panel2);
            JComponent jComponent = editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            panel2.setInlineContainer(jComponent);
            int offset = editor.getSelectionModel().hasSelection() ? editor.getSelectionModel().getSelectionStart() : editor.getCaretModel().getPrimaryCaret().getOffset();
            panel2.createInlay(offset);
            IdeFocusManager.getInstance((Project)editor.getProject()).requestFocus(panel2.getInputPanel().getInputComponent(), true);
            ((Map)this.allChats).put(AutoDevInlineChatServiceKt.fileUrl(editor), panel2);
        }
    }

    public void dispose() {
        Collection<AutoDevInlineChatPanel> collection = this.allChats.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoDevInlineChatPanel it = (AutoDevInlineChatPanel)element$iv;
            boolean bl = false;
            this.closeInlineChat(it.getEditor());
        }
        this.allChats.clear();
    }

    public final void closeInlineChat(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        AutoDevInlineChatPanel autoDevInlineChatPanel = this.allChats.get(AutoDevInlineChatServiceKt.fileUrl(editor));
        if (autoDevInlineChatPanel == null) {
            return;
        }
        AutoDevInlineChatPanel chatPanel = autoDevInlineChatPanel;
        chatPanel.dispose();
        try {
            editor.getContentComponent().remove(chatPanel);
            editor.getContentComponent().revalidate();
            editor.getContentComponent().repaint();
            this.allChats.remove(AutoDevInlineChatServiceKt.fileUrl(editor));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcc/unitmesh/devti/inline/AutoDevInlineChatService$Companion;", "", "<init>", "()V", "getInstance", "Lcc/unitmesh/devti/inline/AutoDevInlineChatService;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AutoDevInlineChatService getInstance() {
            Object object = ApplicationManager.getApplication().getService(AutoDevInlineChatService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (AutoDevInlineChatService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

