/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.inline;

import cc.unitmesh.devti.inline.AutoDevInlineChatPanel;
import cc.unitmesh.devti.inline.AutoDevInlineChatService;
import cc.unitmesh.devti.inline.AutoDevLineBorder;
import cc.unitmesh.devti.inline.EscHandler;
import cc.unitmesh.devti.sketch.SketchProcessListener;
import cc.unitmesh.devti.sketch.SketchToolWindow;
import com.intellij.icons.AllIcons;
import com.intellij.ide.KeyboardAwareFocusOwner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012$\u0010\u0005\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0018\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\nH\u0002J\b\u0010\u001a\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR/\u0010\u0005\u001a \u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcc/unitmesh/devti/inline/AutoDevInlineChatInput;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "autoDevInlineChatPanel", "Lcc/unitmesh/devti/inline/AutoDevInlineChatPanel;", "onSubmit", "Lkotlin/Function2;", "", "Lkotlin/Function1;", "Lcc/unitmesh/devti/sketch/SketchToolWindow;", "", "<init>", "(Lcc/unitmesh/devti/inline/AutoDevInlineChatPanel;Lkotlin/jvm/functions/Function2;)V", "getAutoDevInlineChatPanel", "()Lcc/unitmesh/devti/inline/AutoDevInlineChatPanel;", "getOnSubmit", "()Lkotlin/jvm/functions/Function2;", "textArea", "Lcom/intellij/ui/components/JBTextArea;", "view", "btnPresentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "escHandler", "Lcc/unitmesh/devti/inline/EscHandler;", "onEnter", "submit", "cancel", "setPresentationTextAndIcon", "running", "", "getInputComponent", "Ljava/awt/Component;", "dispose", "core"})
public final class AutoDevInlineChatInput
extends JPanel
implements Disposable {
    @NotNull
    private final AutoDevInlineChatPanel autoDevInlineChatPanel;
    @NotNull
    private final Function2<String, Function1<? super SketchToolWindow, Unit>, SketchToolWindow> onSubmit;
    @NotNull
    private final JBTextArea textArea;
    @Nullable
    private SketchToolWindow view;
    @Nullable
    private Presentation btnPresentation;
    @Nullable
    private EscHandler escHandler;

    public AutoDevInlineChatInput(@NotNull AutoDevInlineChatPanel autoDevInlineChatPanel, @NotNull Function2<? super String, ? super Function1<? super SketchToolWindow, Unit>, ? extends SketchToolWindow> onSubmit2) {
        Intrinsics.checkNotNullParameter((Object)autoDevInlineChatPanel, (String)"autoDevInlineChatPanel");
        Intrinsics.checkNotNullParameter(onSubmit2, (String)"onSubmit");
        super(new GridBagLayout());
        this.autoDevInlineChatPanel = autoDevInlineChatPanel;
        this.onSubmit = onSubmit2;
        this.setLayout(new BorderLayout());
        this.textArea = (JBTextArea)new KeyboardAwareFocusOwner(){
            {
                this.setOpaque(true);
                this.setFocusable(true);
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setBorder(BorderFactory.createEmptyBorder(8, 6, 8, 6));
            }

            public boolean skipKeyEventDispatcher(KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return true;
            }
        };
        Color color = JBUI.CurrentTheme.Focus.focusColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"focusColor(...)");
        this.setBorder(new AutoDevLineBorder(color, 1, true, 2));
        (this.textArea).getActionMap().put("escapeAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.cancel();
                AutoDevInlineChatService.Companion.getInstance().closeInlineChat(this.getAutoDevInlineChatPanel().getEditor());
            }
        });
        (this.textArea).getInputMap().put(KeyStroke.getKeyStroke(27, 0), "escapeAction");
        (this.textArea).getActionMap().put("enterAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.submit();
            }
        });
        (this.textArea).getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enterAction");
        (this.textArea).getActionMap().put("newlineAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                textArea.append("\n");
            }
        });
        (this.textArea).getInputMap().put(KeyStroke.getKeyStroke(10, 64), "newlineAction");
        this.escHandler = new EscHandler(this.autoDevInlineChatPanel.getEditor(), (Function0<Unit>)((Function0)() -> AutoDevInlineChatInput._init_$lambda$0(this)));
        this.btnPresentation = new Presentation();
        this.setPresentationTextAndIcon(false);
        ActionButton actionBtn = new ActionButton((AnAction)DumbAwareAction.create(arg_0 -> AutoDevInlineChatInput._init_$lambda$2(arg_0 -> AutoDevInlineChatInput._init_$lambda$1(this, arg_0), arg_0)), this.btnPresentation, "", new Dimension(40, 20));
        this.add((Component)this.textArea);
        this.add((Component)actionBtn, "East");
    }

    @NotNull
    public final AutoDevInlineChatPanel getAutoDevInlineChatPanel() {
        return this.autoDevInlineChatPanel;
    }

    @NotNull
    public final Function2<String, Function1<? super SketchToolWindow, Unit>, SketchToolWindow> getOnSubmit() {
        return this.onSubmit;
    }

    private final void onEnter() {
        Presentation presentation = this.btnPresentation;
        if (Intrinsics.areEqual((Object)(presentation != null ? presentation.getIcon() : null), (Object)AllIcons.Actions.Execute)) {
            this.submit();
        } else {
            Presentation presentation2 = this.btnPresentation;
            if (Intrinsics.areEqual((Object)(presentation2 != null ? presentation2.getIcon() : null), (Object)AllIcons.Actions.Suspend)) {
                this.cancel();
            }
        }
    }

    private final void submit() {
        SketchToolWindow sketchToolWindow = this.view;
        if (sketchToolWindow != null) {
            Result.box-impl((Object)sketchToolWindow.cancel-IoAF18A("Cancel by resubmit"));
        }
        String string = this.textArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String trimText = ((Object)StringsKt.trim((CharSequence)string)).toString();
        this.textArea.setText("");
        this.view = (SketchToolWindow)((Object)this.onSubmit.invoke((Object)trimText, arg_0 -> AutoDevInlineChatInput.submit$lambda$3(this, arg_0)));
    }

    private final void cancel() {
        SketchToolWindow sketchToolWindow = this.view;
        if (sketchToolWindow != null) {
            Result.box-impl((Object)sketchToolWindow.cancel-IoAF18A("Cancel"));
        }
        this.setPresentationTextAndIcon(false);
    }

    private final void setPresentationTextAndIcon(boolean running) {
        ActionsKt.runInEdt$default(null, () -> AutoDevInlineChatInput.setPresentationTextAndIcon$lambda$4(running, this), (int)1, null);
    }

    @NotNull
    public final Component getInputComponent() {
        return (Component)this.textArea;
    }

    public void dispose() {
    }

    private static final Unit _init_$lambda$0(AutoDevInlineChatInput this$0) {
        block0: {
            this$0.cancel();
            AutoDevInlineChatService.Companion.getInstance().closeInlineChat(this$0.autoDevInlineChatPanel.getEditor());
            EscHandler escHandler = this$0.escHandler;
            if (escHandler == null) break block0;
            escHandler.dispose();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(AutoDevInlineChatInput this$0, AnActionEvent it) {
        this$0.onEnter();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit submit$lambda$3(AutoDevInlineChatInput this$0, SketchToolWindow it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        it.addProcessListener(new SketchProcessListener(this$0){
            final /* synthetic */ AutoDevInlineChatInput this$0;
            {
                this.this$0 = $receiver;
            }

            public void onBefore() {
                AutoDevInlineChatInput.access$setPresentationTextAndIcon(this.this$0, true);
            }

            public void onAfter() {
                AutoDevInlineChatInput.access$setPresentationTextAndIcon(this.this$0, false);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit setPresentationTextAndIcon$lambda$4(boolean $running, AutoDevInlineChatInput this$0) {
        block3: {
            block2: {
                if (!$running) break block2;
                Presentation presentation = this$0.btnPresentation;
                if (presentation != null) {
                    presentation.setText("Cancel");
                }
                Presentation presentation2 = this$0.btnPresentation;
                if (presentation2 == null) break block3;
                presentation2.setIcon(AllIcons.Actions.Suspend);
                break block3;
            }
            Presentation presentation = this$0.btnPresentation;
            if (presentation != null) {
                presentation.setText("Submit");
            }
            Presentation presentation3 = this$0.btnPresentation;
            if (presentation3 == null) break block3;
            presentation3.setIcon(AllIcons.Actions.Execute);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setPresentationTextAndIcon(AutoDevInlineChatInput $this, boolean running) {
        $this.setPresentationTextAndIcon(running);
    }
}

