/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.inlay.codecomplete.presentation;

import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionThemeInfoProvider;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0013J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000eR9\u0010\u0004\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b \t*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/inlay/codecomplete/presentation/PresentationUtil;", "", "<init>", "()V", "KEY_CACHED_FONTMETRICS", "Lcom/intellij/openapi/util/Key;", "", "Ljava/awt/Font;", "Ljava/awt/FontMetrics;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fontMetrics", "font", "replaceLeadingTabs", "", "", "lines", "tabWidth", "", "getThemeInfoProvider", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/CodeVisionThemeInfoProvider;", "getEditorFontSize2DMethod", "Ljava/lang/reflect/Method;", "getFont", "text", "fontSize", "", "core"})
public final class PresentationUtil {
    @NotNull
    public static final PresentationUtil INSTANCE = new PresentationUtil();
    @NotNull
    private static final Key<Map<Font, FontMetrics>> KEY_CACHED_FONTMETRICS;
    @Nullable
    private static final Method getEditorFontSize2DMethod;

    private PresentationUtil() {
    }

    @NotNull
    public final TextAttributes getTextAttributes(@NotNull Editor editor) {
        TextAttributes customAttributes;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        TextAttributes themeAttributes = scheme.getAttributes(DefaultLanguageHighlighterColors.INLAY_TEXT_WITHOUT_BACKGROUND);
        if (themeAttributes != null && themeAttributes.getForegroundColor() != null) {
            return themeAttributes;
        }
        TextAttributes textAttributes = themeAttributes;
        if (textAttributes == null || (textAttributes = textAttributes.clone()) == null) {
            textAttributes = new TextAttributes();
        }
        if ((customAttributes = textAttributes).getForegroundColor() == null) {
            JBColor jBColor = JBColor.GRAY;
            Intrinsics.checkNotNull((Object)jBColor, (String)"null cannot be cast to non-null type java.awt.Color");
            customAttributes.setForegroundColor((Color)jBColor);
        }
        return customAttributes;
    }

    @NotNull
    public final FontMetrics fontMetrics(@NotNull Editor editor, @NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        FontRenderContext editorContext = FontInfo.getFontRenderContext((Component)editor.getContentComponent());
        FontRenderContext context = new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), editorContext.getFractionalMetricsHint());
        Map cachedMap = (Map)KEY_CACHED_FONTMETRICS.get((UserDataHolder)editor, (Object)MapsKt.emptyMap());
        FontMetrics fontMetrics = (FontMetrics)cachedMap.get(font);
        if (fontMetrics == null || !context.equals(fontMetrics.getFontRenderContext())) {
            fontMetrics = FontInfo.getFontMetrics((Font)font, (FontRenderContext)context);
            UserDataHolder userDataHolder = (UserDataHolder)editor;
            Intrinsics.checkNotNull((Object)cachedMap);
            KEY_CACHED_FONTMETRICS.set(userDataHolder, (Object)MapsKt.plus((Map)cachedMap, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)font, (Object)fontMetrics))));
        }
        return fontMetrics;
    }

    @NotNull
    public final List<String> replaceLeadingTabs(@NotNull List<String> lines, int tabWidth) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        List<String> list = lines.stream().map(arg_0 -> PresentationUtil.replaceLeadingTabs$lambda$1(arg_0 -> PresentationUtil.replaceLeadingTabs$lambda$0(tabWidth, arg_0), arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        return list;
    }

    @NotNull
    public final CodeVisionThemeInfoProvider getThemeInfoProvider() {
        Class<CodeVisionThemeInfoProvider> serviceClass = CodeVisionThemeInfoProvider.class;
        CodeVisionThemeInfoProvider codeVisionThemeInfoProvider = (CodeVisionThemeInfoProvider)ApplicationManager.getApplication().getService(serviceClass);
        if (codeVisionThemeInfoProvider == null) {
            throw new RuntimeException("Cannot find service " + serviceClass.getName() + " (classloader=" + serviceClass.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        CodeVisionThemeInfoProvider service = codeVisionThemeInfoProvider;
        return service;
    }

    @NotNull
    public final Font getFont(@NotNull Editor editor, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Font font = editor.getColorsScheme().getFont(EditorFontType.PLAIN).deriveFont(2);
        Font font2 = UIUtil.getFontWithFallbackIfNeeded((Font)font, (String)text);
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"getFontWithFallbackIfNeeded(...)");
        Font fallbackFont = font2;
        Font font3 = fallbackFont.deriveFont(this.fontSize(editor));
        Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"deriveFont(...)");
        return font3;
    }

    public final float fontSize(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        if (getEditorFontSize2DMethod != null) {
            try {
                Object object = getEditorFontSize2DMethod.invoke((Object)scheme, new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
                return ((Float)object).floatValue();
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return scheme.getEditorFontSize();
    }

    private static final String replaceLeadingTabs$lambda$0(int $tabWidth, String line) {
        String string = line;
        Intrinsics.checkNotNull((Object)string);
        int tabCount = StringUtil.countChars((CharSequence)string, (char)'\t', (int)0, (boolean)true);
        if (tabCount > 0) {
            String string2 = StringUtil.repeatSymbol((char)' ', (int)(tabCount * $tabWidth));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"repeatSymbol(...)");
            String tabSpaces = string2;
            return tabSpaces + tabSpaces;
        }
        return line;
    }

    private static final String replaceLeadingTabs$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"autodev.editorFontMetrics");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY_CACHED_FONTMETRICS = key;
        Method method = null;
        if (ApplicationInfo.getInstance().getBuild().getBaselineVersion() >= 221) {
            try {
                method = EditorColorsScheme.class.getMethod("getEditorFontSize2D", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        getEditorFontSize2DMethod = method;
    }
}

