/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.inlay.codecomplete.presentation;

import cc.unitmesh.devti.gui.LLMTextInlayPainter;
import cc.unitmesh.devti.inlay.codecomplete.presentation.PresentationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u0015\u001a\u00020\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0014\u0010\u0016\u001a\u00020\u00132\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0014\u0010\u0017\u001a\u00020\u00132\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J,\u0010\u0018\u001a\u00020\u00192\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/inlay/codecomplete/presentation/LLMInlayRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "lines", "", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/util/List;)V", "content", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "setInlay", "(Lcom/intellij/openapi/editor/Inlay;)V", "cachedWidth", "", "cachedHeight", "getContextMenuGroupId", "calcHeightInPixels", "calcWidthInPixels", "paint", "", "g", "Ljava/awt/Graphics;", "region", "Ljava/awt/Rectangle;", "surroundingTextAttributes", "core"})
@SourceDebugExtension(value={"SMAP\nLLMInlayRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMInlayRenderer.kt\ncc/unitmesh/devti/inlay/codecomplete/presentation/LLMInlayRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class LLMInlayRenderer
implements EditorCustomElementRenderer {
    @NotNull
    private final List<String> lines;
    @NotNull
    private final String content;
    @NotNull
    private final TextAttributes textAttributes;
    @Nullable
    private Inlay<EditorCustomElementRenderer> inlay;
    private int cachedWidth;
    private int cachedHeight;

    public LLMInlayRenderer(@NotNull Editor editor, @NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this.lines = PresentationUtil.INSTANCE.replaceLeadingTabs(lines, 4);
        this.content = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        this.textAttributes = PresentationUtil.INSTANCE.getTextAttributes(editor);
        this.cachedWidth = -1;
        this.cachedHeight = -1;
    }

    @Nullable
    public final Inlay<EditorCustomElementRenderer> getInlay() {
        return this.inlay;
    }

    public final void setInlay(@Nullable Inlay<EditorCustomElementRenderer> inlay) {
        this.inlay = inlay;
    }

    @NotNull
    public String getContextMenuGroupId(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return "autodev.inlayContextMenu";
    }

    /*
     * WARNING - void declaration
     */
    public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
        int n;
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        if (this.cachedHeight < 0) {
            void it;
            int n2;
            int n3 = n2 = this.lines.size();
            int n4 = inlay.getEditor().getLineHeight();
            boolean bl = false;
            this.cachedHeight = it;
            Unit unit = Unit.INSTANCE;
            n = n4 * n2;
        } else {
            n = this.cachedHeight;
        }
        return n;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        if (this.cachedWidth < 0) {
            int n;
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            int width = LLMTextInlayPainter.Companion.calculateWidth(editor, this.content, this.lines);
            int it = n = RangesKt.coerceAtLeast((int)1, (int)width);
            boolean bl = false;
            this.cachedWidth = it;
            return n;
        }
        return this.cachedWidth;
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle region, @NotNull TextAttributes surroundingTextAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)surroundingTextAttributes, (String)"surroundingTextAttributes");
        Editor editor = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        if (editor2.isDisposed()) {
            return;
        }
        LLMTextInlayPainter.Companion.renderCodeBlock(editor2, this.content, this.lines, g, region, this.textAttributes);
    }
}

