/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.inlay.codecomplete.presentation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J8\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/inlay/codecomplete/presentation/EditorUtilCopy;", "", "<init>", "()V", "indentLine", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "lineNumber", "indent", "caretOffset", "shouldUseSmartTabs", "", "getSpaceWidthInColumns", "seq", "", "startOffset", "endOffset", "tabSize", "core"})
public final class EditorUtilCopy {
    @NotNull
    public static final EditorUtilCopy INSTANCE = new EditorUtilCopy();

    private EditorUtilCopy() {
    }

    public final int indentLine(@Nullable Project project, @NotNull Editor editor, int lineNumber, int indent, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.indentLine(project, editor, lineNumber, indent, caretOffset, EditorActionUtil.shouldUseSmartTabs((Project)project, (Editor)editor));
    }

    public final int indentLine(@Nullable Project project, @NotNull Editor editor, int lineNumber, int indent, int caretOffset, boolean shouldUseSmartTabs) {
        int tabsEnd3;
        int newCaretOffset;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EditorSettings editorSettings = editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        EditorSettings editorSettings2 = editorSettings;
        int tabSize = editorSettings2.getTabSize(project);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        CharSequence charSequence = document2.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence text = charSequence;
        int spacesEnd = 0;
        int lineStart = 0;
        int lineEnd = 0;
        int tabsEnd = 0;
        if (lineNumber < document2.getLineCount()) {
            lineStart = document2.getLineStartOffset(lineNumber);
            lineEnd = document2.getLineEndOffset(lineNumber);
            boolean inTabs = true;
            for (spacesEnd = lineStart; spacesEnd <= lineEnd && spacesEnd != lineEnd; ++spacesEnd) {
                char c = text.charAt(spacesEnd);
                if (c == '\t') continue;
                if (inTabs) {
                    inTabs = false;
                    tabsEnd = spacesEnd;
                }
                if (c != ' ') break;
            }
            if (inTabs) {
                tabsEnd = lineEnd;
            }
        }
        boolean bl = lineStart <= (newCaretOffset = caretOffset) ? newCaretOffset < lineEnd : false;
        if (bl && spacesEnd == lineEnd) {
            spacesEnd = newCaretOffset;
            tabsEnd = Math.min(spacesEnd, tabsEnd);
        }
        int oldLength = this.getSpaceWidthInColumns(text, lineStart, spacesEnd, tabSize);
        int tabsEnd2 = this.getSpaceWidthInColumns(text, lineStart, tabsEnd, tabSize);
        int newLength = oldLength + indent;
        if (newLength < 0) {
            newLength = 0;
        }
        if ((tabsEnd3 = tabsEnd2 + indent) < 0) {
            tabsEnd3 = 0;
        }
        if (!shouldUseSmartTabs) {
            tabsEnd3 = newLength;
        }
        StringBuilder buf = new StringBuilder(newLength);
        int i = 0;
        while (i < newLength) {
            if (tabSize > 0 && editorSettings2.isUseTabCharacter(project) && i + tabSize <= tabsEnd3) {
                buf.append('\t');
                i += tabSize;
                continue;
            }
            buf.append(' ');
            ++i;
        }
        int newSpacesEnd = lineStart + buf.length();
        if (newCaretOffset >= spacesEnd) {
            newCaretOffset += buf.length() - (spacesEnd - lineStart);
        } else if (newCaretOffset >= lineStart && newCaretOffset > newSpacesEnd) {
            newCaretOffset = newSpacesEnd;
        }
        return newCaretOffset;
    }

    private final int getSpaceWidthInColumns(CharSequence seq, int startOffset, int endOffset, int tabSize) {
        int result = 0;
        for (int i = startOffset; i < endOffset; ++i) {
            if (seq.charAt(i) == '\t') {
                result = (result / tabSize + 1) * tabSize;
                continue;
            }
            ++result;
        }
        return result;
    }
}

