/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.inlay.codecomplete;

import cc.unitmesh.devti.inlay.codecomplete.InlayDisposeContext;
import cc.unitmesh.devti.inlay.codecomplete.LLMInlayManager;
import cc.unitmesh.devti.inlay.codecomplete.presentation.LLMInlayRenderer;
import cc.unitmesh.devti.intentions.action.task.CodeCompletionRequest;
import cc.unitmesh.devti.intentions.action.task.CodeCompletionTask;
import cc.unitmesh.devti.util.parser.CodeFence;
import cc.unitmesh.devti.util.parser.PostCodeProcessor;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0017J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0017J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0011H\u0003J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcc/unitmesh/devti/inlay/codecomplete/LLMInlayManagerImpl;", "Lcc/unitmesh/devti/inlay/codecomplete/LLMInlayManager;", "<init>", "()V", "currentCompletion", "", "isAvailable", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "applyCompletion", "project", "Lcom/intellij/openapi/project/Project;", "collectInlays", "", "Lcc/unitmesh/devti/inlay/codecomplete/presentation/LLMInlayRenderer;", "startOffset", "", "endOffset", "disposeInlays", "", "disposeContext", "Lcc/unitmesh/devti/inlay/codecomplete/InlayDisposeContext;", "editorModified", "changeOffset", "requestCompletions", "countCompletionInlays", "tabRange", "Lcom/intellij/openapi/util/TextRange;", "renderers", "wrapProcessing", "block", "Ljava/lang/Runnable;", "isProcessing", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLLMInlayManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMInlayManagerImpl.kt\ncc/unitmesh/devti/inlay/codecomplete/LLMInlayManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,179:1\n1603#2,9:180\n1855#2:189\n1856#2:191\n1612#2:192\n1774#2,4:193\n1#3:190\n11#4:197\n*S KotlinDebug\n*F\n+ 1 LLMInlayManagerImpl.kt\ncc/unitmesh/devti/inlay/codecomplete/LLMInlayManagerImpl\n*L\n95#1:180,9\n95#1:189\n95#1:191\n95#1:192\n149#1:193,4\n95#1:190\n30#1:197\n*E\n"})
public final class LLMInlayManagerImpl
implements LLMInlayManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String currentCompletion = "";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<CodeCompletionRequest> KEY_LAST_REQUEST;
    @NotNull
    private static final KeyWithDefaultValue<Boolean> KEY_PROCESSING;
    @NotNull
    private static final Key<Boolean> KEY_EDITOR_SUPPORTED;

    @Override
    @RequiresEdt
    public boolean isAvailable(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Boolean isAvailable = (Boolean)KEY_EDITOR_SUPPORTED.get((UserDataHolder)editor);
        if (isAvailable == null) {
            isAvailable = !(editor instanceof EditorWindow) && !(editor instanceof ImaginaryEditor) && (!(editor instanceof EditorEx) || !((EditorEx)editor).isEmbeddedIntoDialogWrapper()) && !editor.isViewer() && !editor.isOneLineMode();
            KEY_EDITOR_SUPPORTED.set((UserDataHolder)editor, (Object)isAvailable);
        }
        return isAvailable != false && !editor.isDisposed();
    }

    @Override
    @RequiresEdt
    public boolean applyCompletion(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.disposeInlays(editor, InlayDisposeContext.Applied);
        CodeCompletionRequest request2 = (CodeCompletionRequest)KEY_LAST_REQUEST.get((UserDataHolder)editor);
        if (request2 == null) {
            logger.warn("No request found for editor: " + editor);
            return false;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Apply Code Suggestion", (String)"AutoDev", () -> LLMInlayManagerImpl.applyCompletion$lambda$0(project, editor, request2, this), (PsiFile[])new PsiFile[0]);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    @NotNull
    public List<LLMInlayRenderer> collectInlays(@NotNull Editor editor, int startOffset, int endOffset) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object object = editor.getInlayModel();
        InlayModelImpl inlayModelImpl = object instanceof InlayModelImpl ? (InlayModelImpl)object : null;
        if (inlayModelImpl == null) {
            return CollectionsKt.emptyList();
        }
        InlayModelImpl model = inlayModelImpl;
        if (endOffset <= startOffset) {
            return CollectionsKt.emptyList();
        }
        Object $this$collectInlays_u24lambda_u241 = object = (List)new ArrayList();
        boolean $i$a$-apply-LLMInlayManagerImpl$collectInlays$inlays$22 = false;
        List list = model.getInlineElementsInRange(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInlineElementsInRange(...)");
        $this$collectInlays_u24lambda_u241.addAll(list);
        List list2 = model.getAfterLineEndElementsInRange(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAfterLineEndElementsInRange(...)");
        $this$collectInlays_u24lambda_u241.addAll(list2);
        List list3 = model.getBlockElementsInRange(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getBlockElementsInRange(...)");
        $this$collectInlays_u24lambda_u241.addAll(list3);
        Object inlays = object;
        Iterable $this$mapNotNull$iv = (Iterable)inlays;
        boolean $i$f$mapNotNull = false;
        Iterable $i$a$-apply-LLMInlayManagerImpl$collectInlays$inlays$22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LLMInlayRenderer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Inlay it = (Inlay)element$iv$iv;
            boolean bl2 = false;
            EditorCustomElementRenderer editorCustomElementRenderer = it.getRenderer();
            if ((editorCustomElementRenderer instanceof LLMInlayRenderer ? (LLMInlayRenderer)editorCustomElementRenderer : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @RequiresEdt
    public void disposeInlays(@NotNull Editor editor, @NotNull InlayDisposeContext disposeContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)disposeContext), (String)"disposeContext");
        if (!this.isAvailable(editor) || this.isProcessing(editor)) {
            return;
        }
        this.wrapProcessing(editor, () -> LLMInlayManagerImpl.disposeInlays$lambda$3(this, editor));
    }

    @Override
    public void editorModified(@NotNull Editor editor, int changeOffset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.disposeInlays(editor, InlayDisposeContext.Typing);
        this.requestCompletions(editor, changeOffset);
    }

    @RequiresBackgroundThread
    private final void requestCompletions(Editor editor, int changeOffset) {
        PsiElement psiElement = PsiUtilBase.getElementAtCaret((Editor)editor);
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        CodeCompletionRequest codeCompletionRequest = CodeCompletionRequest.Companion.create$default(CodeCompletionRequest.Companion, editor, changeOffset, element, null, null, false, 32, null);
        if (codeCompletionRequest == null) {
            return;
        }
        CodeCompletionRequest request2 = codeCompletionRequest;
        KEY_LAST_REQUEST.set((UserDataHolder)editor, (Object)request2);
        new CodeCompletionTask(request2).execute(arg_0 -> LLMInlayManagerImpl.requestCompletions$lambda$6(this, request2, editor, changeOffset, arg_0));
    }

    @Override
    public void editorModified(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editorModified(editor, editor.getCaretModel().getOffset());
    }

    @Override
    public int countCompletionInlays(@NotNull Editor editor, @NotNull TextRange tabRange) {
        int completionCount;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)tabRange, (String)"tabRange");
        List<LLMInlayRenderer> inlays = this.collectInlays(editor, tabRange.getStartOffset(), tabRange.getEndOffset());
        if (inlays.isEmpty()) {
            return 0;
        }
        Iterable $this$count$iv = inlays;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v0 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                LLMInlayRenderer it = (LLMInlayRenderer)element$iv;
                boolean bl = false;
                Inlay<EditorCustomElementRenderer> inlay = it.getInlay();
                if (!((inlay != null ? inlay.getRenderer() : null) instanceof LLMInlayRenderer) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v0 = completionCount = count$iv;
        }
        if (completionCount > 0) {
            logger.debug("Completion inlays found: " + completionCount);
        }
        return completionCount;
    }

    private final void disposeInlays(List<LLMInlayRenderer> renderers) {
        logger.debug("Disposing inlays: " + renderers.size());
        for (LLMInlayRenderer renderer : renderers) {
            if (renderer.getInlay() == null) continue;
            Disposable disposable = (Disposable)renderer.getInlay();
            Intrinsics.checkNotNull((Object)disposable);
            Disposer.dispose((Disposable)disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void wrapProcessing(Editor editor, Runnable block) {
        boolean bl;
        boolean bl2 = bl = (Boolean)KEY_PROCESSING.get((UserDataHolder)editor) == false;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        try {
            KEY_PROCESSING.set((UserDataHolder)editor, (Object)true);
            block.run();
        }
        finally {
            KEY_PROCESSING.set((UserDataHolder)editor, null);
        }
    }

    private final boolean isProcessing(Editor editor) {
        Object object = KEY_PROCESSING.get((UserDataHolder)editor);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    @Override
    public void dispose() {
        LLMInlayManager.DefaultImpls.dispose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void applyCompletion$lambda$0(Project $project, Editor $editor, CodeCompletionRequest $request, LLMInlayManagerImpl this$0) {
        if ($project.isDisposed()) {
            return;
        }
        Document document = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        document2.insertString($request.getOffset(), (CharSequence)this$0.currentCompletion);
        $editor.getCaretModel().moveToOffset($request.getOffset() + this$0.currentCompletion.length());
        TextRange range = new TextRange($request.getOffset(), $request.getOffset() + this$0.currentCompletion.length());
        PsiFile psiFile2 = PsiUtilBase.getPsiFileInEditor((Editor)$editor, (Project)$project);
        if (psiFile2 == null) {
            return;
        }
        PsiFile psiFile3 = psiFile2;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)$project);
        codeStyleManager.reformatText(psiFile3, range.getStartOffset(), range.getEndOffset());
    }

    private static final void disposeInlays$lambda$3(LLMInlayManagerImpl this$0, Editor $editor) {
        this$0.disposeInlays(this$0.collectInlays($editor, 0, $editor.getDocument().getTextLength()));
    }

    private static final void requestCompletions$lambda$6$lambda$5(Editor $editor, LLMInlayManagerImpl this$0, int $changeOffset) {
        LLMInlayRenderer renderer;
        LLMInlayRenderer lLMInlayRenderer;
        LLMInlayRenderer $this$requestCompletions_u24lambda_u246_u24lambda_u245_u24lambda_u244 = lLMInlayRenderer = (renderer = new LLMInlayRenderer($editor, StringsKt.lines((CharSequence)this$0.currentCompletion)));
        boolean bl = false;
        Inlay inlay = $editor.getInlayModel().addBlockElement($changeOffset, true, false, 0, (EditorCustomElementRenderer)$this$requestCompletions_u24lambda_u246_u24lambda_u245_u24lambda_u244);
        if (inlay != null) {
            Inlay inlay2 = inlay;
            renderer.setInlay((Inlay<EditorCustomElementRenderer>)inlay2);
        }
    }

    private static final void requestCompletions$lambda$6(LLMInlayManagerImpl this$0, CodeCompletionRequest $request, Editor $editor, int $changeOffset, String completion) {
        Intrinsics.checkNotNullParameter((Object)completion, (String)"completion");
        if (((CharSequence)completion).length() == 0) {
            return;
        }
        String parsedCode = CodeFence.Companion.parse(completion).getText();
        String string = ((CharSequence)parsedCode).length() == 0 ? completion : parsedCode;
        Intrinsics.checkNotNull((Object)string);
        String completeCode = string;
        this$0.currentCompletion = new PostCodeProcessor($request.getPrefix(), $request.getSuffix(), completeCode, 0, 8, null).execute();
        WriteCommandAction.runWriteCommandAction((Project)$editor.getProject(), () -> LLMInlayManagerImpl.requestCompletions$lambda$6$lambda$5($editor, this$0, $changeOffset));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LLMInlayManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LLMInlayManagerImpl.logger = logger;
        Key key = Key.create((String)"llm.editorRequest");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY_LAST_REQUEST = key;
        KeyWithDefaultValue keyWithDefaultValue = KeyWithDefaultValue.create((String)"llm.processing", (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)keyWithDefaultValue, (String)"create(...)");
        KEY_PROCESSING = keyWithDefaultValue;
        Key key2 = Key.create((String)"llm.editorSupported");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        KEY_EDITOR_SUPPORTED = key2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\r0\r0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcc/unitmesh/devti/inlay/codecomplete/LLMInlayManagerImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "KEY_LAST_REQUEST", "Lcom/intellij/openapi/util/Key;", "Lcc/unitmesh/devti/intentions/action/task/CodeCompletionRequest;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "KEY_PROCESSING", "Lcom/intellij/openapi/util/KeyWithDefaultValue;", "", "KEY_EDITOR_SUPPORTED", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

