/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.inlay.codecomplete;

import cc.unitmesh.devti.inlay.codecomplete.CommandEditorState;
import cc.unitmesh.devti.inlay.codecomplete.InlayDisposeContext;
import cc.unitmesh.devti.inlay.codecomplete.LLMInlayManager;
import cc.unitmesh.devti.inlay.codecomplete.UndoTransparentActionState;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017H\u0002J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcc/unitmesh/devti/inlay/codecomplete/LLMCommandListener;", "Lcom/intellij/openapi/command/CommandListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "activeCommands", "Ljava/util/concurrent/atomic/AtomicInteger;", "startedWithEditor", "Ljava/util/concurrent/atomic/AtomicBoolean;", "undoTransparentActionStamp", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcc/unitmesh/devti/inlay/codecomplete/UndoTransparentActionState;", "commandStarted", "", "event", "Lcom/intellij/openapi/command/CommandEvent;", "commandFinished", "undoTransparentActionStarted", "undoTransparentActionFinished", "getSelectedEditorSafely", "Lcom/intellij/openapi/editor/Editor;", "createCommandState", "Lcc/unitmesh/devti/inlay/codecomplete/CommandEditorState;", "editor", "createUndoTransparentState", "getDocumentStamp", "", "document", "Lcom/intellij/openapi/editor/Document;", "isDocumentModification", "", "first", "second", "isCaretPositionChange", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLLMCommandListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMCommandListener.kt\ncc/unitmesh/devti/inlay/codecomplete/LLMCommandListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,114:1\n11#2:115\n*S KotlinDebug\n*F\n+ 1 LLMCommandListener.kt\ncc/unitmesh/devti/inlay/codecomplete/LLMCommandListener\n*L\n91#1:115\n*E\n"})
public final class LLMCommandListener
implements CommandListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicInteger activeCommands;
    @NotNull
    private final AtomicBoolean startedWithEditor;
    @NotNull
    private final AtomicReference<UndoTransparentActionState> undoTransparentActionStamp;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<CommandEditorState> COMMAND_STATE_KEY;

    public LLMCommandListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.activeCommands = new AtomicInteger();
        this.startedWithEditor = new AtomicBoolean(false);
        this.undoTransparentActionStamp = new AtomicReference();
    }

    public void commandStarted(@NotNull CommandEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.activeCommands.getAndIncrement() > 0) {
            logger.debug("Skipping nested commandStarted. Event: " + event);
            return;
        }
        Editor editor = this.getSelectedEditorSafely(this.project);
        if (editor != null) {
            this.startedWithEditor.set(true);
            COMMAND_STATE_KEY.set((UserDataHolder)editor, (Object)this.createCommandState(editor));
        } else {
            this.startedWithEditor.set(false);
        }
    }

    public void commandFinished(@NotNull CommandEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.activeCommands.decrementAndGet() > 0) {
            logger.debug("Skipping nested commandFinished. Event: " + event);
            return;
        }
        if (!this.startedWithEditor.get()) {
            return;
        }
        Editor editor = this.getSelectedEditorSafely(this.project);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        LLMInlayManager editorManager = LLMInlayManager.Companion.getInstance();
        if (!editorManager.isAvailable(editor2)) {
            return;
        }
        CommandEditorState commandEditorState = (CommandEditorState)COMMAND_STATE_KEY.get((UserDataHolder)editor2);
        if (commandEditorState == null) {
            return;
        }
        CommandEditorState commandStartState = commandEditorState;
        CommandEditorState commandEndState = this.createCommandState(editor2);
        if (this.isDocumentModification(commandStartState, commandEndState)) {
            logger.debug("command modified document: " + event.getCommandName());
            editorManager.editorModified(editor2);
        } else if (this.isCaretPositionChange(commandStartState, commandEndState)) {
            editorManager.disposeInlays(editor2, InlayDisposeContext.CaretChange);
        }
    }

    public void undoTransparentActionStarted() {
        Editor editor;
        Editor editor2 = editor = this.getSelectedEditorSafely(this.project);
        this.undoTransparentActionStamp.set(editor2 != null ? this.createUndoTransparentState(editor2) : null);
    }

    public void undoTransparentActionFinished() {
        UndoTransparentActionState currentEditorStamp = this.undoTransparentActionStamp.get();
        this.undoTransparentActionStamp.set(null);
        Editor editor = this.getSelectedEditorSafely(this.project);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        if (currentEditorStamp == null || editor2 != currentEditorStamp.getEditor()) {
            return;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        if (this.getDocumentStamp(document) == currentEditorStamp.getModificationStamp()) {
            return;
        }
        LLMInlayManager editorManager = LLMInlayManager.Companion.getInstance();
        if (editorManager.isAvailable(editor2)) {
            editorManager.editorModified(editor2);
        }
    }

    private final Editor getSelectedEditorSafely(Project project) {
        Editor editor;
        try {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            editor = fileEditorManager != null ? fileEditorManager.getSelectedTextEditor() : null;
        }
        catch (Exception e) {
            editor = null;
        }
        return editor;
    }

    private final CommandEditorState createCommandState(Editor editor) {
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        long l = this.getDocumentStamp(document);
        VisualPosition visualPosition = editor.getCaretModel().getVisualPosition();
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
        return new CommandEditorState(l, visualPosition);
    }

    private final UndoTransparentActionState createUndoTransparentState(Editor editor) {
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return new UndoTransparentActionState(editor, this.getDocumentStamp(document));
    }

    private final long getDocumentStamp(Document document) {
        return document instanceof DocumentEx ? (long)((DocumentEx)document).getModificationSequence() : document.getModificationStamp();
    }

    private final boolean isDocumentModification(CommandEditorState first, CommandEditorState second) {
        return first.getModificationStamp() != second.getModificationStamp();
    }

    private final boolean isCaretPositionChange(CommandEditorState first, CommandEditorState second) {
        return !Intrinsics.areEqual((Object)first.getVisualPosition(), (Object)second.getVisualPosition());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LLMCommandListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LLMCommandListener.logger = logger;
        Key key = Key.create((String)"llm.commandState");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        COMMAND_STATE_KEY = key;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcc/unitmesh/devti/inlay/codecomplete/LLMCommandListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "COMMAND_STATE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcc/unitmesh/devti/inlay/codecomplete/CommandEditorState;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

