/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.inlay;

import cc.unitmesh.devti.inlay.InlayRenderer;
import cc.unitmesh.devti.util.DispoableUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.util.Key;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/inlay/ComponentInlaysContainer;", "Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "inlays", "", "Lcom/intellij/openapi/editor/Inlay;", "Lcc/unitmesh/devti/inlay/InlayRenderer;", "editorResizeListener", "Ljava/awt/event/ComponentAdapter;", "getEditorResizeListener", "()Ljava/awt/event/ComponentAdapter;", "getInlays", "invalidate", "", "doLayout", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nComponentInlaysContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentInlaysContainer.kt\ncc/unitmesh/devti/inlay/ComponentInlaysContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1855#2,2:95\n1855#2,2:97\n1855#2,2:99\n*S KotlinDebug\n*F\n+ 1 ComponentInlaysContainer.kt\ncc/unitmesh/devti/inlay/ComponentInlaysContainer\n*L\n37#1:95,2\n56#1:97,2\n43#1:99,2\n*E\n"})
public final class ComponentInlaysContainer
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final List<Inlay<InlayRenderer>> inlays;
    @NotNull
    private final ComponentAdapter editorResizeListener;
    @NotNull
    private static final Key<ComponentInlaysContainer> INLAYS_CONTAINER = new Key("INLAYS_CONTAINER");

    public ComponentInlaysContainer(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.inlays = new ArrayList();
        this.editorResizeListener = new ComponentAdapter(this){
            final /* synthetic */ ComponentInlaysContainer this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                this.this$0.revalidate();
                this.this$0.repaint();
            }
        };
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final ComponentAdapter getEditorResizeListener() {
        return this.editorResizeListener;
    }

    @NotNull
    public final List<Inlay<InlayRenderer>> getInlays() {
        return this.inlays;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        RepaintManager.currentManager(this).addInvalidComponent(this);
    }

    @Override
    public void doLayout() {
        Inlay it;
        List<Inlay<InlayRenderer>> inlays = this.inlays;
        if (inlays.isEmpty()) {
            return;
        }
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent content = jComponent;
        Iterable $this$forEach$iv = inlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Inlay)element$iv;
            boolean bl = false;
            InlayRenderer inlayRenderer = (InlayRenderer)it.getRenderer();
            Dimension dimension = ((InlayRenderer)it.getRenderer()).getComponent().getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            inlayRenderer.setInlaySize(dimension);
        }
        ReadAction.run(() -> ComponentInlaysContainer.doLayout$lambda$3(this, inlays));
        if (content.getWidth() < content.getWidth()) {
            content.getParent().doLayout();
        }
        this.setBounds(SwingUtilities.calculateInnerArea(content, null));
        $this$forEach$iv = inlays;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Inlay)element$iv;
            boolean bl = false;
            ((InlayRenderer)it.getRenderer()).getComponent().setSize(((InlayRenderer)it.getRenderer()).getInlaySize());
        }
    }

    private static final void doLayout$lambda$3$lambda$2(List $inlays) {
        Iterable $this$forEach$iv = $inlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Inlay it = (Inlay)element$iv;
            boolean bl = false;
            if (((InlayRenderer)it.getRenderer()).getInlaySize().width == it.getWidthInPixels() && ((InlayRenderer)it.getRenderer()).getInlaySize().height == it.getHeightInPixels()) continue;
            it.update();
        }
    }

    private static final void doLayout$lambda$3(ComponentInlaysContainer this$0, List $inlays) {
        this$0.editor.getInlayModel().execute(true, () -> ComponentInlaysContainer.doLayout$lambda$3$lambda$2($inlays));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcc/unitmesh/devti/inlay/ComponentInlaysContainer$Companion;", "", "<init>", "()V", "INLAYS_CONTAINER", "Lcom/intellij/openapi/util/Key;", "Lcc/unitmesh/devti/inlay/ComponentInlaysContainer;", "addInlay", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcc/unitmesh/devti/inlay/InlayRenderer;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final void addInlay(@NotNull Inlay<InlayRenderer> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            Ref.ObjectRef component2 = new Ref.ObjectRef();
            component2.element = editor2.getUserData(INLAYS_CONTAINER);
            if (component2.element == null) {
                ComponentInlaysContainer newContainer = new ComponentInlaysContainer(editor2);
                editor2.putUserData(INLAYS_CONTAINER, (Object)newContainer);
                editor2.getContentComponent().add(newContainer);
                editor2.getContentComponent().addComponentListener(newContainer.getEditorResizeListener());
                component2.element = newContainer;
            }
            ((ComponentInlaysContainer)component2.element).getInlays().add(inlay);
            ((ComponentInlaysContainer)component2.element).add(((InlayRenderer)inlay.getRenderer()).getComponent());
            DispoableUtilKt.whenDisposed((Disposable)inlay, (Function0<Unit>)((Function0)() -> Companion.addInlay$lambda$0(component2, inlay, editor2)));
        }

        private static final Unit addInlay$lambda$0(Ref.ObjectRef $component, Inlay $inlay, Editor $editor) {
            if (!((ComponentInlaysContainer)$component.element).getInlays().remove($inlay)) {
                return Unit.INSTANCE;
            }
            ((ComponentInlaysContainer)$component.element).remove(((InlayRenderer)$inlay.getRenderer()).getComponent());
            if (((ComponentInlaysContainer)$component.element).getInlays().size() == 0) {
                $editor.getContentComponent().removeComponentListener(((ComponentInlaysContainer)$component.element).getEditorResizeListener());
                $editor.getContentComponent().remove(((InlayRenderer)$inlay.getRenderer()).getComponent());
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

