/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.indexer.scoring;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.history.GitFileHistory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rJ\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcc/unitmesh/devti/indexer/scoring/FileWeightCalculator;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "calculateWeight", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "maxCommitCount", "", "maxLineCount", "calculateClassWeight", "psiClass", "Lcom/intellij/psi/PsiClass;", "getCommitCount", "getLineCount", "getWeightCategory", "", "weight", "core"})
@SourceDebugExtension(value={"SMAP\nFileWeightCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileWeightCalculator.kt\ncc/unitmesh/devti/indexer/scoring/FileWeightCalculator\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n1099#2,3:114\n11#3:117\n*S KotlinDebug\n*F\n+ 1 FileWeightCalculator.kt\ncc/unitmesh/devti/indexer/scoring/FileWeightCalculator\n*L\n92#1:114,3\n20#1:117\n*E\n"})
public final class FileWeightCalculator {
    @NotNull
    public static final FileWeightCalculator INSTANCE = new FileWeightCalculator();
    @NotNull
    private static final Logger logger;

    private FileWeightCalculator() {
    }

    public final float calculateWeight(@NotNull Project project, @NotNull VirtualFile virtualFile, int maxCommitCount, int maxLineCount) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        try {
            int commitCount = this.getCommitCount(project, virtualFile);
            float commitWeight = (float)RangesKt.coerceAtMost((int)commitCount, (int)maxCommitCount) / (float)maxCommitCount;
            int lineCount = this.getLineCount(virtualFile);
            float sizeWeight = (float)RangesKt.coerceAtMost((int)lineCount, (int)maxLineCount) / (float)maxLineCount;
            return RangesKt.coerceIn((float)(0.6f * commitWeight + 0.4f * sizeWeight), (float)0.0f, (float)1.0f);
        }
        catch (Exception e) {
            logger.debug("Failed to calculate weight for " + virtualFile.getPath(), (Throwable)e);
            return 0.5f;
        }
    }

    public static /* synthetic */ float calculateWeight$default(FileWeightCalculator fileWeightCalculator, Project project, VirtualFile virtualFile, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 100;
        }
        if ((n3 & 8) != 0) {
            n2 = 2000;
        }
        return fileWeightCalculator.calculateWeight(project, virtualFile, n, n2);
    }

    public final float calculateClassWeight(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        float fileWeight = FileWeightCalculator.calculateWeight$default(this, project, virtualFile, 0, 0, 12, null);
        float methodCount = ((Number)ActionsKt.runReadAction(() -> FileWeightCalculator.calculateClassWeight$lambda$0(psiClass))).floatValue();
        float fieldCount = ((Number)ActionsKt.runReadAction(() -> FileWeightCalculator.calculateClassWeight$lambda$1(psiClass))).floatValue();
        float totalMembers = RangesKt.coerceAtLeast((float)(methodCount + fieldCount), (float)1.0f);
        float classSize = RangesKt.coerceAtMost((float)totalMembers, (float)10.0f) / 10.0f;
        return RangesKt.coerceIn((float)(0.7f * fileWeight + 0.3f * classSize), (float)0.0f, (float)1.0f);
    }

    private final int getCommitCount(Project project, VirtualFile virtualFile) {
        int n;
        try {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            FilePath filePath2 = filePath;
            n = GitFileHistory.Companion.collectHistory(project, filePath2, new String[0]).size();
        }
        catch (Exception e) {
            logger.debug("Cannot get Git history for " + virtualFile.getName() + ": " + e.getMessage());
            n = 0;
        }
        return n;
    }

    private final int getLineCount(VirtualFile virtualFile) {
        int n;
        try {
            byte[] byArray = virtualFile.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            byte[] byArray2 = byArray;
            String content = new String(byArray2, Charsets.UTF_8);
            CharSequence $this$count$iv = content;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            n = RangesKt.coerceAtLeast((int)count$iv, (int)1);
        }
        catch (Exception e) {
            logger.debug("Cannot get line count for " + virtualFile.getName() + ": " + e.getMessage());
            n = 0;
        }
        return n;
    }

    @NotNull
    public final String getWeightCategory(float weight) {
        return weight >= 0.8f ? "Critical" : (weight >= 0.6f ? "High" : (weight >= 0.4f ? "Medium" : (weight >= 0.2f ? "Low" : "Minimal")));
    }

    private static final float calculateClassWeight$lambda$0(PsiClass $psiClass) {
        return $psiClass.getMethods().length;
    }

    private static final float calculateClassWeight$lambda$1(PsiClass $psiClass) {
        return $psiClass.getFields().length;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileWeightCalculator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FileWeightCalculator.logger = logger;
    }
}

