/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.history;

import cc.unitmesh.devti.history.ChatSessionHistory;
import cc.unitmesh.devti.llms.custom.Message;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStores;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Environments;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u0007J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0007J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcc/unitmesh/devti/history/ChatHistoryService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "storeName", "", "entityType", "environment", "Ljetbrains/exodus/env/Environment;", "getEnvironment", "()Ljetbrains/exodus/env/Environment;", "environment$delegate", "Lkotlin/Lazy;", "entityStore", "Ljetbrains/exodus/entitystore/PersistentEntityStore;", "getEntityStore", "()Ljetbrains/exodus/entitystore/PersistentEntityStore;", "entityStore$delegate", "saveSession", "Lcc/unitmesh/devti/history/ChatSessionHistory;", "name", "messages", "", "Lcc/unitmesh/devti/llms/custom/Message;", "getSession", "sessionId", "getAllSessions", "deleteSession", "", "dispose", "", "core"})
@SourceDebugExtension(value={"SMAP\nChatHistoryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatHistoryService.kt\ncc/unitmesh/devti/history/ChatHistoryService\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n205#2:95\n222#2:97\n222#2:99\n1054#3:96\n1855#3:98\n1856#3:100\n*S KotlinDebug\n*F\n+ 1 ChatHistoryService.kt\ncc/unitmesh/devti/history/ChatHistoryService\n*L\n34#1:95\n53#1:97\n67#1:99\n76#1:96\n63#1:98\n63#1:100\n*E\n"})
public final class ChatHistoryService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final String storeName;
    @NotNull
    private final String entityType;
    @NotNull
    private final Lazy environment$delegate;
    @NotNull
    private final Lazy entityStore$delegate;

    public ChatHistoryService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.storeName = "chatHistory";
        this.entityType = "ChatSession";
        this.environment$delegate = LazyKt.lazy(() -> ChatHistoryService.environment_delegate$lambda$0(this));
        this.entityStore$delegate = LazyKt.lazy(() -> ChatHistoryService.entityStore_delegate$lambda$1(this));
    }

    private final Environment getEnvironment() {
        Lazy lazy = this.environment$delegate;
        return (Environment)lazy.getValue();
    }

    private final PersistentEntityStore getEntityStore() {
        Lazy lazy = this.entityStore$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (PersistentEntityStore)object;
    }

    @NotNull
    public final ChatSessionHistory saveSession(@NotNull String name, @NotNull List<Message> messages) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String sessionId = string;
        ChatSessionHistory history = new ChatSessionHistory(sessionId, name, messages, System.currentTimeMillis());
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String jsonHistory = this_$iv.encodeToString((SerializationStrategy)ChatSessionHistory.Companion.serializer(), (Object)history);
        this.getEntityStore().executeInTransaction(arg_0 -> ChatHistoryService.saveSession$lambda$2(this, sessionId, name, jsonHistory, history, arg_0));
        return history;
    }

    @Nullable
    public final ChatSessionHistory getSession(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Ref.ObjectRef history = new Ref.ObjectRef();
        this.getEntityStore().executeInReadonlyTransaction(arg_0 -> ChatHistoryService.getSession$lambda$4(this, sessionId, history, arg_0));
        return (ChatSessionHistory)history.element;
    }

    @NotNull
    public final List<ChatSessionHistory> getAllSessions() {
        List histories = new ArrayList();
        this.getEntityStore().executeInReadonlyTransaction(arg_0 -> ChatHistoryService.getAllSessions$lambda$6(this, histories, arg_0));
        Iterable $this$sortedByDescending$iv = histories;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ChatSessionHistory it = (ChatSessionHistory)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getCreatedAt());
                it = (ChatSessionHistory)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getCreatedAt()));
            }
        });
    }

    public final boolean deleteSession(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Ref.BooleanRef deleted = new Ref.BooleanRef();
        this.getEntityStore().executeInTransaction(arg_0 -> ChatHistoryService.deleteSession$lambda$9(this, sessionId, deleted, arg_0));
        return deleted.element;
    }

    public void dispose() {
        this.getEntityStore().close();
        this.getEnvironment().close();
    }

    private static final Environment environment_delegate$lambda$0(ChatHistoryService this$0) {
        String string = this$0.project.getBasePath();
        if (string == null) {
            throw new IllegalStateException("Project base path is null");
        }
        String projectBasePath = string;
        String[] stringArray = new String[]{".idea", "autodev", "history"};
        String dbPath = ((Object)Paths.get(projectBasePath, stringArray)).toString();
        return Environments.newInstance((String)dbPath);
    }

    private static final PersistentEntityStoreImpl entityStore_delegate$lambda$1(ChatHistoryService this$0) {
        return PersistentEntityStores.newInstance((Environment)this$0.getEnvironment(), (String)this$0.storeName);
    }

    private static final void saveSession$lambda$2(ChatHistoryService this$0, String $sessionId, String $name, String $jsonHistory, ChatSessionHistory $history, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Entity entity = txn.newEntity(this$0.entityType);
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"newEntity(...)");
        Entity entity2 = entity;
        entity2.setProperty("id", (Comparable)((Object)$sessionId));
        entity2.setProperty("name", (Comparable)((Object)$name));
        entity2.setBlobString("messages", $jsonHistory);
        entity2.setProperty("createdAt", (Comparable)Long.valueOf($history.getCreatedAt()));
    }

    private static final void getSession$lambda$4(ChatHistoryService this$0, String $sessionId, Ref.ObjectRef $history, StoreTransaction txn) {
        block1: {
            Entity entity;
            Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
            EntityIterable entityIterable = txn.find(this$0.entityType, "id", (Comparable)((Object)$sessionId));
            Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"find(...)");
            Entity entity2 = entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)entityIterable));
            if (entity2 == null) break block1;
            Entity it = entity2;
            boolean bl = false;
            String jsonHistory = it.getBlobString("messages");
            if (jsonHistory != null) {
                Json this_$iv = (Json)Json.Default;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                $history.element = this_$iv.decodeFromString((DeserializationStrategy)ChatSessionHistory.Companion.serializer(), jsonHistory);
            }
        }
    }

    private static final void getAllSessions$lambda$6(ChatHistoryService this$0, List $histories, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        EntityIterable entityIterable = txn.getAll(this$0.entityType);
        Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"getAll(...)");
        Iterable $this$forEach$iv = (Iterable)entityIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            String jsonHistory = entity.getBlobString("messages");
            if (jsonHistory == null) continue;
            try {
                Json this_$iv = (Json)Json.Default;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                $histories.add(this_$iv.decodeFromString((DeserializationStrategy)ChatSessionHistory.Companion.serializer(), jsonHistory));
            }
            catch (Exception e) {
                System.out.println((Object)("Error decoding session history: " + entity.getProperty("id") + ", " + e.getMessage()));
            }
        }
    }

    private static final void deleteSession$lambda$9(ChatHistoryService this$0, String $sessionId, Ref.BooleanRef $deleted, StoreTransaction txn) {
        block0: {
            Entity entity;
            Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
            EntityIterable entityIterable = txn.find(this$0.entityType, "id", (Comparable)((Object)$sessionId));
            Intrinsics.checkNotNullExpressionValue((Object)entityIterable, (String)"find(...)");
            Entity entity2 = entity = (Entity)CollectionsKt.firstOrNull((Iterable)((Iterable)entityIterable));
            if (entity2 == null) break block0;
            Entity it = entity2;
            boolean bl = false;
            $deleted.element = it.delete();
        }
    }
}

