/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.toolbar;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.AutoDevIcons;
import cc.unitmesh.devti.gui.toolbar.TimeFormatKt;
import cc.unitmesh.devti.history.ChatHistoryService;
import cc.unitmesh.devti.history.ChatSessionHistory;
import cc.unitmesh.devti.llms.custom.Message;
import cc.unitmesh.devti.observer.agent.AgentState;
import cc.unitmesh.devti.observer.agent.AgentStateService;
import cc.unitmesh.devti.sketch.SketchToolWindow;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcc/unitmesh/devti/gui/toolbar/ViewHistoryAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "deletingSessionId", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isClickOnDeleteButton", "", "point", "Ljava/awt/Point;", "cellComponent", "Ljava/awt/Component;", "cellBounds", "Ljava/awt/Rectangle;", "findComponentAtPoint", "container", "Ljava/awt/Container;", "namePrefix", "loadSessionIntoSketch", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcc/unitmesh/devti/history/ChatSessionHistory;", "update", "SessionListItem", "SessionListCellRenderer", "core"})
@SourceDebugExtension(value={"SMAP\nViewHistoryAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewHistoryAction.kt\ncc/unitmesh/devti/gui/toolbar/ViewHistoryAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,294:1\n1054#2:295\n1855#2,2:297\n288#2,2:299\n1054#2:301\n1549#2:302\n1620#2,3:303\n1#3:296\n*S KotlinDebug\n*F\n+ 1 ViewHistoryAction.kt\ncc/unitmesh/devti/gui/toolbar/ViewHistoryAction\n*L\n139#1:295\n278#1:297,2\n283#1:299,2\n160#1:301\n145#1:302\n145#1:303,3\n*E\n"})
public final class ViewHistoryAction
extends AnAction {
    @Nullable
    private String deletingSessionId;

    public ViewHistoryAction() {
        super(AutoDevBundle.message("action.view.history.text", new Object[0]), AutoDevBundle.message("action.view.history.description", new Object[0]), AutoDevIcons.HISTORY);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ChatHistoryService historyService = (ChatHistoryService)project2.getService(ChatHistoryService.class);
        Ref.ObjectRef sessions = new Ref.ObjectRef();
        Iterable $this$sortedByDescending$iv = historyService.getAllSessions();
        boolean $i$f$sortedByDescending = false;
        sessions.element = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ChatSessionHistory it = (ChatSessionHistory)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getCreatedAt());
                it = (ChatSessionHistory)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getCreatedAt()));
            }
        });
        Ref.ObjectRef currentPopup = new Ref.ObjectRef();
        ViewHistoryAction.actionPerformed$createAndShowPopup((Ref.ObjectRef<JBPopup>)currentPopup, (Ref.ObjectRef<List<ChatSessionHistory>>)sessions, this, project2, e, historyService);
    }

    private final boolean isClickOnDeleteButton(Point point, Component cellComponent, Rectangle cellBounds) {
        if (cellComponent instanceof JPanel) {
            Point pointInCell = new Point(point.x - cellBounds.x, point.y - cellBounds.y);
            return this.findComponentAtPoint((Container)cellComponent, pointInCell, "DELETE_BUTTON");
        }
        return false;
    }

    private final boolean findComponentAtPoint(Container container, Point point, String namePrefix) {
        String string = container.getName();
        boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)namePrefix, (boolean)false, (int)2, null) : false;
        if (bl) {
            return true;
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Point childPoint;
            Component child = container.getComponent(i);
            if (!child.isVisible() || !child.getBounds().contains(point)) continue;
            String string2 = child.getName();
            boolean bl2 = string2 != null ? StringsKt.startsWith$default((String)string2, (String)namePrefix, (boolean)false, (int)2, null) : false;
            if (bl2) {
                return true;
            }
            if (!(child instanceof Container) || !this.findComponentAtPoint((Container)child, childPoint = new Point(point.x - ((Container)child).getX(), point.y - ((Container)child).getY()), namePrefix)) continue;
            return true;
        }
        return false;
    }

    private final void loadSessionIntoSketch(Project project, ChatSessionHistory session) {
        block8: {
            Object object;
            Object v5;
            AgentStateService agentStateService;
            ToolWindow toolWindow;
            block7: {
                SketchToolWindow sketchPanel;
                SketchToolWindow sketchToolWindow;
                block6: {
                    ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
                    ToolWindow toolWindow2 = toolWindowManager.getToolWindow("AutoDev");
                    if (toolWindow2 == null) {
                        return;
                    }
                    toolWindow = toolWindow2;
                    ContentManager contentManager = toolWindow.getContentManager();
                    Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
                    ContentManager contentManager2 = contentManager;
                    Content[] contentArray = contentManager2.getContents();
                    Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                    Object[] objectArray = contentArray;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Content it = (Content)objectArray[i];
                        boolean bl = false;
                        JComponent jComponent = it.getComponent();
                        sketchToolWindow = jComponent instanceof SketchToolWindow ? (SketchToolWindow)((Object)jComponent) : null;
                        if (sketchToolWindow == null) {
                            continue;
                        }
                        break block6;
                    }
                    sketchToolWindow = null;
                }
                SketchToolWindow sketchToolWindow2 = sketchPanel = sketchToolWindow;
                if (sketchToolWindow2 == null) break block8;
                SketchToolWindow it = sketchToolWindow2;
                boolean bl = false;
                it.resetSketchSession();
                agentStateService = (AgentStateService)project.getService(AgentStateService.class);
                agentStateService.resetMessages();
                Iterable $this$forEach$iv = session.getMessages();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Message msg2 = (Message)element$iv;
                    boolean bl2 = false;
                    agentStateService.addMessage(new Message(msg2.getRole(), msg2.getContent()));
                }
                it.displayMessages(session.getMessages());
                Iterable $this$firstOrNull$iv = session.getMessages();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Message msg3 = (Message)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)msg3.getRole(), (Object)"user")) continue;
                    v5 = element$iv;
                    break block7;
                }
                v5 = null;
            }
            if ((object = (Message)v5) != null && (object = ((Message)object).getContent()) != null) {
                Object intention = object;
                boolean bl = false;
                agentStateService.setState(AgentState.copy$default(agentStateService.getState(), (String)intention, null, null, null, null, null, null, 126, null));
            }
            toolWindow.activate(null);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    private static final Unit actionPerformed$createAndShowPopup$lambda$3(Project $project, ChatHistoryService $historyService, Ref.ObjectRef $sessions, ViewHistoryAction this$0, Ref.ObjectRef $currentPopup, AnActionEvent $e, ChatSessionHistory session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        int result = Messages.showYesNoDialog((Project)$project, (String)("\u786e\u5b9a\u8981\u5220\u9664\u4f1a\u8bdd \"" + session.getName() + "\" \u5417\uff1f"), (String)"\u5220\u9664\u4f1a\u8bdd", (Icon)Messages.getQuestionIcon());
        if (result == 0) {
            $historyService.deleteSession(session.getId());
            Iterable $this$sortedByDescending$iv = $historyService.getAllSessions();
            boolean $i$f$sortedByDescending = false;
            $sessions.element = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ChatSessionHistory it = (ChatSessionHistory)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getCreatedAt());
                    it = (ChatSessionHistory)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getCreatedAt()));
                }
            });
            this$0.deletingSessionId = null;
            ViewHistoryAction.actionPerformed$createAndShowPopup((Ref.ObjectRef<JBPopup>)$currentPopup, (Ref.ObjectRef<List<ChatSessionHistory>>)$sessions, this$0, $project, $e, $historyService);
        } else {
            this$0.deletingSessionId = null;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void actionPerformed$createAndShowPopup(Ref.ObjectRef<JBPopup> currentPopup, Ref.ObjectRef<List<ChatSessionHistory>> sessions, ViewHistoryAction this$0, Project project, AnActionEvent $e, ChatHistoryService historyService) {
        block3: {
            void $this$mapTo$iv$iv;
            JBPopup jBPopup = (JBPopup)currentPopup.element;
            if (jBPopup != null) {
                jBPopup.cancel();
            }
            Iterable $this$map$iv = (Iterable)sessions.element;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ChatSessionHistory chatSessionHistory = (ChatSessionHistory)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this$0.new SessionListItem((ChatSessionHistory)it, TimeFormatKt.formatRelativeTime(it.getCreatedAt())));
            }
            List listItems = (List)destination$iv$iv;
            JBList jbList = new JBList((Collection)listItems);
            jbList.setSelectionMode(0);
            jbList.setFixedCellHeight(35);
            Function1 onDeleteSession = arg_0 -> ViewHistoryAction.actionPerformed$createAndShowPopup$lambda$3(project, historyService, sessions, this$0, currentPopup, $e, arg_0);
            jbList.setCellRenderer((ListCellRenderer)this$0.new SessionListCellRenderer(project, (Function1<? super ChatSessionHistory, Unit>)onDeleteSession));
            JBScrollPane scrollPane = new JBScrollPane((Component)jbList);
            scrollPane.setBorder(null);
            int popupWidth = 400;
            int maxPopupHeight = 400;
            int itemHeight = 35;
            int calculatedHeight = RangesKt.coerceAtMost((int)(((List)sessions.element).size() * itemHeight + 20), (int)maxPopupHeight);
            scrollPane.setPreferredSize(new Dimension(popupWidth, calculatedHeight));
            jbList.addMouseListener((MouseListener)new MouseAdapter((JBList<SessionListItem>)jbList, listItems, (Function1<? super ChatSessionHistory, Unit>)onDeleteSession, this$0, currentPopup, project){
                final /* synthetic */ JBList<SessionListItem> $jbList;
                final /* synthetic */ List<SessionListItem> $listItems;
                final /* synthetic */ Function1<ChatSessionHistory, Unit> $onDeleteSession;
                final /* synthetic */ ViewHistoryAction this$0;
                final /* synthetic */ Ref.ObjectRef<JBPopup> $currentPopup;
                final /* synthetic */ Project $project;
                {
                    this.$jbList = $jbList;
                    this.$listItems = $listItems;
                    this.$onDeleteSession = $onDeleteSession;
                    this.this$0 = $receiver;
                    this.$currentPopup = $currentPopup;
                    this.$project = $project;
                }

                public void mouseClicked(MouseEvent e) {
                    int index;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getButton() == 3) {
                        int index2 = this.$jbList.locationToIndex(e.getPoint());
                        if (index2 >= 0) {
                            this.$jbList.setSelectedIndex(index2);
                            ChatSessionHistory selectedSession = this.$listItems.get(index2).getSession();
                            this.$onDeleteSession.invoke((Object)selectedSession);
                        }
                    } else if (e.getButton() == 1 && e.getClickCount() == 1 && (index = this.$jbList.locationToIndex(e.getPoint())) >= 0) {
                        Rectangle cell = this.$jbList.getCellBounds(index, index);
                        Component cellComponent = this.$jbList.getCellRenderer().getListCellRendererComponent((JList)this.$jbList, this.$listItems.get(index), index, false, false);
                        Point point = e.getPoint();
                        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                        Intrinsics.checkNotNull((Object)cellComponent);
                        Intrinsics.checkNotNull((Object)cell);
                        boolean isDeleteButtonClick = ViewHistoryAction.access$isClickOnDeleteButton(this.this$0, point, cellComponent, cell);
                        if (!isDeleteButtonClick && !Intrinsics.areEqual((Object)ViewHistoryAction.access$getDeletingSessionId$p(this.this$0), (Object)this.$listItems.get(index).getSession().getId())) {
                            this.$jbList.setSelectedIndex(index);
                            ChatSessionHistory selectedSession = this.$listItems.get(index).getSession();
                            JBPopup jBPopup = (JBPopup)this.$currentPopup.element;
                            if (jBPopup != null) {
                                jBPopup.closeOk(null);
                            }
                            ViewHistoryAction.access$loadSessionIntoSketch(this.this$0, this.$project, selectedSession);
                        }
                    }
                }
            });
            ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, (JComponent)jbList).setTitle(AutoDevBundle.message("popup.title.session.history", new Object[0])).setMovable(true).setResizable(true).setRequestFocus(true).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true);
            Intrinsics.checkNotNullExpressionValue((Object)componentPopupBuilder, (String)"setCancelOnOtherWindowOpen(...)");
            ComponentPopupBuilder popupBuilder = componentPopupBuilder;
            currentPopup.element = popupBuilder.createPopup();
            JBPopup jBPopup2 = (JBPopup)currentPopup.element;
            if (jBPopup2 != null) {
                jBPopup2.setMinimumSize(new Dimension(300, 150));
            }
            JBPopup jBPopup3 = (JBPopup)currentPopup.element;
            if (jBPopup3 == null) break block3;
            jBPopup3.showInBestPositionFor($e.getDataContext());
        }
    }

    public static final /* synthetic */ boolean access$isClickOnDeleteButton(ViewHistoryAction $this, Point point, Component cellComponent, Rectangle cellBounds) {
        return $this.isClickOnDeleteButton(point, cellComponent, cellBounds);
    }

    public static final /* synthetic */ String access$getDeletingSessionId$p(ViewHistoryAction $this) {
        return $this.deletingSessionId;
    }

    public static final /* synthetic */ void access$loadSessionIntoSketch(ViewHistoryAction $this, Project project, ChatSessionHistory session) {
        $this.loadSessionIntoSketch(project, session);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ@\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0002R\u00020\u00030\u000f2\n\u0010\u0010\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcc/unitmesh/devti/gui/toolbar/ViewHistoryAction$SessionListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcc/unitmesh/devti/gui/toolbar/ViewHistoryAction$SessionListItem;", "Lcc/unitmesh/devti/gui/toolbar/ViewHistoryAction;", "project", "Lcom/intellij/openapi/project/Project;", "onDelete", "Lkotlin/Function1;", "Lcc/unitmesh/devti/history/ChatSessionHistory;", "", "<init>", "(Lcc/unitmesh/devti/gui/toolbar/ViewHistoryAction;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "core"})
    private final class SessionListCellRenderer
    implements ListCellRenderer<SessionListItem> {
        @NotNull
        private final Project project;
        @NotNull
        private final Function1<ChatSessionHistory, Unit> onDelete;

        public SessionListCellRenderer(@NotNull Project project, Function1<? super ChatSessionHistory, Unit> onDelete) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(onDelete, (String)"onDelete");
            this.project = project;
            this.onDelete = onDelete;
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends SessionListItem> list, @NotNull SessionListItem value, int index, boolean selected, boolean hasFocus) {
            Object object;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            JPanel panel2 = new JPanel(new BorderLayout(10, 0));
            panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
            panel2.setName("CELL_PANEL_" + index);
            if (selected) {
                panel2.setBackground(list.getSelectionBackground());
                panel2.setForeground(list.getSelectionForeground());
            } else {
                panel2.setBackground(list.getBackground());
                panel2.setForeground(list.getForeground());
            }
            panel2.setOpaque(true);
            String sessionName = value.getSession().getName();
            int maxLength = 30;
            if (sessionName.length() > maxLength) {
                String string = sessionName.substring(0, maxLength - 3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = string + "...";
            } else {
                object = sessionName;
            }
            String displayName = object;
            JPanel contentPanel = new JPanel(new FlowLayout(0, 0, 0));
            contentPanel.setOpaque(false);
            contentPanel.setName("CONTENT_PANEL_" + index);
            JLabel titleLabel = new JLabel(displayName);
            titleLabel.setFont(titleLabel.getFont().deriveFont(1, 12.0f));
            titleLabel.setToolTipText(sessionName);
            JLabel timeLabel = new JLabel(" - " + value.getRelativeTime());
            timeLabel.setFont(timeLabel.getFont().deriveFont(11.0f));
            if (selected) {
                titleLabel.setForeground(list.getSelectionForeground());
                timeLabel.setForeground(list.getSelectionForeground().darker());
            } else {
                titleLabel.setForeground(list.getForeground());
                timeLabel.setForeground(list.getForeground().darker());
            }
            contentPanel.add(titleLabel);
            contentPanel.add(timeLabel);
            JPanel deleteButtonPanel = new JPanel(new BorderLayout());
            deleteButtonPanel.setOpaque(false);
            deleteButtonPanel.setName("DELETE_BUTTON_PANEL_" + index);
            JButton deleteButton = new JButton();
            deleteButton.setName("DELETE_BUTTON_" + index);
            deleteButton.setOpaque(false);
            deleteButton.setBorderPainted(false);
            deleteButton.setContentAreaFilled(false);
            deleteButton.setFocusPainted(false);
            deleteButton.setIcon(AllIcons.Actions.Close);
            deleteButton.setRolloverIcon(AllIcons.Actions.CloseHovered);
            deleteButton.setCursor(Cursor.getPredefinedCursor(12));
            deleteButton.setPreferredSize(new Dimension(16, 16));
            deleteButton.setToolTipText("\u5220\u9664\u4f1a\u8bdd");
            deleteButton.putClientProperty("sessionId", value.getSession().getId());
            deleteButton.addActionListener(arg_0 -> SessionListCellRenderer.getListCellRendererComponent$lambda$1(ViewHistoryAction.this, value, this, arg_0));
            deleteButtonPanel.add((Component)deleteButton, "Center");
            panel2.add((Component)contentPanel, "Center");
            panel2.add((Component)deleteButtonPanel, "East");
            panel2.setPreferredSize(new Dimension(panel2.getPreferredSize().width, 35));
            return panel2;
        }

        private static final void getListCellRendererComponent$lambda$1(ViewHistoryAction this$0, SessionListItem $value, SessionListCellRenderer this$1, ActionEvent e) {
            block1: {
                Object object = e.getSource();
                if (object == null) break block1;
                Object source = object;
                boolean bl = false;
                if (source instanceof JButton) {
                    this$0.deletingSessionId = $value.getSession().getId();
                    this$1.onDelete.invoke((Object)$value.getSession());
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcc/unitmesh/devti/gui/toolbar/ViewHistoryAction$SessionListItem;", "", "session", "Lcc/unitmesh/devti/history/ChatSessionHistory;", "relativeTime", "", "<init>", "(Lcc/unitmesh/devti/gui/toolbar/ViewHistoryAction;Lcc/unitmesh/devti/history/ChatSessionHistory;Ljava/lang/String;)V", "getSession", "()Lcc/unitmesh/devti/history/ChatSessionHistory;", "getRelativeTime", "()Ljava/lang/String;", "core"})
    private final class SessionListItem {
        @NotNull
        private final ChatSessionHistory session;
        @NotNull
        private final String relativeTime;

        public SessionListItem(@NotNull ChatSessionHistory session, String relativeTime) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)relativeTime, (String)"relativeTime");
            this.session = session;
            this.relativeTime = relativeTime;
        }

        @NotNull
        public final ChatSessionHistory getSession() {
            return this.session;
        }

        @NotNull
        public final String getRelativeTime() {
            return this.relativeTime;
        }
    }
}

