/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.snippet;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.AutoDevNotifications;
import cc.unitmesh.devti.gui.snippet.container.AutoDevContainer;
import cc.unitmesh.devti.provider.RunService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.json.JsonLanguage;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcc/unitmesh/devti/gui/snippet/AutoDevRunAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createDockerFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "core"})
public final class AutoDevRunAction
extends AnAction {
    public AutoDevRunAction() {
        super(AutoDevBundle.message("autodev.run.action", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        LightVirtualFile lightFile2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        VirtualFile file = FileDocumentManager.getInstance().getFile(document2);
        if (file == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        LightVirtualFile lightVirtualFile = lightFile2 = file instanceof LightVirtualFile ? (LightVirtualFile)file : null;
        if (Intrinsics.areEqual((Object)(lightVirtualFile != null ? lightVirtualFile.getLanguage() : null), (Object)JsonLanguage.INSTANCE)) {
            LightVirtualFile lightVirtualFile2 = (LightVirtualFile)file;
            String string = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            LightVirtualFile lightVirtualFile3 = AutoDevContainer.INSTANCE.updateForDevContainer(project2, lightVirtualFile2, string);
            if (lightVirtualFile3 == null) {
                lightVirtualFile3 = lightFile2;
            }
            LightVirtualFile virtualFile = lightVirtualFile3;
            e.getPresentation().setEnabled(RunService.Companion.provider(project2, (VirtualFile)virtualFile) != null);
            return;
        }
        e.getPresentation().setEnabled(RunService.Companion.provider(project2, file) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile scratchFile;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file);
        if (psiFile2 == null) {
            return;
        }
        PsiFile originPsiFile = psiFile2;
        VirtualFile virtualFile2 = scratchFile = ScratchRootType.getInstance().createScratchFile(project2, file.getName(), originPsiFile.getLanguage(), document2.getText());
        String extension = virtualFile2 != null ? virtualFile2.getExtension() : null;
        if (Intrinsics.areEqual((Object)extension, (Object)"Dockerfile")) {
            String string = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            VirtualFile virtualFile3 = this.createDockerFile(project2, string);
            if (virtualFile3 == null) {
                virtualFile3 = scratchFile;
            }
            scratchFile = virtualFile3;
        } else {
            String string;
            String string2 = extension;
            if (string2 != null) {
                String string3 = string2.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"json")) {
                LightVirtualFile lightVirtualFile = (LightVirtualFile)file;
                String string4 = document2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                LightVirtualFile lightVirtualFile2 = AutoDevContainer.INSTANCE.updateForDevContainer(project2, lightVirtualFile, string4);
                scratchFile = lightVirtualFile2 != null ? (VirtualFile)lightVirtualFile2 : scratchFile;
            } else {
                VirtualFile virtualFile4 = scratchFile;
                if (Intrinsics.areEqual((Object)(virtualFile4 != null ? virtualFile4.getExtension() : null), (Object)"sh")) {
                    new File(scratchFile.getPath()).setExecutable(true);
                }
            }
        }
        if (scratchFile == null) {
            AutoDevNotifications.INSTANCE.warn(project2, "Cannot create scratch file");
            return;
        }
        PsiFile psiFile3 = PsiManager.getInstance((Project)project2).findFile(scratchFile);
        if (psiFile3 == null) {
            return;
        }
        PsiFile psiFile4 = psiFile3;
        try {
            String string;
            RunService runService = RunService.Companion.provider(project2, scratchFile);
            if (runService != null && (string = runService.runFile(project2, scratchFile, (PsiElement)psiFile4, true)) != null) {
                v16 = string;
            } else {
                v16 = RunService.Companion.runInCli$default(RunService.Companion, project2, psiFile4, null, 4, null);
                if (v16 == null) {
                    AutoDevNotifications.notify$default(AutoDevNotifications.INSTANCE, project2, "No run service found for " + file.getName(), null, 4, null);
                    v16 = Unit.INSTANCE;
                }
            }
        }
        catch (Exception e2) {
            AutoDevNotifications.notify$default(AutoDevNotifications.INSTANCE, project2, "Run Failed: " + e2.getMessage(), null, 4, null);
        }
    }

    private final VirtualFile createDockerFile(Project project, String text) {
        return (VirtualFile)ActionsKt.runWriteAction(() -> AutoDevRunAction.createDockerFile$lambda$0(project, text));
    }

    private static final VirtualFile createDockerFile$lambda$0(Project $project, String $text) {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$project);
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile projectDir = virtualFile;
        try {
            VirtualFile dockerfile = projectDir.findChild("Dockerfile");
            if (dockerfile == null) {
                dockerfile = projectDir.createChildData(null, "Dockerfile");
            }
            String string = $text;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            dockerfile.setBinaryContent(byArray);
            return dockerfile;
        }
        catch (IOException e) {
            return null;
        }
    }
}

