/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.snippet;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.gui.chat.ui.AutoInputService;
import cc.unitmesh.devti.sketch.AutoSketchMode;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcc/unitmesh/devti/gui/snippet/AutoDevInsertCodeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "core"})
public final class AutoDevInsertCodeAction
extends DumbAwareAction {
    public AutoDevInsertCodeAction() {
        super(AutoDevBundle.message("autodev.insert.action", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        SelectionModel selectionModel = editor2.getSelectionModel().hasSelection() ? editor2.getSelectionModel() : null;
        Object object = selectionModel;
        if (object == null || (object = object.getSelectedText()) == null) {
            String string = editor2.getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            object = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
        }
        Object newText = object;
        Editor editor3 = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        if (editor3 == null) {
            return;
        }
        Editor textEditor = editor3;
        SelectionModel selectionModel2 = textEditor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel2, (String)"getSelectionModel(...)");
        SelectionModel currentSelection = selectionModel2;
        Document document = textEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiFile psiFile2 = (PsiFile)ActionsKt.runReadAction(() -> AutoDevInsertCodeAction.actionPerformed$lambda$0(project2, document2));
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        LightVirtualFile file = virtualFile instanceof LightVirtualFile ? (LightVirtualFile)virtualFile : null;
        LightVirtualFile lightVirtualFile = file;
        if (Intrinsics.areEqual((Object)(lightVirtualFile != null && (lightVirtualFile = lightVirtualFile.getLanguage()) != null ? lightVirtualFile.getDisplayName() : null), (Object)"DevIn")) {
            AutoSketchMode sketchService = (AutoSketchMode)project2.getService(AutoSketchMode.class);
            if (sketchService.getListener() == null) {
                AutoInputService.Companion.getInstance(project2).putText((String)newText);
            } else {
                sketchService.send((String)newText);
            }
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project2).compute(() -> AutoDevInsertCodeAction.actionPerformed$lambda$1(currentSelection, document2, (String)newText, textEditor, project2, psiFile2));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Editor selectedTextEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (selectedTextEditor == null || !selectedTextEditor.getDocument().isWritable()) {
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final PsiFile actionPerformed$lambda$0(Project $project, Document $document) {
        return PsiDocumentManager.getInstance((Project)$project).getPsiFile($document);
    }

    private static final Unit actionPerformed$lambda$1(SelectionModel $currentSelection, Document $document, String $newText, Editor $textEditor, Project $project, PsiFile $psiFile) {
        int offset = 0;
        if ($currentSelection.hasSelection()) {
            offset = $currentSelection.getSelectionStart();
            $document.replaceString($currentSelection.getSelectionStart(), $currentSelection.getSelectionEnd(), (CharSequence)$newText);
        } else {
            offset = $textEditor.getCaretModel().getOffset();
            $document.insertString(offset, (CharSequence)$newText);
        }
        PsiDocumentManager.getInstance((Project)$project).commitDocument($document);
        if ($psiFile != null) {
            CodeStyleManager.getInstance((Project)$project).reformatText($psiFile, offset, offset + $newText.length());
        }
        return Unit.INSTANCE;
    }
}

