/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.planner;

import cc.unitmesh.devti.AutoDevColors;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\b\u0010%\u001a\u00020#H\u0002J\b\u0010&\u001a\u00020#H\u0002J\b\u0010'\u001a\u00020#H\u0002J\b\u0010(\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcc/unitmesh/devti/gui/planner/PlanLoadingPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "loadingMessages", "", "", "messagePane", "Ljavax/swing/JTextPane;", "progressBar", "Ljavax/swing/JProgressBar;", "emojiLabel", "Ljavax/swing/JLabel;", "contentPanel", "glassPanel", "typingTimer", "Ljavax/swing/Timer;", "transitionTimer", "currentText", "charIndex", "", "messageIndex", "opacity", "", "fadeIn", "", "isDarkMode", "gradientTimer", "gradientPosition", "gradientSpeed", "startAnimations", "", "updateTypingAnimation", "updateMessageText", "updateEmojiLabel", "updateColors", "removeNotify", "core"})
public final class PlanLoadingPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final List<String> loadingMessages;
    @NotNull
    private final JTextPane messagePane;
    @NotNull
    private final JProgressBar progressBar;
    @NotNull
    private final JLabel emojiLabel;
    @NotNull
    private final JPanel contentPanel;
    @NotNull
    private final JPanel glassPanel;
    @NotNull
    private final Timer typingTimer;
    @NotNull
    private final Timer transitionTimer;
    @NotNull
    private String currentText;
    private int charIndex;
    private int messageIndex;
    private float opacity;
    private boolean fadeIn;
    private boolean isDarkMode;
    @NotNull
    private final Timer gradientTimer;
    private float gradientPosition;
    private final float gradientSpeed;

    public PlanLoadingPanel(@NotNull Project project) {
        boolean isDarkTheme;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Object[] objectArray = new String[]{"\ud83e\udd14 Analyzing your request...", "\ud83d\udca1 Generating a plan...", "\u2699\ufe0f Processing the steps...", "\u2728 Almost there..."};
        this.loadingMessages = CollectionsKt.mutableListOf((Object[])objectArray);
        this.currentText = "";
        this.fadeIn = true;
        this.gradientSpeed = 0.005f;
        this.isDarkMode = isDarkTheme = UIManager.getLookAndFeelDefaults().getBoolean("ui.theme.is.dark");
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> PlanLoadingPanel._init_$lambda$0(this, isDarkTheme, arg_0));
        this.setLayout(new BorderLayout());
        this.setBorder(JBUI.Borders.empty((int)20));
        this.setOpaque(false);
        BorderLayout borderLayout = new BorderLayout();
        this.glassPanel = new JPanel(borderLayout){

            @Override
            protected void paintComponent(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                int width = this.getWidth();
                int height = this.getHeight();
                RoundRectangle2D roundedRect = new RoundRectangle2D.Float(0.0f, 0.0f, width, height, 15.0f, 15.0f);
                g2d.setClip(roundedRect);
                Color color = isDarkMode ? AutoDevColors.LoadingPanel.INSTANCE.getGRADIENT_COLOR1().darker() : (Color)AutoDevColors.LoadingPanel.INSTANCE.getGRADIENT_COLOR1();
                Intrinsics.checkNotNull((Object)color);
                Color color1 = color;
                Color color2 = isDarkMode ? AutoDevColors.LoadingPanel.INSTANCE.getGRADIENT_COLOR2().darker() : (Color)AutoDevColors.LoadingPanel.INSTANCE.getGRADIENT_COLOR2();
                Intrinsics.checkNotNull((Object)color2);
                Color color22 = color2;
                float pos1 = gradientPosition % 1.0f;
                float pos2 = (gradientPosition + 0.33f) % 1.0f;
                GradientPaint gradient = new GradientPaint((float)width * pos1, 0.0f, color1, (float)width * pos2, height, color22);
                g2d.setPaint(gradient);
                g2d.fill(roundedRect);
                g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
                g2d.setColor(Color.WHITE);
                g2d.fillRect(0, 0, width, height / 2);
                g2d.setComposite(AlphaComposite.getInstance(3, opacity));
                g2d.dispose();
            }
        };
        this.glassPanel.setBorder(new LineBorder((Color)AutoDevColors.LoadingPanel.INSTANCE.getBORDER(), 1, true));
        this.glassPanel.setOpaque(false);
        this.contentPanel = new JPanel(new BorderLayout(10, 10));
        this.contentPanel.setOpaque(false);
        this.contentPanel.setBorder(JBUI.Borders.empty((int)12));
        this.emojiLabel = new JLabel();
        this.emojiLabel.setFont(new Font("Segoe UI Emoji", 0, 24));
        this.emojiLabel.setHorizontalAlignment(0);
        this.emojiLabel.setPreferredSize(new Dimension(40, 40));
        this.messagePane = new JTextPane();
        this.messagePane.setEditable(false);
        this.messagePane.setOpaque(false);
        this.messagePane.setFont(new Font("Monospaced", 0, 14));
        this.messagePane.setBorder(null);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(false);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setOpaque(false);
        this.progressBar.setPreferredSize(new Dimension(0, 5));
        this.progressBar.setUI(new BasicProgressBarUI(){

            @Override
            protected void paintDeterminate(Graphics g, JComponent c) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int width = c.getWidth();
                int height = c.getHeight();
                g2d.setColor((Color)AutoDevColors.LoadingPanel.INSTANCE.getPROGRESS_BACKGROUND());
                g2d.fillRoundRect(0, 0, width, height, height, height);
                int progressWidth = (int)((double)width * this.progressBar.getPercentComplete());
                if (progressWidth > 0) {
                    g2d.setColor((Color)AutoDevColors.LoadingPanel.INSTANCE.getPROGRESS_COLOR());
                    g2d.fillRoundRect(0, 0, progressWidth, height, height, height);
                }
                g2d.dispose();
            }

            @Override
            protected void paintIndeterminate(Graphics g, JComponent c) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                this.paintDeterminate(g, c);
            }
        });
        JPanel textPanel = new JPanel(new BorderLayout(0, 5));
        textPanel.setOpaque(false);
        textPanel.add((Component)this.messagePane, "Center");
        textPanel.add((Component)this.progressBar, "South");
        this.contentPanel.add((Component)this.emojiLabel, "West");
        this.contentPanel.add((Component)textPanel, "Center");
        this.glassPanel.add((Component)this.contentPanel, "Center");
        this.add((Component)this.glassPanel, "Center");
        this.typingTimer = new Timer(60, arg_0 -> PlanLoadingPanel._init_$lambda$1(this, arg_0));
        this.transitionTimer = new Timer(20, arg_0 -> PlanLoadingPanel._init_$lambda$2(this, arg_0));
        this.gradientTimer = new Timer(50, arg_0 -> PlanLoadingPanel._init_$lambda$3(this, arg_0));
        this.updateEmojiLabel();
        this.startAnimations();
        this.updateColors();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void startAnimations() {
        this.fadeIn = true;
        this.opacity = 0.0f;
        this.transitionTimer.start();
        this.gradientTimer.start();
    }

    private final void updateTypingAnimation() {
        String message = this.loadingMessages.get(this.messageIndex);
        String string = message.substring(StringsKt.indexOf$default((CharSequence)message, (char)' ', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String textPart = string;
        if (this.charIndex < textPart.length()) {
            this.currentText = this.currentText + textPart.charAt(this.charIndex);
            this.updateMessageText();
            int n = this.charIndex;
            this.charIndex = n + 1;
            int progress = (int)((float)this.charIndex / (float)textPart.length() * (float)100);
            this.progressBar.setValue(progress);
        } else {
            this.typingTimer.stop();
            Timer pauseTimer = new Timer(1200, arg_0 -> PlanLoadingPanel.updateTypingAnimation$lambda$4(this, arg_0));
            pauseTimer.setRepeats(false);
            pauseTimer.start();
        }
    }

    private final void updateMessageText() {
        StyledDocument doc = this.messagePane.getStyledDocument();
        Style style = this.messagePane.addStyle("MessageStyle", null);
        StyleConstants.setForeground(style, (Color)AutoDevColors.LoadingPanel.INSTANCE.getFOREGROUND());
        StyleConstants.setFontFamily(style, "Monospaced");
        StyleConstants.setFontSize(style, 14);
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, this.currentText, style);
            StyleConstants.setForeground(style, (Color)AutoDevColors.LoadingPanel.INSTANCE.getPROGRESS_COLOR());
            doc.insertString(doc.getLength(), "|", style);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private final void updateEmojiLabel() {
        String message = this.loadingMessages.get(this.messageIndex);
        String string = message.substring(0, StringsKt.indexOf$default((CharSequence)message, (char)' ', (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String emoji = string;
        this.emojiLabel.setText(emoji);
    }

    private final void updateColors() {
        this.setBackground((Color)AutoDevColors.LoadingPanel.INSTANCE.getBACKGROUND());
        this.messagePane.setForeground((Color)AutoDevColors.LoadingPanel.INSTANCE.getFOREGROUND());
        this.glassPanel.setBorder(new LineBorder((Color)AutoDevColors.LoadingPanel.INSTANCE.getBORDER(), 1, true));
        this.updateMessageText();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.typingTimer.stop();
        this.transitionTimer.stop();
        this.gradientTimer.stop();
    }

    private static final void _init_$lambda$0(PlanLoadingPanel this$0, boolean $isDarkTheme, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.isDarkMode = $isDarkTheme;
        this$0.updateColors();
        this$0.glassPanel.repaint();
    }

    private static final void _init_$lambda$1(PlanLoadingPanel this$0, ActionEvent e) {
        this$0.updateTypingAnimation();
    }

    private static final void _init_$lambda$2(PlanLoadingPanel this$0, ActionEvent e) {
        if (this$0.fadeIn) {
            this$0.opacity += 0.05f;
            if (this$0.opacity >= 1.0f) {
                this$0.opacity = 1.0f;
                this$0.fadeIn = false;
                this$0.transitionTimer.stop();
                this$0.typingTimer.start();
            }
        } else {
            this$0.opacity -= 0.05f;
            if (this$0.opacity <= 0.0f) {
                this$0.opacity = 0.0f;
                this$0.fadeIn = true;
                this$0.transitionTimer.stop();
                this$0.charIndex = 0;
                this$0.currentText = "";
                this$0.messageIndex = (this$0.messageIndex + 1) % this$0.loadingMessages.size();
                this$0.updateEmojiLabel();
                this$0.transitionTimer.start();
            }
        }
        this$0.glassPanel.repaint();
    }

    private static final void _init_$lambda$3(PlanLoadingPanel this$0, ActionEvent e) {
        this$0.gradientPosition += this$0.gradientSpeed;
        if (this$0.gradientPosition > 1.0f) {
            this$0.gradientPosition = 0.0f;
        }
        this$0.glassPanel.repaint();
    }

    private static final void updateTypingAnimation$lambda$4(PlanLoadingPanel this$0, ActionEvent e) {
        ActionEvent actionEvent = e;
        Intrinsics.checkNotNull((Object)actionEvent);
        Object object = actionEvent.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.Timer");
        ((Timer)object).stop();
        this$0.fadeIn = false;
        this$0.transitionTimer.start();
    }
}

