/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.component;

import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\tJ\b\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcc/unitmesh/devti/gui/component/LoadingSpinner;", "Ljavax/swing/JPanel;", "<init>", "()V", "step", "", "timer", "Ljavax/swing/Timer;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "getPreferredSize", "Ljava/awt/Dimension;", "startAnimation", "stopAnimation", "removeNotify", "core"})
public final class LoadingSpinner
extends JPanel {
    private int step;
    @Nullable
    private Timer timer;

    public LoadingSpinner() {
        this.setOpaque(false);
        this.startAnimation();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float width = this.getWidth();
        float height = this.getHeight();
        float centerX = width / (float)2;
        float centerY = height / (float)2;
        float radius = Math.min(width, height) / (float)2 - (float)5;
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(new BasicStroke(3.0f));
        int currentStep = this.step >= 12 ? 0 : this.step;
        for (int i = 0; i < 12; ++i) {
            g2d.setColor((Color)new JBColor(new Color(47, 99, 162, 255 - (i + 12 - currentStep) % 12 * 20), new Color(88, 157, 246, 255 - (i + 12 - currentStep) % 12 * 20)));
            int startAngle = i * 30;
            g2d.drawArc((int)(centerX - radius), (int)(centerY - radius), (int)(radius * (float)2), (int)(radius * (float)2), startAngle, 15);
        }
        g2d.setStroke(oldStroke);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(40, 40);
    }

    public final void startAnimation() {
        this.stopAnimation();
        this.step = 0;
        Timer timer = this.timer = new Timer(100, null);
        Intrinsics.checkNotNull((Object)timer);
        timer.addActionListener(arg_0 -> LoadingSpinner.startAnimation$lambda$0(this, arg_0));
        Timer timer2 = this.timer;
        Intrinsics.checkNotNull((Object)timer2);
        timer2.start();
    }

    public final void stopAnimation() {
        Timer timer = this.timer;
        if (timer != null) {
            timer.stop();
        }
        this.timer = null;
    }

    @Override
    public void removeNotify() {
        this.stopAnimation();
        super.removeNotify();
    }

    private static final void startAnimation$lambda$0(LoadingSpinner this$0, ActionEvent it) {
        this$0.step = (this$0.step + 1) % 12;
        this$0.repaint();
    }
}

