/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.view;

import cc.unitmesh.devti.AutoDevColors;
import cc.unitmesh.devti.gui.chat.message.ChatRole;
import cc.unitmesh.devti.inline.AutoDevInlineChatPanelKt;
import cc.unitmesh.devti.sketch.ui.ExtensionLangSketch;
import cc.unitmesh.devti.sketch.ui.LangSketch;
import cc.unitmesh.devti.sketch.ui.LanguageSketchProvider;
import cc.unitmesh.devti.sketch.ui.MarkdownPreviewHighlightSketch;
import cc.unitmesh.devti.sketch.ui.code.CodeHighlightSketch;
import cc.unitmesh.devti.sketch.ui.code.EditorFragment;
import cc.unitmesh.devti.util.parser.CodeFence;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcc/unitmesh/devti/gui/chat/view/MessageView;", "Lcom/intellij/ui/components/JBPanel;", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "role", "Lcc/unitmesh/devti/gui/chat/message/ChatRole;", "displayText", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcc/unitmesh/devti/gui/chat/message/ChatRole;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getMessage", "()Ljava/lang/String;", "getRole", "()Lcc/unitmesh/devti/gui/chat/message/ChatRole;", "myList", "Ljavax/swing/JPanel;", "blockViews", "", "Lcc/unitmesh/devti/sketch/ui/LangSketch;", "initializePreAllocatedBlocks", "", "createToolbar", "createToolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "onFinish", "text", "updateContent", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMessageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageView.kt\ncc/unitmesh/devti/gui/chat/view/MessageView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n766#2:219\n857#2,2:220\n1855#2,2:222\n766#2:224\n857#2,2:225\n1855#2,2:227\n1864#2,3:229\n*S KotlinDebug\n*F\n+ 1 MessageView.kt\ncc/unitmesh/devti/gui/chat/view/MessageView\n*L\n125#1:219\n125#1:220,2\n125#1:222,2\n129#1:224\n129#1:225,2\n129#1:227,2\n140#1:229,3\n*E\n"})
public final class MessageView
extends JBPanel<MessageView> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String message;
    @NotNull
    private final ChatRole role;
    @NotNull
    private String displayText;
    @NotNull
    private JPanel myList;
    @NotNull
    private final List<LangSketch> blockViews;

    public MessageView(@NotNull Project project, @NotNull String message, @NotNull ChatRole role, @NotNull String displayText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Intrinsics.checkNotNullParameter((Object)displayText, (String)"displayText");
        this.project = project;
        this.message = message;
        this.role = role;
        this.displayText = displayText;
        this.myList = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)0)));
        this.blockViews = new ArrayList();
        this.initializePreAllocatedBlocks(this.project);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.setLayout(new BorderLayout(0, 0));
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel toolbarPanel = this.createToolbar();
        centerPanel.add((Component)toolbarPanel, "North");
        if (this.role == ChatRole.User) {
            Ref.ObjectRef bg = new Ref.ObjectRef();
            bg.element = AutoDevColors.INSTANCE.getUSER_ROLE_BG();
            ActionsKt.runInEdt$default(null, () -> MessageView._init_$lambda$2(this, bg), (int)1, null);
            toolbarPanel.setBackground((Color)bg.element);
            centerPanel.setBackground((Color)bg.element);
        }
        centerPanel.add((Component)this.myList, "Center");
        this.add(centerPanel, "Center");
        ApplicationManager.getApplication().invokeLater(() -> MessageView._init_$lambda$3(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final ChatRole getRole() {
        return this.role;
    }

    private final void initializePreAllocatedBlocks(Project project) {
        int n = 32;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            ActionsKt.runInEdt$default(null, () -> MessageView.initializePreAllocatedBlocks$lambda$1$lambda$0(project, this), (int)1, null);
        }
    }

    private final JPanel createToolbar() {
        JLabel jLabel;
        JLabel $this$createToolbar_u24lambda_u244 = jLabel = new JLabel();
        boolean bl = false;
        $this$createToolbar_u24lambda_u244.setFont((Font)JBFont.h4());
        $this$createToolbar_u24lambda_u244.setText(switch (WhenMappings.$EnumSwitchMapping$0[this.role.ordinal()]) {
            case 1 -> "System";
            case 2 -> "Assistant";
            case 3 -> "User";
            default -> throw new NoWhenBranchMatchedException();
        });
        $this$createToolbar_u24lambda_u244.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        JLabel authorLabel = jLabel;
        DefaultActionGroup actionGroup = new DefaultActionGroup(this.createToolbarActions());
        Object object = ActionManager.getInstance().createActionToolbar("MessageViewToolbar", (ActionGroup)actionGroup, true);
        ActionToolbar $this$createToolbar_u24lambda_u245 = object;
        boolean bl2 = false;
        $this$createToolbar_u24lambda_u245.setTargetComponent((JComponent)((Object)this));
        ActionToolbar actionToolbar = object;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"apply(...)");
        ActionToolbar toolbar = actionToolbar;
        Object $this$createToolbar_u24lambda_u246 = object = new JPanel(new BorderLayout());
        boolean bl3 = false;
        ((Container)$this$createToolbar_u24lambda_u246).add((Component)authorLabel, "West");
        ((Container)$this$createToolbar_u24lambda_u246).add((Component)toolbar.getComponent(), "East");
        Object toolbarPanel = object;
        ((JComponent)toolbarPanel).setBorder(JBUI.Borders.customLine((Color)UIUtil.getBoundsColor(), (int)0, (int)0, (int)1, (int)0));
        return toolbarPanel;
    }

    private final List<AnAction> createToolbarActions() {
        Icon icon = AllIcons.Actions.Copy;
        AnAction copyAction2 = new AnAction(this, icon){
            final /* synthetic */ MessageView this$0;
            {
                this.this$0 = $receiver;
                super("Copy", "Copy text", $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection selection = new StringSelection(MessageView.access$getDisplayText$p(this.this$0));
                clipboard.setContents(selection, null);
            }
        };
        return CollectionsKt.listOf((Object)copyAction2);
    }

    public final void onFinish(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.displayText = text;
        ActionsKt.runInEdt$default(null, () -> MessageView.onFinish$lambda$11(this, text), (int)1, null);
    }

    public final void updateContent(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.displayText = text;
        List<CodeFence> codeFenceList = CodeFence.Companion.parseAll(text);
        ActionsKt.runInEdt$default(null, () -> MessageView.updateContent$lambda$14(codeFenceList, this), (int)1, null);
    }

    private static final Unit initializePreAllocatedBlocks$lambda$1$lambda$0(Project $project, MessageView this$0) {
        CodeHighlightSketch codeBlockViewer = new CodeHighlightSketch($project, "", (Language)PlainTextLanguage.INSTANCE, 0, null, false, false, false, 248, null);
        this$0.blockViews.add(codeBlockViewer);
        this$0.myList.add((Component)((Object)codeBlockViewer));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(MessageView this$0, Ref.ObjectRef $bg) {
        DialogPanel comp = cc.unitmesh.devti.gui.chat.view.MessageView$Companion.createSingleTextView$default(Companion, this$0.project, this$0.message, null, (JBColor)$bg.element, true, 4, null);
        this$0.myList.add((Component)comp);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(MessageView this$0) {
        this$0.revalidate();
        this$0.repaint();
    }

    private static final Unit onFinish$lambda$11(MessageView this$0, String $text) {
        LangSketch it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this$0.blockViews;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (LangSketch)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it.getViewText()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LangSketch it2 = (LangSketch)element$iv;
            boolean bl = false;
            it2.onDoneStream($text);
        }
        $this$filter$iv = this$0.blockViews;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (LangSketch)element$iv$iv;
            boolean bl3 = false;
            boolean bl4 = ((CharSequence)it.getViewText()).length() == 0;
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LangSketch it3 = (LangSketch)element$iv;
            boolean bl5 = false;
            this$0.myList.remove(it3.getComponent());
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updateContent$lambda$14(List $codeFenceList, MessageView this$0) {
        Iterable $this$forEachIndexed$iv = $codeFenceList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void codeFence;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CodeFence codeFence2 = (CodeFence)item$iv;
            int index = n;
            boolean bl = false;
            if (index < this$0.blockViews.size()) {
                LangSketch langSketch;
                ExtensionLangSketch langSketch2 = null;
                if (codeFence.getOriginLanguage() != null && codeFence.isComplete() && !(this$0.blockViews.get(index) instanceof ExtensionLangSketch)) {
                    LanguageSketchProvider languageSketchProvider = LanguageSketchProvider.Companion.provide(codeFence.getOriginLanguage());
                    langSketch2 = languageSketchProvider != null ? languageSketchProvider.create(this$0.project, codeFence.getText()) : null;
                }
                String string = codeFence.getLanguage().getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                boolean isCanHtml = Intrinsics.areEqual((Object)string2, (Object)"markdown");
                if (isCanHtml && codeFence.isComplete() && !(this$0.blockViews.get(index) instanceof ExtensionLangSketch)) {
                    langSketch2 = new MarkdownPreviewHighlightSketch(this$0.project, codeFence.getText());
                }
                if (langSketch2 != null) {
                    LangSketch oldComponent = this$0.blockViews.get(index);
                    this$0.blockViews.set(index, langSketch2);
                    this$0.myList.remove(index);
                    this$0.myList.add((Component)langSketch2.getComponent(), index);
                    oldComponent.dispose();
                    continue;
                }
                LangSketch $this$updateContent_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412 = langSketch = this$0.blockViews.get(index);
                boolean bl2 = false;
                $this$updateContent_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.updateLanguage(codeFence.getLanguage(), codeFence.getOriginLanguage());
                $this$updateContent_u24lambda_u2414_u24lambda_u2413_u24lambda_u2412.updateViewText(codeFence.getText(), codeFence.isComplete());
                continue;
            }
            CodeHighlightSketch codeBlockViewer = new CodeHighlightSketch(this$0.project, codeFence.getText(), (Language)PlainTextLanguage.INSTANCE, 0, null, false, false, false, 248, null);
            this$0.blockViews.add(codeBlockViewer);
            this$0.myList.add(codeBlockViewer.getComponent());
        }
        while (this$0.blockViews.size() > $codeFenceList.size()) {
            int lastIndex = CollectionsKt.getLastIndex(this$0.blockViews);
            try {
                this$0.blockViews.remove(lastIndex);
                this$0.myList.remove(lastIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this$0.myList.revalidate();
        this$0.myList.repaint();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$getDisplayText$p(MessageView $this) {
        return $this.displayText;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcc/unitmesh/devti/gui/chat/view/MessageView$Companion;", "", "<init>", "()V", "createSingleTextView", "Lcom/intellij/openapi/ui/DialogPanel;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "language", "background", "Lcom/intellij/ui/JBColor;", "isUser", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DialogPanel createSingleTextView(@NotNull Project project, @NotNull String text, @NotNull String language, @Nullable JBColor background, boolean isUser) {
            CodeHighlightSketch codeHighlightSketch;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            CodeHighlightSketch $this$createSingleTextView_u24lambda_u240 = codeHighlightSketch = new CodeHighlightSketch(project, text, CodeFence.Companion.findLanguage(language), 0, null, false, false, isUser, 120, null);
            boolean bl = false;
            CodeHighlightSketch.initEditor$default($this$createSingleTextView_u24lambda_u240, text, null, 2, null);
            CodeHighlightSketch codeBlockViewer = codeHighlightSketch;
            EditorFragment editorFragment = codeBlockViewer.getEditorFragment();
            Intrinsics.checkNotNull((Object)editorFragment);
            editorFragment.setCollapsed(true);
            EditorFragment editorFragment2 = codeBlockViewer.getEditorFragment();
            Intrinsics.checkNotNull((Object)editorFragment2);
            editorFragment2.updateExpandCollapseLabel();
            if (background != null) {
                codeBlockViewer.setBorder((Border)JBUI.Borders.empty());
                codeBlockViewer.setBackground((Color)background);
                EditorFragment editorFragment3 = codeBlockViewer.getEditorFragment();
                if (editorFragment3 != null && (editorFragment3 = editorFragment3.getEditor()) != null) {
                    editorFragment3.setBackgroundColor((Color)background);
                }
            }
            DialogPanel panel2 = BuilderKt.panel(arg_0 -> Companion.createSingleTextView$lambda$2(codeBlockViewer, arg_0));
            return panel2;
        }

        public static /* synthetic */ DialogPanel createSingleTextView$default(Companion companion, Project project, String string, String string2, JBColor jBColor, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = "markdown";
            }
            if ((n & 8) != 0) {
                jBColor = null;
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            return companion.createSingleTextView(project, string, string2, jBColor, bl);
        }

        private static final Unit createSingleTextView$lambda$2$lambda$1(CodeHighlightSketch $codeBlockViewer, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            AutoDevInlineChatPanelKt.fullWidth($this$row.cell((JComponent)((Object)$codeBlockViewer)));
            return Unit.INSTANCE;
        }

        private static final Unit createSingleTextView$lambda$2(CodeHighlightSketch $codeBlockViewer, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, arg_0 -> Companion.createSingleTextView$lambda$2$lambda$1($codeBlockViewer, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChatRole.values().length];
            try {
                nArray[ChatRole.System.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatRole.Assistant.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatRole.User.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

