/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.ui.file;

import cc.unitmesh.devti.gui.chat.ui.file.FilePresentation;
import cc.unitmesh.devti.gui.chat.ui.file.WorkspaceFileSearchPopup;
import cc.unitmesh.devti.util.ProjectFileUtilKt;
import cc.unitmesh.devti.vcs.gitignore.GitIgnoreUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.AdjustmentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00bf\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0007*\u0003),j\u0018\u0000 n2\u00020\u0001:\u0002noB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010%\u001a\u00020\bH\u0002J\b\u0010&\u001a\u00020\bH\u0002J\b\u0010'\u001a\u00020\bH\u0002J\r\u0010(\u001a\u00020)H\u0002\u00a2\u0006\u0002\u0010*J\r\u0010+\u001a\u00020,H\u0002\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u00020\bH\u0002J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020\u0016H\u0002J\b\u00102\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020$H\u0002J\u0010\u00108\u001a\u00020\b2\u0006\u00107\u001a\u00020$H\u0002J\b\u00109\u001a\u00020\bH\u0002J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0002J\u0016\u0010;\u001a\u00020\b2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0002J\u0018\u0010=\u001a\u0012\u0012\u0004\u0012\u00020\u000f0>j\b\u0012\u0004\u0012\u00020\u000f`?H\u0002J\b\u0010@\u001a\u00020!H\u0002J\b\u0010A\u001a\u00020\bH\u0002J\u0010\u0010B\u001a\u00020\b2\u0006\u00107\u001a\u00020$H\u0002J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u00107\u001a\u00020$H\u0002J\u0018\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020\u000f2\u0006\u00107\u001a\u00020$H\u0002J$\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u00107\u001a\u00020$2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0002J*\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0002J\u0016\u0010K\u001a\u00020\b2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u0002J\b\u0010M\u001a\u00020\bH\u0002J\b\u0010N\u001a\u00020\bH\u0002J\u0010\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020!H\u0002J\b\u0010Q\u001a\u00020\bH\u0002J\b\u0010R\u001a\u00020!H\u0002J\b\u0010S\u001a\u00020\bH\u0002J\b\u0010T\u001a\u00020\bH\u0002J\b\u0010U\u001a\u00020\bH\u0002J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020$0WH\u0002J\u0010\u0010X\u001a\u00020\b2\u0006\u0010Y\u001a\u00020ZH\u0002J\u000e\u0010[\u001a\b\u0012\u0004\u0012\u00020$0WH\u0002J\u0018\u0010\\\u001a\u00020\b2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010]\u001a\u00020^H\u0002J\u001e\u0010_\u001a\u00020!2\u0006\u0010E\u001a\u00020\u00072\f\u0010`\u001a\b\u0012\u0004\u0012\u00020$0WH\u0002J\u001e\u0010a\u001a\u00020\b2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010]\u001a\u00020^H\u0002J\b\u0010c\u001a\u00020\bH\u0002J\b\u0010d\u001a\u00020\bH\u0002J\u000e\u0010e\u001a\u00020\b2\u0006\u0010f\u001a\u00020gJ\b\u0010h\u001a\u00020\fH\u0002J\r\u0010i\u001a\u00020jH\u0002\u00a2\u0006\u0002\u0010kJ\b\u0010l\u001a\u00020\bH\u0002J\b\u0010m\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000f0\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006p"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "onFilesSelected", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "fileListModel", "Ljavax/swing/DefaultListModel;", "Lcc/unitmesh/devti/gui/chat/ui/file/FilePresentation;", "fileList", "Lcom/intellij/ui/components/JBList;", "kotlin.jvm.PlatformType", "searchField", "Lcom/intellij/ui/SearchTextField;", "contentPanel", "Ljavax/swing/JPanel;", "loadingLabel", "Lcom/intellij/ui/components/JBLabel;", "minPopupSize", "Ljava/awt/Dimension;", "searchAlarm", "Lcom/intellij/util/Alarm;", "recentFiles", "", "projectFiles", "isLoadingFiles", "", "hasLoadedAllFiles", "currentSearchQuery", "", "setupUI", "configureSearchField", "configureFileList", "createFileListKeyListener", "cc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup$createFileListKeyListener$1", "()Lcc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup$createFileListKeyListener$1;", "createFileListMouseListener", "cc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup$createFileListMouseListener$1", "()Lcc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup$createFileListMouseListener$1;", "setupLayout", "createScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "createStatusPanel", "transferFocusToFileList", "shouldLoadMoreFiles", "scrollBar", "Ljava/awt/Adjustable;", "scheduleSearch", "query", "performSearch", "showRecentAndLoadedFiles", "buildFileListForDisplay", "displayFiles", "files", "createFileSortComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "shouldStartLoadingProjectFiles", "showRecentFiles", "searchFilesWithQuery", "searchLoadedFiles", "fileMatchesQuery", "file", "searchIndexedFiles", "existingFiles", "combineAndSortResults", "matchingLoaded", "additionalFiles", "displaySearchResults", "results", "loadRecentFiles", "startLoadingProjectFiles", "setLoadingState", "loading", "updateUIAfterLoading", "shouldShowRecentAndLoadedFiles", "loadMoreProjectFiles", "updateUIAfterLoadingMore", "addNewlyLoadedFilesToList", "getCurrentDisplayedPaths", "", "loadMoreProjectFilesInternal", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getAllLoadedPaths", "updateProgressIndicator", "count", "", "shouldAddFile", "loadedPaths", "updateProjectFilesState", "newFiles", "selectFirstItemIfAvailable", "selectFiles", "show", "component", "Ljavax/swing/JComponent;", "createPopup", "createPopupListener", "cc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup$createPopupListener$1", "()Lcc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup$createPopupListener$1;", "cleanupResources", "dispose", "Companion", "FileListCellRenderer", "core"})
@SourceDebugExtension(value={"SMAP\nWorkspaceFileSearchPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceFileSearchPopup.kt\ncc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,586:1\n1549#2:587\n1620#2,3:588\n766#2:591\n857#2,2:592\n1855#2,2:594\n1855#2,2:596\n766#2:598\n857#2,2:599\n1549#2:601\n1620#2,3:602\n766#2:605\n857#2,2:606\n1549#2:608\n1620#2,3:609\n1855#2,2:612\n766#2:614\n857#2,2:615\n1855#2,2:617\n1549#2:619\n1620#2,3:620\n766#2:623\n857#2,2:624\n1855#2,2:626\n1603#2,9:628\n1855#2:637\n1856#2:639\n1612#2:640\n1549#2:641\n1620#2,3:642\n1549#2:645\n1620#2,3:646\n1#3:638\n*S KotlinDebug\n*F\n+ 1 WorkspaceFileSearchPopup.kt\ncc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup\n*L\n220#1:587\n220#1:588,3\n221#1:591\n221#1:592,2\n227#1:594,2\n239#1:596,2\n257#1:598\n257#1:599,2\n260#1:601\n260#1:602,3\n261#1:605\n261#1:606,2\n276#1:608\n276#1:609,3\n302#1:612,2\n311#1:614\n311#1:615,2\n312#1:617,2\n389#1:619\n389#1:620,3\n392#1:623\n392#1:624,2\n394#1:626,2\n399#1:628,9\n399#1:637\n399#1:639\n399#1:640\n440#1:641\n440#1:642,3\n481#1:645\n481#1:646,3\n399#1:638\n*E\n"})
public final class WorkspaceFileSearchPopup
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Function1<List<? extends VirtualFile>, Unit> onFilesSelected;
    @Nullable
    private JBPopup popup;
    @NotNull
    private final DefaultListModel<FilePresentation> fileListModel;
    @NotNull
    private final JBList<FilePresentation> fileList;
    @NotNull
    private final SearchTextField searchField;
    @NotNull
    private final JPanel contentPanel;
    @NotNull
    private final JBLabel loadingLabel;
    @NotNull
    private final Dimension minPopupSize;
    @NotNull
    private final Alarm searchAlarm;
    @NotNull
    private final List<FilePresentation> recentFiles;
    @NotNull
    private final List<FilePresentation> projectFiles;
    private boolean isLoadingFiles;
    private boolean hasLoadedAllFiles;
    @NotNull
    private String currentSearchQuery;
    @NotNull
    private static final Logger LOG;
    private static final int MAX_RECENT_FILES = 30;
    private static final int SEARCH_DELAY_MS = 300;
    private static final int BATCH_SIZE = 50;
    private static final int MAX_FILES_TO_SCAN = 10000;
    private static final int PROGRESS_UPDATE_INTERVAL = 100;
    private static final int SCROLL_THRESHOLD = 10;
    private static final int MIN_QUERY_LENGTH = 2;

    /*
     * WARNING - void declaration
     */
    public WorkspaceFileSearchPopup(@NotNull Project project, @NotNull Function1<? super List<? extends VirtualFile>, Unit> onFilesSelected) {
        void $this$loadingLabel_u24lambda_u241;
        JBList $this$fileList_u24lambda_u240;
        JBList jBList;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onFilesSelected, (String)"onFilesSelected");
        this.project = project;
        this.onFilesSelected = onFilesSelected;
        this.fileListModel = new DefaultListModel();
        JBList jBList2 = jBList = new JBList((ListModel)this.fileListModel);
        WorkspaceFileSearchPopup workspaceFileSearchPopup = this;
        boolean bl = false;
        $this$fileList_u24lambda_u240.setCellRenderer((ListCellRenderer)new FileListCellRenderer());
        $this$fileList_u24lambda_u240.setSelectionMode(2);
        workspaceFileSearchPopup.fileList = jBList;
        this.searchField = new SearchTextField();
        this.contentPanel = new JPanel(new BorderLayout());
        $this$fileList_u24lambda_u240 = jBList = new JBLabel("Loading files...", 0);
        workspaceFileSearchPopup = this;
        boolean bl2 = false;
        $this$loadingLabel_u24lambda_u241.setVisible(false);
        workspaceFileSearchPopup.loadingLabel = jBList;
        this.minPopupSize = new Dimension(480, 320);
        this.searchAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.recentFiles = new ArrayList();
        this.projectFiles = new ArrayList();
        this.currentSearchQuery = "";
        this.setupUI();
        this.loadRecentFiles();
    }

    private final void setupUI() {
        this.configureSearchField();
        this.configureFileList();
        this.setupLayout();
    }

    private final void configureSearchField() {
        this.searchField.getTextEditor().addKeyListener((KeyListener)new KeyAdapter(this){
            final /* synthetic */ WorkspaceFileSearchPopup this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyReleased(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 40 && WorkspaceFileSearchPopup.access$getFileListModel$p(this.this$0).getSize() > 0) {
                    WorkspaceFileSearchPopup.access$transferFocusToFileList(this.this$0);
                    return;
                }
                String string = WorkspaceFileSearchPopup.access$getSearchField$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String query = ((Object)StringsKt.trim((CharSequence)string)).toString();
                WorkspaceFileSearchPopup.access$scheduleSearch(this.this$0, query);
            }
        });
    }

    private final void configureFileList() {
        this.fileList.addKeyListener((KeyListener)this.createFileListKeyListener());
        this.fileList.addMouseListener((MouseListener)this.createFileListMouseListener());
    }

    private final createFileListKeyListener.1 createFileListKeyListener() {
        return new KeyAdapter(this){
            final /* synthetic */ WorkspaceFileSearchPopup this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (e.getKeyCode()) {
                    case 10: {
                        WorkspaceFileSearchPopup.access$selectFiles(this.this$0);
                        e.consume();
                        break;
                    }
                    case 27: {
                        JBPopup jBPopup = WorkspaceFileSearchPopup.access$getPopup$p(this.this$0);
                        if (jBPopup != null) {
                            jBPopup.cancel();
                        }
                        e.consume();
                        break;
                    }
                    case 38: {
                        if (WorkspaceFileSearchPopup.access$getFileList$p(this.this$0).getSelectedIndex() != 0) break;
                        WorkspaceFileSearchPopup.access$getSearchField$p(this.this$0).requestFocus();
                        e.consume();
                    }
                }
            }
        };
    }

    private final createFileListMouseListener.1 createFileListMouseListener() {
        return new MouseAdapter(this){
            final /* synthetic */ WorkspaceFileSearchPopup this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2) {
                    WorkspaceFileSearchPopup.access$selectFiles(this.this$0);
                }
            }
        };
    }

    private final void setupLayout() {
        JPanel jPanel;
        JBScrollPane scrollPane = this.createScrollPane();
        JPanel statusPanel = this.createStatusPanel();
        JPanel $this$setupLayout_u24lambda_u242 = jPanel = this.contentPanel;
        boolean bl = false;
        $this$setupLayout_u24lambda_u242.setBorder((Border)JBUI.Borders.empty());
        $this$setupLayout_u24lambda_u242.add((Component)this.searchField, "North");
        $this$setupLayout_u24lambda_u242.add((Component)scrollPane, "Center");
        $this$setupLayout_u24lambda_u242.add((Component)statusPanel, "South");
        $this$setupLayout_u24lambda_u242.setPreferredSize(this.minPopupSize);
    }

    private final JBScrollPane createScrollPane() {
        JBScrollPane scrollPane = new JBScrollPane((Component)this.fileList);
        scrollPane.getVerticalScrollBar().addAdjustmentListener(arg_0 -> WorkspaceFileSearchPopup.createScrollPane$lambda$3(this, arg_0));
        return scrollPane;
    }

    private final JPanel createStatusPanel() {
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.add((Component)this.loadingLabel, "Center");
        return statusPanel;
    }

    private final void transferFocusToFileList() {
        this.fileList.requestFocus();
        this.fileList.setSelectedIndex(0);
    }

    private final boolean shouldLoadMoreFiles(Adjustable scrollBar) {
        return !this.isLoadingFiles && !this.hasLoadedAllFiles && scrollBar.getValue() + scrollBar.getVisibleAmount() >= scrollBar.getMaximum() - 10;
    }

    private final void scheduleSearch(String query) {
        this.searchAlarm.cancelAllRequests();
        this.currentSearchQuery = query;
        this.searchAlarm.addRequest(() -> WorkspaceFileSearchPopup.scheduleSearch$lambda$5(query, this), 300);
    }

    private final void performSearch(String query) {
        this.fileListModel.clear();
        if (StringsKt.isBlank((CharSequence)query)) {
            this.showRecentAndLoadedFiles();
        } else if (query.length() >= 2) {
            this.searchFilesWithQuery(query);
        } else {
            this.showRecentFiles();
        }
    }

    private final void showRecentAndLoadedFiles() {
        List<FilePresentation> filesToShow = this.buildFileListForDisplay();
        this.displayFiles(filesToShow);
        if (this.shouldStartLoadingProjectFiles()) {
            this.startLoadingProjectFiles();
        }
        this.selectFirstItemIfAvailable();
    }

    /*
     * WARNING - void declaration
     */
    private final List<FilePresentation> buildFileListForDisplay() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        FilePresentation it;
        ArrayList<String> arrayList;
        void $this$mapTo$iv$iv;
        ArrayList<String> filesToShow = new ArrayList<String>();
        filesToShow.addAll((Collection)this.recentFiles);
        Iterable $this$map$iv = this.recentFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FilePresentation filePresentation = (FilePresentation)item$iv$iv;
            arrayList = destination$iv$iv;
            boolean bl = false;
            arrayList.add(it.getPath());
        }
        Set recentPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = this.projectFiles;
        arrayList = filesToShow;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FilePresentation)element$iv$iv;
            boolean bl = false;
            if (!(!recentPaths.contains(it.getPath()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        arrayList.addAll(CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)50));
        return CollectionsKt.sortedWith((Iterable)filesToShow, this.createFileSortComparator());
    }

    private final void displayFiles(List<FilePresentation> files) {
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FilePresentation it = (FilePresentation)element$iv;
            boolean bl = false;
            this.fileListModel.addElement(it);
        }
    }

    private final Comparator<FilePresentation> createFileSortComparator() {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                FilePresentation it = (FilePresentation)a;
                boolean bl = false;
                boolean bl2 = !it.isRecentFile();
                it = (FilePresentation)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(!it.isRecentFile()));
            }
        };
        return new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    FilePresentation it = (FilePresentation)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (FilePresentation)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
                return n;
            }
        };
    }

    private final boolean shouldStartLoadingProjectFiles() {
        return this.projectFiles.isEmpty() && !this.isLoadingFiles && !this.hasLoadedAllFiles;
    }

    private final void showRecentFiles() {
        Iterable $this$forEach$iv = this.recentFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FilePresentation it = (FilePresentation)element$iv;
            boolean bl = false;
            this.fileListModel.addElement(it);
        }
        this.selectFirstItemIfAvailable();
    }

    private final void searchFilesWithQuery(String query) {
        List<FilePresentation> matchingLoaded = this.searchLoadedFiles(query);
        List<FilePresentation> additionalFiles = this.searchIndexedFiles(query, matchingLoaded);
        List<FilePresentation> allResults = this.combineAndSortResults(matchingLoaded, additionalFiles);
        this.displaySearchResults(allResults);
        this.selectFirstItemIfAvailable();
    }

    /*
     * WARNING - void declaration
     */
    private final List<FilePresentation> searchLoadedFiles(String query) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        ArrayList matchingLoaded = new ArrayList();
        Iterable iterable = this.recentFiles;
        Collection<String> collection = matchingLoaded;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv2;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            FilePresentation it = (FilePresentation)element$iv$iv;
            boolean bl = false;
            if (!this.fileMatchesQuery(it, query)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ((ArrayList)collection).addAll((List)destination$iv$iv);
        Iterable $this$map$iv = this.recentFiles;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FilePresentation bl = (FilePresentation)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getPath());
        }
        Set recentPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        $this$map$iv = this.projectFiles;
        collection = matchingLoaded;
        boolean $i$f$filter2 = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FilePresentation it = (FilePresentation)element$iv$iv;
            boolean bl = false;
            if (!(!recentPaths.contains(it.getPath()) && this.fileMatchesQuery(it, query))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        ((ArrayList)collection).addAll((List)destination$iv$iv2);
        return matchingLoaded;
    }

    private final boolean fileMatchesQuery(FilePresentation file, String query) {
        return StringsKt.contains((CharSequence)file.getName(), (CharSequence)query, (boolean)true) || StringsKt.contains((CharSequence)file.getPath(), (CharSequence)query, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FilePresentation> searchIndexedFiles(String query, List<FilePresentation> existingFiles) {
        void $this$mapTo$iv$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        List additionalFiles = new ArrayList();
        Iterable $this$map$iv = existingFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FilePresentation filePresentation = (FilePresentation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        Set existingPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        ApplicationManager.getApplication().runReadAction(() -> WorkspaceFileSearchPopup.searchIndexedFiles$lambda$18(query, scope, this, existingPaths, additionalFiles));
        return additionalFiles;
    }

    private final List<FilePresentation> combineAndSortResults(List<FilePresentation> matchingLoaded, List<FilePresentation> additionalFiles) {
        ArrayList allResults = new ArrayList();
        allResults.addAll(matchingLoaded);
        allResults.addAll(additionalFiles);
        return CollectionsKt.sortedWith((Iterable)allResults, this.createFileSortComparator());
    }

    private final void displaySearchResults(List<FilePresentation> results2) {
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)results2, (int)50);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FilePresentation it = (FilePresentation)element$iv;
            boolean bl = false;
            this.fileListModel.addElement(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadRecentFiles() {
        void $this$filterTo$iv$iv;
        this.recentFiles.clear();
        List fileList = EditorHistoryManager.Companion.getInstance(this.project).getFileList();
        Iterable $this$filter$iv = CollectionsKt.take((Iterable)fileList, (int)30);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!ProjectFileUtilKt.canBeAdded(it, this.project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file = (VirtualFile)element$iv;
            boolean bl = false;
            FilePresentation presentation = FilePresentation.Companion.from(this.project, file);
            presentation.setRecentFile(true);
            this.recentFiles.add(presentation);
        }
        this.showRecentFiles();
    }

    private final void startLoadingProjectFiles() {
        if (this.isLoadingFiles || this.hasLoadedAllFiles) {
            return;
        }
        this.setLoadingState(true);
        Project project = this.project;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, project){
            final /* synthetic */ WorkspaceFileSearchPopup this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, "Loading Files", false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    WorkspaceFileSearchPopup.access$loadMoreProjectFilesInternal(this.this$0, indicator);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> startLoadingProjectFiles.1.run$lambda$0(this.this$0), ModalityState.any());
                }
            }

            private static final void run$lambda$0(WorkspaceFileSearchPopup this$0) {
                WorkspaceFileSearchPopup.access$setLoadingState(this$0, false);
                WorkspaceFileSearchPopup.access$updateUIAfterLoading(this$0);
            }
        });
    }

    private final void setLoadingState(boolean loading) {
        this.isLoadingFiles = loading;
        this.loadingLabel.setVisible(loading);
    }

    private final void updateUIAfterLoading() {
        if (!StringsKt.isBlank((CharSequence)this.currentSearchQuery)) {
            this.performSearch(this.currentSearchQuery);
        } else if (this.shouldShowRecentAndLoadedFiles()) {
            this.showRecentAndLoadedFiles();
        }
    }

    private final boolean shouldShowRecentAndLoadedFiles() {
        return this.fileListModel.getSize() == 0 || this.fileListModel.getSize() == this.recentFiles.size();
    }

    private final void loadMoreProjectFiles() {
        if (this.isLoadingFiles || this.hasLoadedAllFiles) {
            return;
        }
        this.setLoadingState(true);
        Project project = this.project;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, project){
            final /* synthetic */ WorkspaceFileSearchPopup this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, "Loading More Files", false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    WorkspaceFileSearchPopup.access$loadMoreProjectFilesInternal(this.this$0, indicator);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> loadMoreProjectFiles.1.run$lambda$0(this.this$0), ModalityState.any());
                }
            }

            private static final void run$lambda$0(WorkspaceFileSearchPopup this$0) {
                WorkspaceFileSearchPopup.access$setLoadingState(this$0, false);
                WorkspaceFileSearchPopup.access$updateUIAfterLoadingMore(this$0);
            }
        });
    }

    private final void updateUIAfterLoadingMore() {
        if (!StringsKt.isBlank((CharSequence)this.currentSearchQuery)) {
            this.performSearch(this.currentSearchQuery);
        } else {
            this.addNewlyLoadedFilesToList();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addNewlyLoadedFilesToList() {
        void $this$filterTo$iv$iv;
        FilePresentation it;
        Iterable $this$mapTo$iv$iv;
        Set<String> currentPaths = this.getCurrentDisplayedPaths();
        Iterable $this$map$iv = this.recentFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FilePresentation filePresentation = (FilePresentation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        Set recentPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = this.projectFiles;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FilePresentation)element$iv$iv;
            boolean bl = false;
            if (!(!recentPaths.contains(it.getPath()) && !currentPaths.contains(it.getPath()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)50);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FilePresentation it2 = (FilePresentation)element$iv;
            boolean bl = false;
            this.fileListModel.addElement(it2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getCurrentDisplayedPaths() {
        void $this$mapNotNullTo$iv$iv;
        int currentSize = this.fileListModel.getSize();
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)currentSize);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            FilePresentation filePresentation = this.fileListModel.getElementAt(it);
            if ((filePresentation != null ? filePresentation.getPath() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final void loadMoreProjectFilesInternal(ProgressIndicator indicator) {
        indicator.setIndeterminate(false);
        Set<String> loadedPaths = this.getAllLoadedPaths();
        List newFiles = new ArrayList();
        Ref.IntRef count = new Ref.IntRef();
        ProjectFileIndex.getInstance((Project)this.project).iterateContent(arg_0 -> WorkspaceFileSearchPopup.loadMoreProjectFilesInternal$lambda$26(indicator, count, this, loadedPaths, newFiles, arg_0));
        this.updateProjectFilesState(newFiles, count.element);
        LOG.info("Loaded " + newFiles.size() + " more files. Total loaded: " + this.projectFiles.size());
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getAllLoadedPaths() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.plus((Collection)this.recentFiles, (Iterable)this.projectFiles);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FilePresentation filePresentation = (FilePresentation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final void updateProgressIndicator(ProgressIndicator indicator, int count) {
        if (count % 100 == 0) {
            indicator.setFraction((double)count / 10000.0);
            indicator.setText("Scanned " + count + " files...");
        }
    }

    private final boolean shouldAddFile(VirtualFile file, Set<String> loadedPaths) {
        boolean bl;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        try {
            bl = GitIgnoreUtil.INSTANCE.isIgnored(this.project, file);
        }
        catch (Exception e) {
            bl = fileIndex.isUnderIgnored(file);
        }
        boolean isIgnored = bl;
        return ProjectFileUtilKt.canBeAdded(file, this.project) && !isIgnored && fileIndex.isInContent(file) && !loadedPaths.contains(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateProjectFilesState(List<FilePresentation> newFiles, int count) {
        List<FilePresentation> list = this.projectFiles;
        synchronized (list) {
            boolean bl = false;
            this.projectFiles.addAll((Collection<FilePresentation>)newFiles);
            this.hasLoadedAllFiles = newFiles.size() < 50 || count > 10000;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void selectFirstItemIfAvailable() {
        if (this.fileListModel.getSize() > 0) {
            this.fileList.setSelectedIndex(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void selectFiles() {
        block2: {
            void $this$mapTo$iv$iv;
            List list = this.fileList.getSelectedValuesList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedValuesList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FilePresentation filePresentation = (FilePresentation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getVirtualFile());
            }
            List selectedFiles = (List)destination$iv$iv;
            if (!(!((Collection)selectedFiles).isEmpty())) break block2;
            this.onFilesSelected.invoke((Object)selectedFiles);
            JBPopup jBPopup = this.popup;
            if (jBPopup != null) {
                jBPopup.cancel();
            }
        }
    }

    public final void show(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        JBPopup jBPopup = this.popup = this.createPopup();
        if (jBPopup != null) {
            jBPopup.addListener((JBPopupListener)this.createPopupListener());
        }
        JBPopup jBPopup2 = this.popup;
        if (jBPopup2 != null) {
            jBPopup2.showUnderneathOf((Component)component2);
        }
        SwingUtilities.invokeLater(() -> WorkspaceFileSearchPopup.show$lambda$30(this));
    }

    private final JBPopup createPopup() {
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.contentPanel, (JComponent)this.searchField.getTextEditor()).setTitle("Add Files to Workspace").setMovable(true).setResizable(true).setRequestFocus(true).setFocusable(true).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setMinSize(this.minPopupSize).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        return jBPopup;
    }

    private final createPopupListener.1 createPopupListener() {
        return new JBPopupListener(this){
            final /* synthetic */ WorkspaceFileSearchPopup this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                WorkspaceFileSearchPopup.access$cleanupResources(this.this$0);
            }
        };
    }

    private final void cleanupResources() {
        this.searchAlarm.cancelAllRequests();
        this.recentFiles.clear();
        this.projectFiles.clear();
        this.fileListModel.clear();
        this.isLoadingFiles = false;
        this.hasLoadedAllFiles = false;
    }

    public void dispose() {
        this.cleanupResources();
    }

    private static final void createScrollPane$lambda$3(WorkspaceFileSearchPopup this$0, AdjustmentEvent e) {
        Adjustable scrollBar = e.getAdjustable();
        Intrinsics.checkNotNull((Object)scrollBar);
        if (this$0.shouldLoadMoreFiles(scrollBar)) {
            this$0.loadMoreProjectFiles();
        }
    }

    private static final void scheduleSearch$lambda$5$lambda$4(String $query, WorkspaceFileSearchPopup this$0) {
        if (Intrinsics.areEqual((Object)$query, (Object)this$0.currentSearchQuery)) {
            this$0.performSearch($query);
        }
    }

    private static final void scheduleSearch$lambda$5(String $query, WorkspaceFileSearchPopup this$0) {
        ApplicationManager.getApplication().invokeLater(() -> WorkspaceFileSearchPopup.scheduleSearch$lambda$5$lambda$4($query, this$0), ModalityState.any());
    }

    private static final boolean searchIndexedFiles$lambda$18$lambda$16(WorkspaceFileSearchPopup this$0, Set $existingPaths, List $additionalFiles, VirtualFile file) {
        Intrinsics.checkNotNull((Object)file);
        if (ProjectFileUtilKt.canBeAdded(file, this$0.project) && !$existingPaths.contains(file.getPath())) {
            $additionalFiles.add(FilePresentation.Companion.from(this$0.project, file));
        }
        return true;
    }

    private static final boolean searchIndexedFiles$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void searchIndexedFiles$lambda$18(String $query, GlobalSearchScope $scope, WorkspaceFileSearchPopup this$0, Set $existingPaths, List $additionalFiles) {
        FilenameIndex.processFilesByName((String)$query, (boolean)false, (GlobalSearchScope)$scope, arg_0 -> WorkspaceFileSearchPopup.searchIndexedFiles$lambda$18$lambda$17(arg_0 -> WorkspaceFileSearchPopup.searchIndexedFiles$lambda$18$lambda$16(this$0, $existingPaths, $additionalFiles, arg_0), arg_0));
    }

    private static final boolean loadMoreProjectFilesInternal$lambda$26(ProgressIndicator $indicator, Ref.IntRef $count, WorkspaceFileSearchPopup this$0, Set $loadedPaths, List $newFiles, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if ($indicator.isCanceled()) {
            return false;
        }
        int n = $count.element;
        $count.element = n + 1;
        this$0.updateProgressIndicator($indicator, $count.element);
        if (this$0.shouldAddFile(file, $loadedPaths)) {
            $newFiles.add(FilePresentation.Companion.from(this$0.project, file));
            if ($newFiles.size() >= 50) {
                return false;
            }
        }
        return $count.element <= 10000;
    }

    private static final void show$lambda$30(WorkspaceFileSearchPopup this$0) {
        IdeFocusManager.findInstance().requestFocus((Component)this$0.searchField.getTextEditor(), false);
    }

    public static final /* synthetic */ DefaultListModel access$getFileListModel$p(WorkspaceFileSearchPopup $this) {
        return $this.fileListModel;
    }

    public static final /* synthetic */ void access$transferFocusToFileList(WorkspaceFileSearchPopup $this) {
        $this.transferFocusToFileList();
    }

    public static final /* synthetic */ SearchTextField access$getSearchField$p(WorkspaceFileSearchPopup $this) {
        return $this.searchField;
    }

    public static final /* synthetic */ void access$scheduleSearch(WorkspaceFileSearchPopup $this, String query) {
        $this.scheduleSearch(query);
    }

    public static final /* synthetic */ void access$selectFiles(WorkspaceFileSearchPopup $this) {
        $this.selectFiles();
    }

    public static final /* synthetic */ JBPopup access$getPopup$p(WorkspaceFileSearchPopup $this) {
        return $this.popup;
    }

    public static final /* synthetic */ JBList access$getFileList$p(WorkspaceFileSearchPopup $this) {
        return $this.fileList;
    }

    public static final /* synthetic */ void access$loadMoreProjectFilesInternal(WorkspaceFileSearchPopup $this, ProgressIndicator indicator) {
        $this.loadMoreProjectFilesInternal(indicator);
    }

    public static final /* synthetic */ void access$setLoadingState(WorkspaceFileSearchPopup $this, boolean loading) {
        $this.setLoadingState(loading);
    }

    public static final /* synthetic */ void access$updateUIAfterLoading(WorkspaceFileSearchPopup $this) {
        $this.updateUIAfterLoading();
    }

    public static final /* synthetic */ void access$updateUIAfterLoadingMore(WorkspaceFileSearchPopup $this) {
        $this.updateUIAfterLoadingMore();
    }

    public static final /* synthetic */ void access$cleanupResources(WorkspaceFileSearchPopup $this) {
        $this.cleanupResources();
    }

    static {
        Logger logger = Logger.getInstance(WorkspaceFileSearchPopup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAX_RECENT_FILES", "", "SEARCH_DELAY_MS", "BATCH_SIZE", "MAX_FILES_TO_SCAN", "PROGRESS_UPDATE_INTERVAL", "SCROLL_THRESHOLD", "MIN_QUERY_LENGTH", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0017R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup$FileListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcc/unitmesh/devti/gui/chat/ui/file/FilePresentation;", "<init>", "(Lcc/unitmesh/devti/gui/chat/ui/file/WorkspaceFileSearchPopup;)V", "noBorderFocus", "Ljavax/swing/border/Border;", "kotlin.jvm.PlatformType", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "core"})
    private final class FileListCellRenderer
    implements ListCellRenderer<FilePresentation> {
        private final Border noBorderFocus = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList<? extends FilePresentation> list, @NotNull FilePresentation value, int index, boolean isSelected, boolean cellHasFocus) {
            Border border;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel infoPanel = new JPanel(new BorderLayout());
            infoPanel.setOpaque(false);
            JBLabel fileLabel2 = new JBLabel(value.getName(), value.getIcon(), 2);
            fileLabel2.setBorder((Border)JBUI.Borders.emptyRight((int)4));
            String relativePath = value.getPresentablePath();
            JBLabel pathLabel = new JBLabel(" - " + relativePath, 2);
            pathLabel.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)pathLabel.getFont()));
            pathLabel.setForeground(UIUtil.getContextHelpForeground());
            pathLabel.setToolTipText(relativePath);
            if (value.isRecentFile()) {
                fileLabel2.setForeground((Color)new JBColor(34815, 5807606));
            }
            infoPanel.add((Component)fileLabel2, "West");
            infoPanel.add((Component)pathLabel, "Center");
            mainPanel.add((Component)infoPanel, "Center");
            if (isSelected) {
                mainPanel.setBackground(list.getSelectionBackground());
                mainPanel.setForeground(list.getSelectionForeground());
            } else {
                mainPanel.setBackground(list.getBackground());
                mainPanel.setForeground(list.getForeground());
            }
            if (cellHasFocus) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
                if (border == null) {
                    border = this.noBorderFocus;
                }
            } else {
                border = this.noBorderFocus;
            }
            mainPanel.setBorder(border);
            return mainPanel;
        }
    }
}

