/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.ui.file;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.gui.chat.ui.file.FileItemPanel;
import cc.unitmesh.devti.gui.chat.ui.file.FilePresentation;
import cc.unitmesh.devti.gui.chat.ui.file.WorkspaceFileSearchPopup;
import cc.unitmesh.devti.gui.chat.ui.file.WrapLayout;
import cc.unitmesh.devti.gui.toolbar.McpConfigAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0006\u0010\u001d\u001a\u00020\u0015J\u0006\u0010\u001e\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/file/WorkspaceFilePanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "workspaceFiles", "", "Lcc/unitmesh/devti/gui/chat/ui/file/FilePresentation;", "filesPanel", "createMcpConfigButton", "Ljavax/swing/JComponent;", "createActionButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionPlace", "", "createAddButton", "Lcom/intellij/ui/components/JBLabel;", "showFileSearchPopup", "", "component", "addFileToWorkspace", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "updateFilesPanel", "removeFile", "filePresentation", "clear", "getAllFilesFormat", "core"})
@SourceDebugExtension(value={"SMAP\nWorkspaceFilePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceFilePanel.kt\ncc/unitmesh/devti/gui/chat/ui/file/WorkspaceFilePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1#2:234\n2624#3,3:235\n*S KotlinDebug\n*F\n+ 1 WorkspaceFilePanel.kt\ncc/unitmesh/devti/gui/chat/ui/file/WorkspaceFilePanel\n*L\n77#1:235,3\n*E\n"})
public final class WorkspaceFilePanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final List<FilePresentation> workspaceFiles;
    @NotNull
    private final JPanel filesPanel;

    public WorkspaceFilePanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new BorderLayout());
        this.project = project;
        this.workspaceFiles = new ArrayList();
        this.filesPanel = new JPanel(new WrapLayout(0, 2, 2));
        this.setBorder((Border)JBUI.Borders.empty());
        this.filesPanel.setOpaque(false);
        this.filesPanel.add((Component)this.createAddButton());
        this.filesPanel.add(this.createMcpConfigButton());
        this.add((Component)this.filesPanel, "North");
        this.setOpaque(false);
    }

    private final JComponent createMcpConfigButton() {
        return (JComponent)WorkspaceFilePanel.createActionButton$default(this, new McpConfigAction(), null, 2, null);
    }

    private final ActionButton createActionButton(AnAction action, String actionPlace) {
        ActionButton component2 = new ActionButton(action, action.getTemplatePresentation().clone(), actionPlace, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        return component2;
    }

    static /* synthetic */ ActionButton createActionButton$default(WorkspaceFilePanel workspaceFilePanel, AnAction anAction2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "unknown";
        }
        return workspaceFilePanel.createActionButton(anAction2, string);
    }

    private final JBLabel createAddButton() {
        JBLabel jBLabel;
        JBLabel $this$createAddButton_u24lambda_u240 = jBLabel = new JBLabel(AllIcons.General.Add);
        boolean bl = false;
        $this$createAddButton_u24lambda_u240.setCursor(new Cursor(12));
        JBLabel button2 = jBLabel;
        button2.setToolTipText(AutoDevBundle.message("chat.panel.add.files.tooltip", new Object[0]));
        button2.setBorder(JBUI.Borders.empty((int)2));
        button2.setBackground((Color)new JBColor(15594750, 3225409));
        button2.setOpaque(true);
        button2.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ WorkspaceFilePanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                WorkspaceFilePanel.access$showFileSearchPopup(this.this$0, this.this$0);
            }
        });
        return button2;
    }

    private final void showFileSearchPopup(JComponent component2) {
        WorkspaceFileSearchPopup popup = new WorkspaceFileSearchPopup(this.project, (Function1<? super List<? extends VirtualFile>, Unit>)((Function1)arg_0 -> WorkspaceFilePanel.showFileSearchPopup$lambda$1(this, arg_0)));
        popup.show(component2);
    }

    public final void addFileToWorkspace(@NotNull VirtualFile file) {
        boolean bl;
        FilePresentation filePresentation;
        block4: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            filePresentation = FilePresentation.Companion.from(this.project, file);
            Iterable $this$none$iv = this.workspaceFiles;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FilePresentation it = (FilePresentation)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getVirtualFile(), (Object)file)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            this.workspaceFiles.add(filePresentation);
            this.updateFilesPanel();
        }
    }

    private final void updateFilesPanel() {
        this.filesPanel.removeAll();
        this.filesPanel.add((Component)this.createAddButton());
        this.filesPanel.add(this.createMcpConfigButton());
        for (FilePresentation filePresentation : this.workspaceFiles) {
            FileItemPanel fileLabel2 = new FileItemPanel(this.project, filePresentation, (Function0<Unit>)((Function0)() -> WorkspaceFilePanel.updateFilesPanel$lambda$3(this, filePresentation)));
            this.filesPanel.add(fileLabel2);
        }
        this.filesPanel.revalidate();
        this.filesPanel.repaint();
    }

    private final void removeFile(FilePresentation filePresentation) {
        this.workspaceFiles.remove(filePresentation);
        this.updateFilesPanel();
    }

    public final void clear() {
        this.workspaceFiles.clear();
        this.updateFilesPanel();
    }

    @NotNull
    public final String getAllFilesFormat() {
        return CollectionsKt.joinToString$default((Iterable)this.workspaceFiles, (CharSequence)"\n", null, null, (int)0, null, WorkspaceFilePanel::getAllFilesFormat$lambda$4, (int)30, null);
    }

    private static final Unit showFileSearchPopup$lambda$1(WorkspaceFilePanel this$0, List files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        for (VirtualFile file : files) {
            this$0.addFileToWorkspace(file);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateFilesPanel$lambda$3(WorkspaceFilePanel this$0, FilePresentation $filePresentation) {
        this$0.removeFile($filePresentation);
        return Unit.INSTANCE;
    }

    private static final CharSequence getAllFilesFormat$lambda$4(FilePresentation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "/file:" + it.getPresentablePath();
    }

    public static final /* synthetic */ void access$showFileSearchPopup(WorkspaceFilePanel $this, JComponent component2) {
        $this.showFileSearchPopup(component2);
    }
}

