/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.ui.file;

import cc.unitmesh.devti.completion.AutoDevInputLookupManagerListener;
import cc.unitmesh.devti.gui.chat.ui.AutoDevInput;
import cc.unitmesh.devti.gui.chat.ui.file.FileActionType;
import cc.unitmesh.devti.gui.chat.ui.file.FilePresentation;
import cc.unitmesh.devti.gui.chat.ui.file.RelatedFileListCellRenderer;
import cc.unitmesh.devti.gui.chat.ui.file.RelatedFileListViewModel;
import cc.unitmesh.devti.gui.chat.ui.file.RelatedFileWorkspaceManager;
import cc.unitmesh.devti.gui.chat.ui.file.WorkspaceFilePanel;
import cc.unitmesh.devti.gui.chat.ui.file.WorkspaceFileToolbar;
import cc.unitmesh.devti.provider.RelatedClassesProvider;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0018J\u0006\u0010&\u001a\u00020\u000fJ\u0006\u0010'\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lcc/unitmesh/devti/gui/chat/ui/file/RelatedFileWorkspaceManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "relatedFileListViewModel", "Lcc/unitmesh/devti/gui/chat/ui/file/RelatedFileListViewModel;", "elementsList", "Lcom/intellij/ui/components/JBList;", "Lcc/unitmesh/devti/gui/chat/ui/file/FilePresentation;", "kotlin.jvm.PlatformType", "value", "Lcc/unitmesh/devti/gui/chat/ui/file/WorkspaceFilePanel;", "workspaceFilePanel", "getWorkspaceFilePanel", "()Lcc/unitmesh/devti/gui/chat/ui/file/WorkspaceFilePanel;", "initialize", "Ljavax/swing/JPanel;", "input", "Lcc/unitmesh/devti/gui/chat/ui/AutoDevInput;", "setupElementsList", "", "setupEditorListener", "setupRelatedListener", "calculateRelativeFile", "e", "Ljava/awt/event/MouseEvent;", "updateElements", "elements", "", "Lcom/intellij/psi/PsiElement;", "createHeaderPanel", "renderText", "", "clearWorkspace", "getWorkspacePanel", "getRelatedFileListViewModel", "core"})
@SourceDebugExtension(value={"SMAP\nRelatedFileWorkspaceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelatedFileWorkspaceManager.kt\ncc/unitmesh/devti/gui/chat/ui/file/RelatedFileWorkspaceManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1855#2,2:150\n*S KotlinDebug\n*F\n+ 1 RelatedFileWorkspaceManager.kt\ncc/unitmesh/devti/gui/chat/ui/file/RelatedFileWorkspaceManager\n*L\n118#1:150,2\n*E\n"})
public final class RelatedFileWorkspaceManager {
    @NotNull
    private final Project project;
    @Nullable
    private final Disposable disposable;
    @NotNull
    private final RelatedFileListViewModel relatedFileListViewModel;
    @NotNull
    private final JBList<FilePresentation> elementsList;
    private WorkspaceFilePanel workspaceFilePanel;

    public RelatedFileWorkspaceManager(@NotNull Project project, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.disposable = disposable;
        this.relatedFileListViewModel = new RelatedFileListViewModel(this.project);
        this.elementsList = new JBList((ListModel)this.relatedFileListViewModel.getListModel());
    }

    @NotNull
    public final WorkspaceFilePanel getWorkspaceFilePanel() {
        WorkspaceFilePanel workspaceFilePanel = this.workspaceFilePanel;
        if (workspaceFilePanel != null) {
            return workspaceFilePanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"workspaceFilePanel");
        return null;
    }

    @NotNull
    public final JPanel initialize(@NotNull AutoDevInput input) {
        block0: {
            VirtualFile currentFile;
            Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
            this.workspaceFilePanel = new WorkspaceFilePanel(this.project);
            this.setupElementsList();
            this.setupEditorListener();
            this.setupRelatedListener();
            VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getSelectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSelectedFiles(...)");
            VirtualFile virtualFile = currentFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
            if (virtualFile == null) break block0;
            VirtualFile it = virtualFile;
            boolean bl = false;
            this.relatedFileListViewModel.addFileIfAbsent(currentFile, true);
        }
        return this.createHeaderPanel(input);
    }

    private final void setupElementsList() {
        this.elementsList.setSelectionMode(0);
        this.elementsList.setLayoutOrientation(2);
        this.elementsList.setVisibleRowCount(2);
        this.elementsList.setCellRenderer((ListCellRenderer)new RelatedFileListCellRenderer(this.project));
        this.elementsList.setEmptyText("");
        this.elementsList.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ RelatedFileWorkspaceManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RelatedFileWorkspaceManager.access$calculateRelativeFile(this.this$0, e);
            }
        });
    }

    private final void setupEditorListener() {
        MessageBus messageBus = this.project.getMessageBus();
        Disposable disposable = this.disposable;
        Intrinsics.checkNotNull((Object)disposable);
        MessageBusConnection messageBusConnection = messageBus.connect(disposable);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ RelatedFileWorkspaceManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getNewFile();
                if (virtualFile == null) {
                    return;
                }
                VirtualFile file = virtualFile;
                ApplicationManager.getApplication().invokeLater(() -> setupEditorListener.1.selectionChanged$lambda$0(this.this$0, file));
            }

            private static final void selectionChanged$lambda$0(RelatedFileWorkspaceManager this$0, VirtualFile $file) {
                RelatedFileWorkspaceManager.access$getRelatedFileListViewModel$p(this$0).addFileIfAbsent($file, true);
            }
        });
    }

    private final void setupRelatedListener() {
        MessageBus messageBus = this.project.getMessageBus();
        Disposable disposable = this.disposable;
        Intrinsics.checkNotNull((Object)disposable);
        MessageBusConnection messageBusConnection = messageBus.connect(disposable);
        Topic topic = LookupManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new AutoDevInputLookupManagerListener(this.project, (Function1<? super PsiFile, Unit>)((Function1)arg_0 -> RelatedFileWorkspaceManager.setupRelatedListener$lambda$2(this, arg_0))));
    }

    private final void calculateRelativeFile(MouseEvent e) {
        Object object = e.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBList<*>");
        JBList list = (JBList)object;
        int index = list.locationToIndex(e.getPoint());
        if (index == -1) {
            return;
        }
        FilePresentation wrapper2 = this.relatedFileListViewModel.getListModel().getElementAt(index);
        Rectangle cellBounds = list.getCellBounds(index, index);
        Intrinsics.checkNotNull((Object)wrapper2);
        Point point = e.getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        Intrinsics.checkNotNull((Object)cellBounds);
        FileActionType actionType = this.relatedFileListViewModel.determineFileAction(wrapper2, point, cellBounds);
        boolean actionPerformed2 = this.relatedFileListViewModel.handleFileAction(wrapper2, actionType, (Function2<? super VirtualFile, ? super String, Unit>)((Function2)(arg_0, arg_1) -> RelatedFileWorkspaceManager.calculateRelativeFile$lambda$4(this, arg_0, arg_1)));
        if (!actionPerformed2) {
            list.clearSelection();
        }
    }

    private final void updateElements(List<? extends PsiElement> elements) {
        block1: {
            List<? extends PsiElement> list = elements;
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                VirtualFile virtualFile = it.getContainingFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                RelatedFileListViewModel.addFileIfAbsent$default(this.relatedFileListViewModel, virtualFile, false, 2, null);
            }
        }
    }

    private final JPanel createHeaderPanel(AutoDevInput input) {
        JBScrollPane scrollPane = new JBScrollPane((Component)this.elementsList);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        JToolBar toolbar = WorkspaceFileToolbar.INSTANCE.createToolbar(this.project, this.relatedFileListViewModel, input);
        JPanel headerPanel2 = new JPanel(new BorderLayout());
        headerPanel2.add((Component)toolbar, "North");
        headerPanel2.add((Component)scrollPane, "Center");
        return headerPanel2;
    }

    @NotNull
    public final String renderText() {
        this.relatedFileListViewModel.clearAllFiles();
        String files = this.getWorkspaceFilePanel().getAllFilesFormat();
        this.getWorkspaceFilePanel().clear();
        return files;
    }

    public final void clearWorkspace() {
        this.getWorkspaceFilePanel().clear();
    }

    @NotNull
    public final WorkspaceFilePanel getWorkspacePanel() {
        return this.getWorkspaceFilePanel();
    }

    @NotNull
    public final RelatedFileListViewModel getRelatedFileListViewModel() {
        return this.relatedFileListViewModel;
    }

    private static final void setupRelatedListener$lambda$2$lambda$1(PsiFile $it, RelatedFileWorkspaceManager this$0) {
        Language language = $it.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        RelatedClassesProvider relatedClassesProvider = RelatedClassesProvider.Companion.provide(language);
        List<PsiElement> relatedElements = relatedClassesProvider != null ? relatedClassesProvider.lookupIO($it) : null;
        this$0.updateElements(relatedElements);
    }

    private static final Unit setupRelatedListener$lambda$2(RelatedFileWorkspaceManager this$0, PsiFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ApplicationManager.getApplication().invokeLater(() -> RelatedFileWorkspaceManager.setupRelatedListener$lambda$2$lambda$1(it, this$0));
        return Unit.INSTANCE;
    }

    private static final void calculateRelativeFile$lambda$4$lambda$3(VirtualFile $vfile, RelatedFileWorkspaceManager this$0) {
        if (!$vfile.isValid()) {
            return;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)this$0.project).findFile($vfile);
        if (psiFile2 == null) {
            return;
        }
        PsiFile psiFile3 = psiFile2;
        Language language = psiFile3.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        RelatedClassesProvider relatedClassesProvider = RelatedClassesProvider.Companion.provide(language);
        List<PsiElement> relatedElements = relatedClassesProvider != null ? relatedClassesProvider.lookupIO(psiFile3) : null;
        this$0.updateElements(relatedElements);
    }

    private static final Unit calculateRelativeFile$lambda$4(RelatedFileWorkspaceManager this$0, VirtualFile vfile, String relativePath) {
        Intrinsics.checkNotNullParameter((Object)vfile, (String)"vfile");
        if (relativePath != null) {
            this$0.getWorkspacePanel().addFileToWorkspace(vfile);
            ApplicationManager.getApplication().invokeLater(() -> RelatedFileWorkspaceManager.calculateRelativeFile$lambda$4$lambda$3(vfile, this$0));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$calculateRelativeFile(RelatedFileWorkspaceManager $this, MouseEvent e) {
        $this.calculateRelativeFile(e);
    }

    public static final /* synthetic */ RelatedFileListViewModel access$getRelatedFileListViewModel$p(RelatedFileWorkspaceManager $this) {
        return $this.relatedFileListViewModel;
    }
}

