/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.ui.file;

import cc.unitmesh.devti.gui.chat.ui.file.FileActionType;
import cc.unitmesh.devti.gui.chat.ui.file.FileListChangeListener;
import cc.unitmesh.devti.gui.chat.ui.file.FilePresentation;
import cc.unitmesh.devti.util.ProjectFileUtilKt;
import com.intellij.diff.editor.DiffVirtualFileBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\u000eJ\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J2\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u001a\u0010 \u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u00020\u000e0!J\u001e\u0010#\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/file/RelatedFileListViewModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "listModel", "Ljavax/swing/DefaultListModel;", "Lcc/unitmesh/devti/gui/chat/ui/file/FilePresentation;", "listeners", "", "Lcc/unitmesh/devti/gui/chat/ui/file/FileListChangeListener;", "getListModel", "addFileIfAbsent", "", "vfile", "Lcom/intellij/openapi/vfs/VirtualFile;", "first", "", "removeFile", "file", "removeFileByVirtualFile", "clearAllFiles", "getRecentlyOpenedFiles", "", "maxFiles", "", "addRecentlyOpenedFiles", "handleFileAction", "filePresentation", "actionType", "Lcc/unitmesh/devti/gui/chat/ui/file/FileActionType;", "callback", "Lkotlin/Function2;", "", "determineFileAction", "componentPoint", "Ljava/awt/Point;", "componentBounds", "Ljava/awt/Rectangle;", "dispose", "core"})
@SourceDebugExtension(value={"SMAP\nRelatedFileListViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelatedFileListViewModel.kt\ncc/unitmesh/devti/gui/chat/ui/file/RelatedFileListViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,177:1\n1#2:178\n1855#3,2:179\n1855#3,2:181\n1855#3,2:183\n1855#3,2:185\n1549#3:187\n1620#3,3:188\n1855#3:191\n1855#3,2:194\n1856#3:196\n2159#4,2:192\n1282#5,2:197\n*S KotlinDebug\n*F\n+ 1 RelatedFileListViewModel.kt\ncc/unitmesh/devti/gui/chat/ui/file/RelatedFileListViewModel\n*L\n54#1:179,2\n67#1:181,2\n77#1:183,2\n83#1:185,2\n90#1:187\n90#1:188,3\n96#1:191\n99#1:194,2\n96#1:196\n97#1:192,2\n161#1:197,2\n*E\n"})
public final class RelatedFileListViewModel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultListModel<FilePresentation> listModel;
    @NotNull
    private final List<FileListChangeListener> listeners;

    public RelatedFileListViewModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.listModel = new DefaultListModel();
        this.listeners = new ArrayList();
    }

    @NotNull
    public final DefaultListModel<FilePresentation> getListModel() {
        return this.listModel;
    }

    public final void addFileIfAbsent(@NotNull VirtualFile vfile, boolean first) {
        Object v1;
        block10: {
            Intrinsics.checkNotNullParameter((Object)vfile, (String)"vfile");
            if (!vfile.isValid() || vfile.getFileType().isBinary()) {
                return;
            }
            if (!ProjectFileUtilKt.isInProject(vfile, this.project)) {
                return;
            }
            if (vfile instanceof DiffVirtualFileBase) {
                return;
            }
            Enumeration<FilePresentation> enumeration = this.listModel.elements();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"elements(...)");
            Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            for (Object object : sequence) {
                FilePresentation it = (FilePresentation)object;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getVirtualFile(), (Object)vfile)) continue;
                v1 = object;
                break block10;
            }
            v1 = null;
        }
        FilePresentation existingFile = v1;
        if (existingFile == null) {
            FilePresentation filePresentation = new FilePresentation(vfile, null, null, 0L, null, null, null, null, false, 510, null);
            if (first) {
                this.listModel.insertElementAt(filePresentation, 0);
            } else {
                this.listModel.addElement(filePresentation);
            }
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileListChangeListener it = (FileListChangeListener)element$iv;
                boolean bl = false;
                it.onFileAdded(filePresentation);
            }
        } else if (first && this.listModel.indexOf(existingFile) != 0) {
            this.listModel.removeElement(existingFile);
            this.listModel.insertElementAt(existingFile, 0);
        }
    }

    public static /* synthetic */ void addFileIfAbsent$default(RelatedFileListViewModel relatedFileListViewModel, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        relatedFileListViewModel.addFileIfAbsent(virtualFile, bl);
    }

    public final void removeFile(@NotNull FilePresentation file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.listModel.contains(file)) {
            this.listModel.removeElement(file);
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileListChangeListener it = (FileListChangeListener)element$iv;
                boolean bl = false;
                it.onFileRemoved(file);
            }
        }
    }

    public final void removeFileByVirtualFile(@NotNull VirtualFile vfile) {
        block3: {
            FilePresentation filePresentation;
            Object v1;
            block2: {
                Intrinsics.checkNotNullParameter((Object)vfile, (String)"vfile");
                Enumeration<FilePresentation> enumeration = this.listModel.elements();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"elements(...)");
                Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                for (Object e : sequence) {
                    FilePresentation it = (FilePresentation)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getVirtualFile(), (Object)vfile)) continue;
                    v1 = e;
                    break block2;
                }
                v1 = null;
            }
            FilePresentation filePresentation2 = filePresentation = (FilePresentation)v1;
            if (filePresentation2 == null) break block3;
            FilePresentation it = filePresentation2;
            boolean bl = false;
            this.listModel.removeElement(it);
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileListChangeListener listener2 = (FileListChangeListener)element$iv;
                boolean bl2 = false;
                listener2.onFileRemoved(it);
            }
        }
    }

    public final void clearAllFiles() {
        this.listModel.removeAllElements();
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileListChangeListener it = (FileListChangeListener)element$iv;
            boolean bl = false;
            it.onListCleared();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FilePresentation> getRecentlyOpenedFiles(int maxFiles) {
        void $this$mapTo$iv$iv;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        VirtualFile[] virtualFileArray = fileEditorManager.getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Iterable $this$map$iv = ArraysKt.take((Object[])virtualFileArray, (int)maxFiles);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(FilePresentation.Companion.from(this.project, (VirtualFile)it));
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    public static /* synthetic */ List getRecentlyOpenedFiles$default(RelatedFileListViewModel relatedFileListViewModel, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 12;
        }
        return relatedFileListViewModel.getRecentlyOpenedFiles(n);
    }

    @NotNull
    public final List<FilePresentation> addRecentlyOpenedFiles() {
        List files = RelatedFileListViewModel.getRecentlyOpenedFiles$default(this, 0, 1, null);
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Object it;
            FilePresentation file;
            block3: {
                file = (FilePresentation)element$iv;
                boolean bl2 = false;
                Enumeration<FilePresentation> enumeration = this.listModel.elements();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"elements(...)");
                Sequence $this$none$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                boolean $i$f$none = false;
                for (Object element$iv2 : $this$none$iv) {
                    it = (FilePresentation)element$iv2;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)((FilePresentation)it).getVirtualFile(), (Object)file.getVirtualFile())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (!bl) continue;
            this.listModel.addElement(file);
            Iterable $this$forEach$iv2 = this.listeners;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                it = (FileListChangeListener)element$iv2;
                boolean bl4 = false;
                it.onFileAdded(file);
            }
        }
        return files;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean handleFileAction(@NotNull FilePresentation filePresentation, @NotNull FileActionType actionType, @NotNull Function2<? super VirtualFile, ? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)filePresentation, (String)"filePresentation");
        Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        switch (WhenMappings.$EnumSwitchMapping$0[actionType.ordinal()]) {
            case 1: {
                vfile = filePresentation.getVirtualFile();
                if (!vfile.isValid()) {
                    return false;
                }
                try {
                    v0 = this.project.getBasePath();
                    if (v0 == null) ** GOTO lbl21
                    basePath = v0;
                    $i$a$-let-RelatedFileListViewModel$handleFileAction$relativePath$1 = false;
                    v1 = vfile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPath(...)");
                    v2 = StringsKt.removePrefix((String)StringsKt.substringAfter$default((String)v1, (String)basePath, null, (int)2, null), (CharSequence)"/");
                    v0 = v2;
                    if (v2 != null) ** GOTO lbl24
lbl21:
                    // 2 sources

                    v3 = vfile.getPath();
                    v0 = v3;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getPath(...)");
lbl24:
                    // 2 sources

                    var6_7 = v0;
                }
                catch (Exception e) {
                    var8_9 = vfile.getPath();
                    Intrinsics.checkNotNull((Object)var8_9);
                    var6_7 = var8_9;
                }
                relativePath = var6_7;
                this.removeFile(filePresentation);
                RelatedFileListViewModel.addFileIfAbsent$default(this, vfile, false, 2, null);
                callback.invoke((Object)vfile, (Object)relativePath);
                this.removeFileByVirtualFile(vfile);
                return true;
            }
            case 2: {
                this.removeFile(filePresentation);
                return true;
            }
            case 3: {
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final FileActionType determineFileAction(@NotNull FilePresentation filePresentation, @NotNull Point componentPoint, @NotNull Rectangle componentBounds) {
        Component component2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)filePresentation, (String)"filePresentation");
            Intrinsics.checkNotNullParameter((Object)componentPoint, (String)"componentPoint");
            Intrinsics.checkNotNullParameter((Object)componentBounds, (String)"componentBounds");
            Component[] componentArray = filePresentation.getPanel();
            if (componentArray != null && (componentArray = componentArray.getComponents()) != null) {
                Component[] $this$firstOrNull$iv = componentArray;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    Component element$iv;
                    Component it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!it.contains(componentPoint.x - componentBounds.x - it.getX(), it.getHeight() - 1)) continue;
                    component2 = element$iv;
                    break block3;
                }
                component2 = null;
            } else {
                component2 = null;
            }
        }
        Component hitComponent = component2;
        return hitComponent instanceof JPanel ? FileActionType.INSERT : (hitComponent instanceof JLabel && Intrinsics.areEqual((Object)((JLabel)hitComponent).getIcon(), (Object)AllIcons.Actions.Close) ? FileActionType.REMOVE : FileActionType.NONE);
    }

    public void dispose() {
        this.listeners.clear();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FileActionType.values().length];
            try {
                nArray[FileActionType.INSERT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileActionType.REMOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileActionType.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

