/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.ui.file;

import cc.unitmesh.devti.gui.chat.ui.file.FilePresentation;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0002H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/file/RelatedFileListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcc/unitmesh/devti/gui/chat/ui/file/FilePresentation;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "createFileItemPanel", "Ljavax/swing/JPanel;", "core"})
public final class RelatedFileListCellRenderer
implements ListCellRenderer<FilePresentation> {
    @NotNull
    private final Project project;

    public RelatedFileListCellRenderer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends FilePresentation> list, @NotNull FilePresentation value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel fileItemPanel;
        block4: {
            JPanel fileInfoPanel;
            block3: {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                JPanel jPanel = value.getPanel();
                if (jPanel == null) {
                    jPanel = this.createFileItemPanel(value);
                }
                fileItemPanel = jPanel;
                fileInfoPanel = value.getNamePanel();
                if (!isSelected) break block3;
                JPanel jPanel2 = fileInfoPanel;
                if (jPanel2 != null) {
                    jPanel2.setBackground(list.getSelectionBackground());
                }
                JPanel jPanel3 = fileInfoPanel;
                if (jPanel3 == null) break block4;
                jPanel3.setForeground(list.getSelectionForeground());
                break block4;
            }
            JPanel jPanel = fileInfoPanel;
            if (jPanel != null) {
                jPanel.setBackground(fileItemPanel.getBackground());
            }
            JPanel jPanel4 = fileInfoPanel;
            if (jPanel4 == null) break block4;
            jPanel4.setForeground(list.getForeground());
        }
        return fileItemPanel;
    }

    private final JPanel createFileItemPanel(FilePresentation value) {
        JPanel jPanel;
        JPanel $this$createFileItemPanel_u24lambda_u240 = jPanel = new JPanel(new FlowLayout(0, 3, 0));
        boolean bl = false;
        $this$createFileItemPanel_u24lambda_u240.getAccessibleContext().setAccessibleName("Element Panel");
        $this$createFileItemPanel_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
        JPanel fileInfoPanel = new JPanel($this$createFileItemPanel_u24lambda_u240.getLayout());
        Icon icon = value.getVirtualFile().getFileType().getIcon();
        if (icon == null) {
            Icon icon2 = AllIcons.FileTypes.Unknown;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Unknown");
        }
        JLabel fileIconLabel = new JLabel(icon);
        fileInfoPanel.add(fileIconLabel);
        fileInfoPanel.setToolTipText(value.relativePath(this.project));
        JLabel fileNameLabel = new JLabel(value.displayName());
        fileInfoPanel.add(fileNameLabel);
        $this$createFileItemPanel_u24lambda_u240.add(fileInfoPanel);
        JLabel closeButton = new JLabel(AllIcons.Actions.Close);
        closeButton.setBorder((Border)JBUI.Borders.empty());
        $this$createFileItemPanel_u24lambda_u240.add((Component)closeButton, "East");
        value.setPanel($this$createFileItemPanel_u24lambda_u240);
        value.setNamePanel(fileInfoPanel);
        $this$createFileItemPanel_u24lambda_u240.setToolTipText(value.relativePath(this.project));
        return jPanel;
    }
}

