/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.ui;

import cc.unitmesh.devti.llm2.TokenUsageEvent;
import cc.unitmesh.devti.llm2.TokenUsageListener;
import cc.unitmesh.devti.llm2.TokenUsageService;
import cc.unitmesh.devti.llms.custom.Usage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\r2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0006\u0010\u001a\u001a\u00020\rJ\u0006\u0010\u001b\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/TokenUsageViewModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tokenUsageService", "Lcc/unitmesh/devti/llm2/TokenUsageService;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "onTokenUsageUpdated", "Lkotlin/Function1;", "Lcc/unitmesh/devti/gui/chat/ui/TokenUsageViewModel$TokenUsageData;", "", "setupTokenUsageListener", "updateTokenUsage", "event", "Lcc/unitmesh/devti/llm2/TokenUsageEvent;", "getMaxContextWindowTokens", "", "setOnTokenUsageUpdated", "callback", "getCurrentUsage", "Lcc/unitmesh/devti/llms/custom/Usage;", "getCurrentModel", "", "reset", "dispose", "TokenUsageData", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTokenUsageViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenUsageViewModel.kt\ncc/unitmesh/devti/gui/chat/ui/TokenUsageViewModel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,114:1\n31#2,2:115\n*S KotlinDebug\n*F\n+ 1 TokenUsageViewModel.kt\ncc/unitmesh/devti/gui/chat/ui/TokenUsageViewModel\n*L\n17#1:115,2\n*E\n"})
public final class TokenUsageViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final TokenUsageService tokenUsageService;
    @Nullable
    private MessageBusConnection messageBusConnection;
    @Nullable
    private Function1<? super TokenUsageData, Unit> onTokenUsageUpdated;

    public TokenUsageViewModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<TokenUsageService> serviceClass$iv = TokenUsageService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.tokenUsageService = (TokenUsageService)object;
        this.setupTokenUsageListener();
    }

    private final void setupTokenUsageListener() {
        block0: {
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
            MessageBus messageBus2 = messageBus;
            MessageBusConnection messageBusConnection = this.messageBusConnection = messageBus2.connect();
            if (messageBusConnection == null) break block0;
            messageBusConnection.subscribe(TokenUsageListener.Companion.getTOPIC(), (Object)new TokenUsageListener(this){
                final /* synthetic */ TokenUsageViewModel this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onTokenUsage(TokenUsageEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    TokenUsageViewModel.access$updateTokenUsage(this.this$0, event);
                }
            });
        }
    }

    private final void updateTokenUsage(TokenUsageEvent event) {
        ApplicationManager.getApplication().invokeLater(() -> TokenUsageViewModel.updateTokenUsage$lambda$0(this, event));
    }

    private final long getMaxContextWindowTokens() {
        long l;
        try {
            l = this.tokenUsageService.getUsedMaxToken();
        }
        catch (Exception e) {
            l = 4096L;
        }
        return l;
    }

    public final void setOnTokenUsageUpdated(@NotNull Function1<? super TokenUsageData, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.onTokenUsageUpdated = callback;
    }

    @NotNull
    public final Usage getCurrentUsage() {
        return this.tokenUsageService.getCurrentConsumedTokens();
    }

    @Nullable
    public final String getCurrentModel() {
        return null;
    }

    public final void reset() {
        ApplicationManager.getApplication().invokeLater(() -> TokenUsageViewModel.reset$lambda$1(this));
    }

    public final void dispose() {
        MessageBusConnection messageBusConnection = this.messageBusConnection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.messageBusConnection = null;
        this.onTokenUsageUpdated = null;
    }

    private static final void updateTokenUsage$lambda$0(TokenUsageViewModel this$0, TokenUsageEvent $event) {
        block0: {
            long maxTokens = this$0.getMaxContextWindowTokens();
            long totalTokens = $event.getUsage().getTotalTokens();
            double usageRatio = maxTokens > 0L ? (double)totalTokens / (double)maxTokens : 0.0;
            CharSequence charSequence = $event.getModel();
            TokenUsageData tokenUsageData = new TokenUsageData($event.getUsage(), $event.getModel(), maxTokens, usageRatio, !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && maxTokens > 0L);
            Function1<? super TokenUsageData, Unit> function1 = this$0.onTokenUsageUpdated;
            if (function1 == null) break block0;
            function1.invoke((Object)tokenUsageData);
        }
    }

    private static final void reset$lambda$1(TokenUsageViewModel this$0) {
        block0: {
            TokenUsageData emptyData = new TokenUsageData(new Usage(0L, 0L, 0L, 7, null), null, 0L, 0.0, false);
            Function1<? super TokenUsageData, Unit> function1 = this$0.onTokenUsageUpdated;
            if (function1 == null) break block0;
            function1.invoke((Object)emptyData);
        }
    }

    public static final /* synthetic */ void access$updateTokenUsage(TokenUsageViewModel $this, TokenUsageEvent event) {
        $this.updateTokenUsage(event);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/TokenUsageViewModel$Companion;", "", "<init>", "()V", "formatTokenCount", "", "count", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatTokenCount(long count) {
            String string;
            if (count >= 1000000L) {
                String string2 = "%.1fM";
                Object[] objectArray = new Object[]{(double)count / 1000000.0};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else if (count >= 1000L) {
                String string4 = "%.1fK";
                Object[] objectArray = new Object[]{(double)count / 1000.0};
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            } else {
                string = String.valueOf(count);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003J=\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0016\u00a8\u0006\""}, d2={"Lcc/unitmesh/devti/gui/chat/ui/TokenUsageViewModel$TokenUsageData;", "", "usage", "Lcc/unitmesh/devti/llms/custom/Usage;", "model", "", "maxContextWindowTokens", "", "usageRatio", "", "isVisible", "", "<init>", "(Lcc/unitmesh/devti/llms/custom/Usage;Ljava/lang/String;JDZ)V", "getUsage", "()Lcc/unitmesh/devti/llms/custom/Usage;", "getModel", "()Ljava/lang/String;", "getMaxContextWindowTokens", "()J", "getUsageRatio", "()D", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "core"})
    public static final class TokenUsageData {
        @NotNull
        private final Usage usage;
        @Nullable
        private final String model;
        private final long maxContextWindowTokens;
        private final double usageRatio;
        private final boolean isVisible;

        public TokenUsageData(@NotNull Usage usage, @Nullable String model, long maxContextWindowTokens, double usageRatio, boolean isVisible) {
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            this.usage = usage;
            this.model = model;
            this.maxContextWindowTokens = maxContextWindowTokens;
            this.usageRatio = usageRatio;
            this.isVisible = isVisible;
        }

        @NotNull
        public final Usage getUsage() {
            return this.usage;
        }

        @Nullable
        public final String getModel() {
            return this.model;
        }

        public final long getMaxContextWindowTokens() {
            return this.maxContextWindowTokens;
        }

        public final double getUsageRatio() {
            return this.usageRatio;
        }

        public final boolean isVisible() {
            return this.isVisible;
        }

        @NotNull
        public final Usage component1() {
            return this.usage;
        }

        @Nullable
        public final String component2() {
            return this.model;
        }

        public final long component3() {
            return this.maxContextWindowTokens;
        }

        public final double component4() {
            return this.usageRatio;
        }

        public final boolean component5() {
            return this.isVisible;
        }

        @NotNull
        public final TokenUsageData copy(@NotNull Usage usage, @Nullable String model, long maxContextWindowTokens, double usageRatio, boolean isVisible) {
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            return new TokenUsageData(usage, model, maxContextWindowTokens, usageRatio, isVisible);
        }

        public static /* synthetic */ TokenUsageData copy$default(TokenUsageData tokenUsageData, Usage usage, String string, long l, double d, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                usage = tokenUsageData.usage;
            }
            if ((n & 2) != 0) {
                string = tokenUsageData.model;
            }
            if ((n & 4) != 0) {
                l = tokenUsageData.maxContextWindowTokens;
            }
            if ((n & 8) != 0) {
                d = tokenUsageData.usageRatio;
            }
            if ((n & 0x10) != 0) {
                bl = tokenUsageData.isVisible;
            }
            return tokenUsageData.copy(usage, string, l, d, bl);
        }

        @NotNull
        public String toString() {
            return "TokenUsageData(usage=" + this.usage + ", model=" + this.model + ", maxContextWindowTokens=" + this.maxContextWindowTokens + ", usageRatio=" + this.usageRatio + ", isVisible=" + this.isVisible + ")";
        }

        public int hashCode() {
            int result = this.usage.hashCode();
            result = result * 31 + (this.model == null ? 0 : this.model.hashCode());
            result = result * 31 + Long.hashCode(this.maxContextWindowTokens);
            result = result * 31 + Double.hashCode(this.usageRatio);
            result = result * 31 + Boolean.hashCode(this.isVisible);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenUsageData)) {
                return false;
            }
            TokenUsageData tokenUsageData = (TokenUsageData)other;
            if (!Intrinsics.areEqual((Object)this.usage, (Object)tokenUsageData.usage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.model, (Object)tokenUsageData.model)) {
                return false;
            }
            if (this.maxContextWindowTokens != tokenUsageData.maxContextWindowTokens) {
                return false;
            }
            if (Double.compare(this.usageRatio, tokenUsageData.usageRatio) != 0) {
                return false;
            }
            return this.isVisible == tokenUsageData.isVisible;
        }
    }
}

