/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.ui;

import cc.unitmesh.devti.gui.chat.ui.TokenUsageUIComponents;
import cc.unitmesh.devti.gui.chat.ui.TokenUsageViewModel;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u001c\u001a\u00020\rJ\u0006\u0010\u001d\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/TokenUsagePanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "uiComponents", "Lcc/unitmesh/devti/gui/chat/ui/TokenUsageUIComponents;", "viewModel", "Lcc/unitmesh/devti/gui/chat/ui/TokenUsageViewModel;", "currentData", "Lcc/unitmesh/devti/gui/chat/ui/TokenUsageViewModel$TokenUsageData;", "setupUI", "", "createMainPanel", "Ljavax/swing/JPanel;", "setupViewModel", "updateUI", "data", "createProgressBarColor", "Lcom/intellij/ui/JBColor;", "usageRatio", "", "createUsageRatioText", "", "totalTokens", "", "maxTokens", "reset", "dispose", "core"})
public final class TokenUsagePanel
extends BorderLayoutPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final TokenUsageUIComponents uiComponents;
    @NotNull
    private final TokenUsageViewModel viewModel;
    @Nullable
    private TokenUsageViewModel.TokenUsageData currentData;

    public TokenUsagePanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.uiComponents = new TokenUsageUIComponents();
        this.viewModel = new TokenUsageViewModel(this.project);
        this.setupUI();
        this.setupViewModel();
    }

    private final void setupUI() {
        this.setOpaque(false);
        this.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
        JPanel mainPanel = this.createMainPanel();
        this.addToCenter(mainPanel);
        this.setVisible(false);
    }

    private final JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        mainPanel.add((Component)this.uiComponents.createModelLabelPanel(), gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.9;
        gbc.fill = 2;
        gbc.insets = (Insets)JBUI.insets((int)0, (int)8);
        mainPanel.add((Component)this.uiComponents.createProgressPanel(), gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.1;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.insets = (Insets)JBUI.emptyInsets();
        mainPanel.add((Component)this.uiComponents.createUsageRatioPanel(), gbc);
        return mainPanel;
    }

    private final void setupViewModel() {
        this.viewModel.setOnTokenUsageUpdated((Function1<? super TokenUsageViewModel.TokenUsageData, Unit>)((Function1)arg_0 -> TokenUsagePanel.setupViewModel$lambda$0(this, arg_0)));
    }

    private final void updateUI(TokenUsageViewModel.TokenUsageData data) {
        this.currentData = data;
        CharSequence charSequence = data.getModel();
        String modelText = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? "Model: " + data.getModel() : "";
        this.uiComponents.updateModelLabel(modelText);
        if (data.getMaxContextWindowTokens() > 0L) {
            long totalTokens = data.getUsage().getTotalTokens();
            int usageRatio = RangesKt.coerceIn((int)((int)(data.getUsageRatio() * (double)100)), (int)0, (int)100);
            this.uiComponents.updateProgressBar(usageRatio, this.createProgressBarColor(usageRatio));
            this.uiComponents.updateUsageRatioLabel(this.createUsageRatioText(totalTokens, data.getMaxContextWindowTokens(), usageRatio));
            this.uiComponents.setProgressBarTooltip("Token usage: " + usageRatio + "% of context window");
            this.uiComponents.setProgressComponentsVisible(true);
        } else {
            this.uiComponents.setProgressComponentsVisible(false);
        }
        this.setVisible(data.isVisible());
        this.revalidate();
        this.repaint();
    }

    private final JBColor createProgressBarColor(int usageRatio) {
        JBColor jBColor;
        if (usageRatio >= 90) {
            JBColor jBColor2 = JBColor.RED;
            jBColor = jBColor2;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"RED");
        } else if (usageRatio >= 75) {
            JBColor jBColor3 = JBColor.ORANGE;
            jBColor = jBColor3;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"ORANGE");
        } else if (usageRatio >= 50) {
            JBColor jBColor4 = JBColor.YELLOW;
            jBColor = jBColor4;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"YELLOW");
        } else if (usageRatio >= 25) {
            JBColor jBColor5 = JBColor.GREEN;
            jBColor = jBColor5;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor5, (String)"GREEN");
        } else {
            Color color = UIUtil.getPanelBackground();
            Intrinsics.checkNotNull((Object)color, (String)"null cannot be cast to non-null type com.intellij.ui.JBColor");
            jBColor = (JBColor)color;
        }
        return jBColor;
    }

    private final String createUsageRatioText(long totalTokens, long maxTokens, int usageRatio) {
        return TokenUsageViewModel.Companion.formatTokenCount(totalTokens) + "/" + TokenUsageViewModel.Companion.formatTokenCount(maxTokens) + " (" + usageRatio + "%)";
    }

    public final void reset() {
        this.viewModel.reset();
    }

    public final void dispose() {
        this.viewModel.dispose();
    }

    private static final Unit setupViewModel$lambda$0(TokenUsagePanel this$0, TokenUsageViewModel.TokenUsageData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this$0.updateUI(data);
        return Unit.INSTANCE;
    }
}

