/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.ui;

import cc.unitmesh.devti.agent.custom.model.CustomAgentConfig;
import cc.unitmesh.devti.agent.custom.model.CustomAgentState;
import cc.unitmesh.devti.settings.AutoDevSettingsState;
import cc.unitmesh.devti.settings.customize.AutoDevCustomizeSettingsKt;
import cc.unitmesh.devti.settings.model.LLMModelManager;
import cc.unitmesh.devti.settings.ui.ModelItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0006\u0010\u001d\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000fJ\u0006\u0010!\u001a\u00020\u0017J\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/InputSelectorsManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "showAgent", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "value", "Lcom/intellij/openapi/ui/ComboBox;", "Lcc/unitmesh/devti/settings/ui/ModelItem;", "modelSelector", "getModelSelector", "()Lcom/intellij/openapi/ui/ComboBox;", "defaultRag", "Lcc/unitmesh/devti/agent/custom/model/CustomAgentConfig;", "customAgentBox", "getCustomAgentBox", "setCustomAgentBox", "(Lcom/intellij/openapi/ui/ComboBox;)V", "initialize", "Ljavax/swing/JPanel;", "createModelSelector", "", "createAgentSelector", "createLeftPanel", "loadAgents", "", "refreshAgentList", "hasSelectedAgent", "getSelectedAgent", "selectAgent", "config", "resetAgent", "getCustomAgent", "core"})
@SourceDebugExtension(value={"SMAP\nInputSelectorsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputSelectorsManager.kt\ncc/unitmesh/devti/gui/chat/ui/InputSelectorsManager\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n37#2,2:149\n1#3:151\n*S KotlinDebug\n*F\n+ 1 InputSelectorsManager.kt\ncc/unitmesh/devti/gui/chat/ui/InputSelectorsManager\n*L\n46#1:149,2\n*E\n"})
public final class InputSelectorsManager {
    @NotNull
    private final Project project;
    private final boolean showAgent;
    private ComboBox<ModelItem> modelSelector;
    @NotNull
    private final CustomAgentConfig defaultRag;
    public ComboBox<CustomAgentConfig> customAgentBox;

    public InputSelectorsManager(@NotNull Project project, boolean showAgent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.showAgent = showAgent;
        this.defaultRag = new CustomAgentConfig("<Select Custom Agent>", "Normal", null, null, null, null, null, null, null, 0L, false, null, false, 8188, null);
    }

    public /* synthetic */ InputSelectorsManager(Project project, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(project, bl);
    }

    @NotNull
    public final ComboBox<ModelItem> getModelSelector() {
        ComboBox<ModelItem> comboBox = this.modelSelector;
        if (comboBox != null) {
            return comboBox;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"modelSelector");
        return null;
    }

    @NotNull
    public final ComboBox<CustomAgentConfig> getCustomAgentBox() {
        ComboBox<CustomAgentConfig> comboBox = this.customAgentBox;
        if (comboBox != null) {
            return comboBox;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"customAgentBox");
        return null;
    }

    public final void setCustomAgentBox(@NotNull ComboBox<CustomAgentConfig> comboBox) {
        Intrinsics.checkNotNullParameter(comboBox, (String)"<set-?>");
        this.customAgentBox = comboBox;
    }

    @Nullable
    public final JPanel initialize() {
        JPanel jPanel;
        this.createModelSelector();
        if (AutoDevCustomizeSettingsKt.getCustomizeSetting(this.project).getEnableCustomAgent() && this.showAgent) {
            this.createAgentSelector();
            jPanel = this.createLeftPanel();
        } else {
            jPanel = null;
        }
        return jPanel;
    }

    private final void createModelSelector() {
        CharSequence charSequence;
        List<ModelItem> modelItems = LLMModelManager.Companion.getInstance().getAllAvailableModels();
        Collection $this$toTypedArray$iv = modelItems;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.modelSelector = new ComboBox((Object[])thisCollection$iv.toArray(new ModelItem[0]));
        this.getModelSelector().setRenderer((ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> InputSelectorsManager.createModelSelector$lambda$1(InputSelectorsManager::createModelSelector$lambda$0, arg_0, arg_1, arg_2)));
        CharSequence $i$f$toTypedArray22 = AutoDevSettingsState.Companion.getInstance().getDefaultModelId();
        if ($i$f$toTypedArray22.length() == 0) {
            boolean bl = false;
            charSequence = "Default";
        } else {
            charSequence = $i$f$toTypedArray22;
        }
        String currentModel = (String)charSequence;
        int n = this.getModelSelector().getItemCount();
        for (int i = 0; i < n; ++i) {
            ModelItem item = (ModelItem)this.getModelSelector().getItemAt(i);
            if (!Intrinsics.areEqual((Object)item.getModelId(), (Object)currentModel)) continue;
            this.getModelSelector().setSelectedIndex(i);
            break;
        }
        this.getModelSelector().addActionListener(arg_0 -> InputSelectorsManager.createModelSelector$lambda$3(this, arg_0));
        this.getModelSelector().setPreferredSize(new Dimension(200, this.getModelSelector().getPreferredSize().height));
    }

    private final void createAgentSelector() {
        this.setCustomAgentBox((ComboBox<CustomAgentConfig>)new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel(this.loadAgents())));
        this.getCustomAgentBox().setRenderer((ListCellRenderer)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> InputSelectorsManager.createAgentSelector$lambda$5(InputSelectorsManager::createAgentSelector$lambda$4, arg_0, arg_1, arg_2)));
        this.getCustomAgentBox().setSelectedItem((Object)this.defaultRag);
        this.getCustomAgentBox().addActionListener(arg_0 -> InputSelectorsManager.createAgentSelector$lambda$6(this, arg_0));
    }

    private final JPanel createLeftPanel() {
        JPanel leftPanel = new JPanel(new FlowLayout(0, 0, 0));
        leftPanel.add((Component)this.getCustomAgentBox());
        leftPanel.add(Box.createHorizontalStrut(JBUI.scale((int)8)));
        leftPanel.add((Component)this.getModelSelector());
        return leftPanel;
    }

    private final List<CustomAgentConfig> loadAgents() {
        List<CustomAgentConfig> rags = CustomAgentConfig.Companion.loadFromProject(this.project);
        if (rags.isEmpty()) {
            Object[] objectArray = new CustomAgentConfig[]{this.defaultRag};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        return CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.defaultRag), (Iterable)rags));
    }

    private final void refreshAgentList() {
        Object currentSelection = this.getCustomAgentBox().getSelectedItem();
        List<CustomAgentConfig> agents = this.loadAgents();
        ComboBoxModel comboBoxModel = this.getCustomAgentBox().getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.MutableCollectionComboBoxModel<cc.unitmesh.devti.agent.custom.model.CustomAgentConfig>");
        MutableCollectionComboBoxModel model = (MutableCollectionComboBoxModel)comboBoxModel;
        model.update(agents);
        if (currentSelection != null && CollectionsKt.contains((Iterable)agents, (Object)currentSelection)) {
            this.getCustomAgentBox().setSelectedItem(currentSelection);
        } else {
            this.getCustomAgentBox().setSelectedItem((Object)this.defaultRag);
        }
    }

    public final boolean hasSelectedAgent() {
        if (!AutoDevCustomizeSettingsKt.getCustomizeSetting(this.project).getEnableCustomAgent()) {
            return false;
        }
        if (this.customAgentBox == null) {
            return false;
        }
        if (this.getCustomAgentBox().getSelectedItem() == null) {
            return false;
        }
        return !Intrinsics.areEqual((Object)this.getCustomAgentBox().getSelectedItem(), (Object)this.defaultRag);
    }

    @NotNull
    public final CustomAgentConfig getSelectedAgent() {
        Object object = this.getCustomAgentBox().getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type cc.unitmesh.devti.agent.custom.model.CustomAgentConfig");
        return (CustomAgentConfig)object;
    }

    public final void selectAgent(@NotNull CustomAgentConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.customAgentBox != null) {
            this.getCustomAgentBox().setSelectedItem((Object)config);
        }
    }

    public final void resetAgent() {
        if (this.customAgentBox != null) {
            Object object = this.getCustomAgentBox().getSelectedItem();
            CustomAgentConfig customAgentConfig = object instanceof CustomAgentConfig ? (CustomAgentConfig)object : null;
            if (customAgentConfig != null) {
                CustomAgentConfig it = customAgentConfig;
                boolean bl = false;
                it.setState(CustomAgentState.START);
            }
            this.getCustomAgentBox().setSelectedItem((Object)this.defaultRag);
        }
    }

    @Nullable
    public final ComboBox<CustomAgentConfig> getCustomAgent() {
        return this.customAgentBox != null ? this.getCustomAgentBox() : null;
    }

    private static final Unit createModelSelector$lambda$0(JBLabel label, ModelItem value, int n) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        if (value != null) {
            label.setText(value.getDisplayName());
        }
        return Unit.INSTANCE;
    }

    private static final void createModelSelector$lambda$1(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    private static final void createModelSelector$lambda$3(InputSelectorsManager this$0, ActionEvent it) {
        Object object = this$0.getModelSelector().getSelectedItem();
        ModelItem modelItem = object instanceof ModelItem ? (ModelItem)object : null;
        if (modelItem == null) {
            return;
        }
        ModelItem selected = modelItem;
        String newProvider = LLMModelManager.Companion.getInstance().getProviderFromModelId(selected.getModelId());
        AutoDevSettingsState.Companion.getInstance().setDefaultModelId(newProvider);
    }

    private static final Unit createAgentSelector$lambda$4(JBLabel label, CustomAgentConfig value, int n) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        if (value != null) {
            label.setText(value.getName());
        }
        return Unit.INSTANCE;
    }

    private static final void createAgentSelector$lambda$5(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    private static final void createAgentSelector$lambda$6(InputSelectorsManager this$0, ActionEvent it) {
        if (this$0.getCustomAgentBox().isPopupVisible()) {
            this$0.refreshAgentList();
        }
    }
}

