/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.ui;

import cc.unitmesh.devti.agent.custom.model.CustomAgentConfig;
import cc.unitmesh.devti.gui.AutoDevCoolBorder;
import cc.unitmesh.devti.gui.chat.ui.AutoDevInput;
import cc.unitmesh.devti.gui.chat.ui.AutoDevInputListener;
import cc.unitmesh.devti.gui.chat.ui.AutoDevInputTrigger;
import cc.unitmesh.devti.gui.chat.ui.InputControlsManager;
import cc.unitmesh.devti.gui.chat.ui.InputSelectorsManager;
import cc.unitmesh.devti.gui.chat.ui.TokenUsagePanel;
import cc.unitmesh.devti.gui.chat.ui.file.RelatedFileWorkspaceManager;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.ui.HintHint;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020#J\b\u0010(\u001a\u00020%H\u0002J\u001a\u0010)\u001a\u00020%2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020+H\u0002J\u0006\u0010-\u001a\u00020%J\u0006\u0010.\u001a\u00020%J\u0006\u0010/\u001a\u00020%J\u000e\u00100\u001a\u00020%2\u0006\u0010'\u001a\u00020#J\u001e\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u0002032\u0006\u0010'\u001a\u00020#J\u0006\u00104\u001a\u00020\u0007J\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020%2\u0006\u00108\u001a\u000206J\u0006\u00109\u001a\u00020%J\u000e\u0010:\u001a\u00020%2\u0006\u0010'\u001a\u00020#J\u0006\u0010;\u001a\u00020%J\u0006\u0010<\u001a\u00020%J\b\u0010=\u001a\u00020>H\u0016J\n\u0010?\u001a\u0004\u0018\u00010@H\u0016J\u0012\u0010A\u001a\u00020%2\b\u0010B\u001a\u0004\u0018\u00010@H\u0016J\u000e\u0010C\u001a\u00020%2\u0006\u0010D\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010E\u001a\u00020F8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\u00a8\u0006I"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/AutoDevInputSection;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "showAgent", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Z)V", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "editorListeners", "Lcom/intellij/util/EventDispatcher;", "Lcc/unitmesh/devti/gui/chat/ui/AutoDevInputListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getEditorListeners", "()Lcom/intellij/util/EventDispatcher;", "inputControlsManager", "Lcc/unitmesh/devti/gui/chat/ui/InputControlsManager;", "inputSelectorsManager", "Lcc/unitmesh/devti/gui/chat/ui/InputSelectorsManager;", "relatedFileWorkspaceManager", "Lcc/unitmesh/devti/gui/chat/ui/file/RelatedFileWorkspaceManager;", "tokenUsagePanel", "Lcc/unitmesh/devti/gui/chat/ui/TokenUsagePanel;", "inputPanel", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "focusableComponent", "Ljavax/swing/JComponent;", "getFocusableComponent", "()Ljavax/swing/JComponent;", "renderText", "", "clearText", "", "setText", "text", "setupTokenUsageListener", "setupLayout", "leftPanel", "Ljavax/swing/JPanel;", "headerPanel", "showStopButton", "showSendButton", "send", "showTooltip", "component", "position", "Lcom/intellij/openapi/ui/popup/Balloon$Position;", "hasSelectedAgent", "getSelectedAgent", "Lcc/unitmesh/devti/agent/custom/model/CustomAgentConfig;", "selectAgent", "config", "resetAgent", "setContent", "moveCursorToStart", "initEditor", "getPreferredSize", "Ljava/awt/Dimension;", "getBackground", "Ljava/awt/Color;", "setBackground", "bg", "addListener", "listener", "maxHeight", "", "getMaxHeight", "()I", "core"})
public final class AutoDevInputSection
extends BorderLayoutPanel {
    @NotNull
    private final Project project;
    @Nullable
    private final Disposable disposable;
    @NotNull
    private final EventDispatcher<AutoDevInputListener> editorListeners;
    @NotNull
    private final InputControlsManager inputControlsManager;
    @NotNull
    private final InputSelectorsManager inputSelectorsManager;
    @NotNull
    private final RelatedFileWorkspaceManager relatedFileWorkspaceManager;
    @NotNull
    private final TokenUsagePanel tokenUsagePanel;
    @NotNull
    private final BorderLayoutPanel inputPanel;
    @Nullable
    private MessageBusConnection messageBusConnection;

    public AutoDevInputSection(@NotNull Project project, @Nullable Disposable disposable, boolean showAgent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.disposable = disposable;
        EventDispatcher eventDispatcher = EventDispatcher.create(AutoDevInputListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.editorListeners = eventDispatcher;
        this.inputControlsManager = new InputControlsManager(this.project, this.disposable, this.editorListeners, showAgent);
        this.inputSelectorsManager = new InputSelectorsManager(this.project, showAgent);
        this.relatedFileWorkspaceManager = new RelatedFileWorkspaceManager(this.project, this.disposable);
        this.tokenUsagePanel = new TokenUsagePanel(this.project);
        this.inputPanel = new BorderLayoutPanel();
        this.inputControlsManager.initialize(this);
        JPanel leftPanel = this.inputSelectorsManager.initialize();
        JPanel headerPanel2 = this.relatedFileWorkspaceManager.initialize(this.inputControlsManager.getInput());
        this.setupTokenUsageListener();
        this.setupLayout(leftPanel, headerPanel2);
        this.addListener(new AutoDevInputListener(){

            @Override
            public void editorAdded(EditorEx editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.initEditor();
            }

            @Override
            public void onSubmit(AutoDevInputSection component2, AutoDevInputTrigger trigger) {
                AutoDevInputListener.DefaultImpls.onSubmit(this, component2, trigger);
            }

            @Override
            public void onStop(AutoDevInputSection component2) {
                AutoDevInputListener.DefaultImpls.onStop(this, component2);
            }

            @Override
            public void manualSend(String userInput) {
                AutoDevInputListener.DefaultImpls.manualSend(this, userInput);
            }
        });
    }

    public /* synthetic */ AutoDevInputSection(Project project, Disposable disposable, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(project, disposable, bl);
    }

    @Nullable
    public final Disposable getDisposable() {
        return this.disposable;
    }

    @NotNull
    public final EventDispatcher<AutoDevInputListener> getEditorListeners() {
        return this.editorListeners;
    }

    @NotNull
    public final JComponent getFocusableComponent() {
        return this.inputControlsManager.getFocusableComponent();
    }

    @NotNull
    public final String renderText() {
        String inputText = this.inputControlsManager.renderText();
        String files = this.relatedFileWorkspaceManager.renderText();
        return ((CharSequence)files).length() > 0 ? inputText + "\n" + files : inputText;
    }

    public final void clearText() {
        this.inputControlsManager.clearText();
    }

    public final void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.inputControlsManager.setText(text);
    }

    private final void setupTokenUsageListener() {
        block1: {
            this.messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
            Disposable disposable = this.disposable;
            if (disposable == null) break block1;
            Disposable it = disposable;
            boolean bl = false;
            MessageBusConnection messageBusConnection = this.messageBusConnection;
            if (messageBusConnection != null) {
                MessageBusConnection connection = messageBusConnection;
                boolean bl2 = false;
                Disposer.register((Disposable)it, () -> AutoDevInputSection.setupTokenUsageListener$lambda$2$lambda$1$lambda$0(connection));
            }
        }
    }

    private final void setupLayout(JPanel leftPanel, JPanel headerPanel2) {
        BorderLayoutPanel layoutPanel = new BorderLayoutPanel();
        Component horizontalGlue = Box.createHorizontalGlue();
        horizontalGlue.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ AutoDevInputSection this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                IdeFocusManager.getInstance((Project)AutoDevInputSection.access$getProject$p(this.this$0)).requestFocus((Component)((Object)AutoDevInputSection.access$getInputControlsManager$p(this.this$0).getInput()), true);
                AutoDevInputSection.access$getInputControlsManager$p(this.this$0).getInput().getCaretModel().moveToOffset(AutoDevInputSection.access$getInputControlsManager$p(this.this$0).getInput().getText().length() - 1);
            }
        });
        layoutPanel.setOpaque(false);
        if (leftPanel != null) {
            this.inputControlsManager.getInput().setMinimumSize(new Dimension(this.inputControlsManager.getInput().getMinimumSize().width, 64));
            v0 = layoutPanel.addToLeft((Component)leftPanel);
        } else {
            v0 = layoutPanel.addToLeft((Component)this.inputSelectorsManager.getModelSelector());
        }
        layoutPanel.addToCenter(horizontalGlue);
        layoutPanel.addToRight((Component)this.inputControlsManager.getButtonPanel());
        BorderLayoutPanel bottomPanel = new BorderLayoutPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.addToTop((Component)layoutPanel);
        bottomPanel.addToBottom((Component)((Object)this.tokenUsagePanel));
        this.inputPanel.add((Component)((Object)this.inputControlsManager.getInput()), (Object)"Center");
        this.inputPanel.addToBottom((Component)bottomPanel);
        this.inputPanel.addToTop((Component)this.relatedFileWorkspaceManager.getWorkspacePanel());
        this.add(headerPanel2, "North");
        this.add((Component)this.inputPanel, "Center");
    }

    public final void showStopButton() {
        this.inputControlsManager.showStopButton();
    }

    public final void showSendButton() {
        this.inputControlsManager.showSendButton();
    }

    public final void send() {
        this.inputControlsManager.send();
    }

    public final void showTooltip(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.showTooltip((JComponent)((Object)this.inputControlsManager.getInput()), Balloon.Position.above, text);
    }

    public final void showTooltip(@NotNull JComponent component2, @NotNull Balloon.Position position, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Point point = new Point(component2.getX(), component2.getY());
        HintHint hintHint = new HintHint((Component)component2, point).setAwtTooltip(true).setPreferredPosition(position);
        JEditorPane tipComponent = IdeTooltipManager.initPane((String)text, (HintHint)hintHint, null);
        IdeTooltip tooltip = new IdeTooltip((Component)component2, point, (JComponent)tipComponent, new Object[0]);
        IdeTooltipManager.getInstance().show(tooltip, true);
    }

    public final boolean hasSelectedAgent() {
        return this.inputSelectorsManager.hasSelectedAgent();
    }

    @NotNull
    public final CustomAgentConfig getSelectedAgent() {
        return this.inputSelectorsManager.getSelectedAgent();
    }

    public final void selectAgent(@NotNull CustomAgentConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.inputSelectorsManager.selectAgent(config);
    }

    public final void resetAgent() {
        this.inputSelectorsManager.resetAgent();
        this.inputControlsManager.clearText();
        this.relatedFileWorkspaceManager.clearWorkspace();
        this.tokenUsagePanel.reset();
    }

    public final void setContent(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.inputControlsManager.setContent(text);
    }

    public final void moveCursorToStart() {
        this.inputControlsManager.moveCursorToStart();
    }

    public final void initEditor() {
        Editor editor = this.inputControlsManager.getInput().getEditor();
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        if (editorEx == null) {
            return;
        }
        EditorEx editorEx2 = editorEx;
        this.inputPanel.setBorder((Border)new AutoDevCoolBorder(editorEx2, (JComponent)((Object)this)));
        UIUtil.setOpaqueRecursively((Component)((Component)((Object)this)), (boolean)false);
        this.revalidate();
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension result = (Dimension)ActionsKt.runReadAction(() -> AutoDevInputSection.getPreferredSize$lambda$3(this));
        result.height = Math.max(Math.min(result.height, this.getMaxHeight()), this.getMinimumSize().height);
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    @Nullable
    public Color getBackground() {
        AutoDevInput input;
        InputControlsManager inputControlsManager = this.inputControlsManager;
        AutoDevInput autoDevInput = input = inputControlsManager != null ? inputControlsManager.getInput() : null;
        if (input == null) {
            return super.getBackground();
        }
        Editor editor = input.getEditor();
        if (editor == null) {
            return super.getBackground();
        }
        Editor editor2 = editor;
        return editor2.getColorsScheme().getDefaultBackground();
    }

    public void setBackground(@Nullable Color bg) {
    }

    public final void addListener(@NotNull AutoDevInputListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.editorListeners.addListener((EventListener)listener2);
    }

    private final int getMaxHeight() {
        InternalDecorator decorator = (InternalDecorator)UIUtil.getParentOfType(InternalDecorator.class, (Component)((Component)((Object)this)));
        InternalDecorator internalDecorator = decorator;
        if (internalDecorator == null || (internalDecorator = internalDecorator.getContentManager()) == null) {
            return JBUI.scale((int)200);
        }
        InternalDecorator contentManager = internalDecorator;
        return contentManager.getComponent().getHeight() / 2;
    }

    private static final void setupTokenUsageListener$lambda$2$lambda$1$lambda$0(MessageBusConnection $connection) {
        $connection.disconnect();
    }

    private static final Dimension getPreferredSize$lambda$3(AutoDevInputSection this$0) {
        return super.getPreferredSize();
    }

    public static final /* synthetic */ Project access$getProject$p(AutoDevInputSection $this) {
        return $this.project;
    }

    public static final /* synthetic */ InputControlsManager access$getInputControlsManager$p(AutoDevInputSection $this) {
        return $this.inputControlsManager;
    }
}

