/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat.ui;

import cc.unitmesh.devti.gui.chat.ui.AutoDevInputKt;
import cc.unitmesh.devti.gui.chat.ui.AutoDevInputListener;
import cc.unitmesh.devti.gui.chat.ui.AutoDevInputSection;
import cc.unitmesh.devti.gui.chat.ui.AutoDevInputTrigger;
import cc.unitmesh.devti.gui.chat.ui.AutoInputService;
import cc.unitmesh.devti.settings.locale.LanguageChangedCallback;
import cc.unitmesh.devti.util.InsertUtil;
import cc.unitmesh.devti.util.parser.CodeFence;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001fH\u0002J\b\u0010#\u001a\u00020\u001fH\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u001fH\u0016J\u0006\u0010.\u001a\u00020\u001fJ\u0010\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020,R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcc/unitmesh/devti/gui/chat/ui/AutoDevInput;", "Lcom/intellij/ui/EditorTextField;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "listeners", "", "Lcom/intellij/openapi/editor/event/DocumentListener;", "disposable", "inputSection", "Lcc/unitmesh/devti/gui/chat/ui/AutoDevInputSection;", "showAgent", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/Disposable;Lcc/unitmesh/devti/gui/chat/ui/AutoDevInputSection;Z)V", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "getInputSection", "()Lcc/unitmesh/devti/gui/chat/ui/AutoDevInputSection;", "getShowAgent", "()Z", "editorListeners", "Lcom/intellij/util/EventDispatcher;", "Lcc/unitmesh/devti/gui/chat/ui/AutoDevInputListener;", "submitAction", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lorg/jetbrains/annotations/NotNull;", "enterShortcutSet", "Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "newlineAction", "insertNewLine", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerEnterShortcut", "unregisterEnterShortcut", "onEditorAdded", "createEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getBackground", "Ljava/awt/Color;", "getData", "", "dataId", "", "dispose", "recreateDocument", "initializeDocumentListeners", "inputDocument", "Lcom/intellij/openapi/editor/Document;", "appendText", "text", "core"})
@SourceDebugExtension(value={"SMAP\nAutoDevInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoDevInput.kt\ncc/unitmesh/devti/gui/chat/ui/AutoDevInput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1855#2,2:223\n1855#2,2:225\n1855#2,2:227\n*S KotlinDebug\n*F\n+ 1 AutoDevInput.kt\ncc/unitmesh/devti/gui/chat/ui/AutoDevInput\n*L\n115#1:223,2\n172#1:225,2\n192#1:227,2\n*E\n"})
public final class AutoDevInput
extends EditorTextField
implements Disposable {
    @NotNull
    private final List<DocumentListener> listeners;
    @Nullable
    private final Disposable disposable;
    @NotNull
    private final AutoDevInputSection inputSection;
    private final boolean showAgent;
    @NotNull
    private EventDispatcher<AutoDevInputListener> editorListeners;
    @NotNull
    private final DumbAwareAction submitAction;
    @NotNull
    private final CustomShortcutSet enterShortcutSet;
    @NotNull
    private final DumbAwareAction newlineAction;

    public AutoDevInput(@NotNull Project project, @NotNull List<? extends DocumentListener> listeners, @Nullable Disposable disposable, @NotNull AutoDevInputSection inputSection, boolean showAgent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter((Object)((Object)inputSection), (String)"inputSection");
        super(project, (FileType)FileTypes.PLAIN_TEXT);
        this.listeners = listeners;
        this.disposable = disposable;
        this.inputSection = inputSection;
        this.showAgent = showAgent;
        this.editorListeners = this.inputSection.getEditorListeners();
        DumbAwareAction dumbAwareAction = DumbAwareAction.create(arg_0 -> AutoDevInput.submitAction$lambda$1(arg_0 -> AutoDevInput.submitAction$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        this.submitAction = dumbAwareAction;
        Shortcut[] shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(10, 0), null)};
        this.enterShortcutSet = new CustomShortcutSet(shortcutArray);
        DumbAwareAction dumbAwareAction2 = DumbAwareAction.create(arg_0 -> AutoDevInput.newlineAction$lambda$3(arg_0 -> AutoDevInput.newlineAction$lambda$2(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction2, (String)"create(...)");
        this.newlineAction = dumbAwareAction2;
        AutoInputService.Companion.getInstance(project).registerAutoDevInput(this);
        this.setOneLineMode(false);
        if (this.showAgent) {
            LanguageChangedCallback.placeholder$default(LanguageChangedCallback.INSTANCE, "chat.panel.initial.text", this, 0, 4, null);
        } else {
            LanguageChangedCallback.placeholder$default(LanguageChangedCallback.INSTANCE, "chat.panel.initial.text.noAgent", this, 0, 4, null);
        }
        this.setFontInheritedFromLAF(true);
        this.addSettingsProvider(AutoDevInput::_init_$lambda$6);
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        this.setBackground(color);
        this.registerEnterShortcut();
        shortcutArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(10, 128), null), new KeyboardShortcut(KeyStroke.getKeyStroke(10, 256), null), new KeyboardShortcut(KeyStroke.getKeyStroke(10, 64), null)};
        this.newlineAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this));
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentListener listener2 = (DocumentListener)element$iv;
            boolean bl = false;
            this.getDocument().addDocumentListener(listener2);
        }
        MessageBus messageBus = project.getMessageBus();
        Disposable disposable2 = this.disposable;
        if (disposable2 == null) {
            disposable2 = this;
        }
        MessageBusConnection messageBusConnection = messageBus.connect(disposable2);
        Topic topic = LookupManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new LookupManagerListener(){

            public void activeLookupChanged(Lookup oldLookup, Lookup newLookup) {
                if (newLookup != null) {
                    this.unregisterEnterShortcut();
                } else {
                    this.registerEnterShortcut();
                }
            }
        });
    }

    public /* synthetic */ AutoDevInput(Project project, List list, Disposable disposable, AutoDevInputSection autoDevInputSection, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(project, list, disposable, autoDevInputSection, bl);
    }

    @Nullable
    public final Disposable getDisposable() {
        return this.disposable;
    }

    @NotNull
    public final AutoDevInputSection getInputSection() {
        return this.inputSection;
    }

    public final boolean getShowAgent() {
        return this.showAgent;
    }

    private final void insertNewLine(Editor editor) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> AutoDevInput.insertNewLine$lambda$5(editor, this), "Insert New Line", null);
    }

    private final void registerEnterShortcut() {
        this.submitAction.registerCustomShortcutSet((ShortcutSet)this.enterShortcutSet, (JComponent)((Object)this));
    }

    private final void unregisterEnterShortcut() {
        this.submitAction.unregisterCustomShortcutSet((JComponent)((Object)this));
    }

    protected void onEditorAdded(@NotNull Editor editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Object object = this.editorListeners;
            if (object == null || (object = (AutoDevInputListener)object.getMulticaster()) == null) break block0;
            object.editorAdded((EditorEx)editor);
        }
    }

    @NotNull
    public EditorEx createEditor() {
        EditorEx editorEx = super.createEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
        EditorEx editor = editorEx;
        editor.setVerticalScrollbarVisible(true);
        this.setBorder((Border)JBUI.Borders.empty());
        editor.setShowPlaceholderWhenFocused(true);
        editor.getCaretModel().moveToOffset(0);
        editor.getScrollPane().setBorder(this.getBorder());
        editor.getContentComponent().setOpaque(false);
        return editor;
    }

    @NotNull
    public Color getBackground() {
        Editor editor = this.getEditor();
        if (editor == null) {
            Color color = super.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
            return color;
        }
        Editor editor2 = editor;
        Color color = editor2.getColorsScheme().getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        return color;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (!PlatformCoreDataKeys.FILE_EDITOR.is(dataId)) {
            return super.getData(dataId);
        }
        Editor editor = this.getEditor();
        if (editor == null) {
            return super.getData(dataId);
        }
        Editor currentEditor = editor;
        return TextEditorProvider.Companion.getInstance().getTextEditor(currentEditor);
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentListener it = (DocumentListener)element$iv;
            boolean bl = false;
            Editor editor = this.getEditor();
            if (editor == null || (editor = editor.getDocument()) == null) continue;
            editor.removeDocumentListener(it);
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AutoInputService.Companion.getInstance(project).deregisterAutoDevInput(this);
    }

    public final void recreateDocument() {
        Language language = CodeFence.Companion.findLanguage("DevIn");
        UUID id = UUID.randomUUID();
        LightVirtualFile file = new LightVirtualFile("AutoDevInput-" + id, language, (CharSequence)"");
        Document document = AutoDevInputKt.findDocument((VirtualFile)file);
        if (document == null) {
            throw new IllegalStateException("Can't create in-memory document");
        }
        Document document2 = document;
        this.initializeDocumentListeners(document2);
        this.setDocument(document2);
        this.inputSection.initEditor();
    }

    private final void initializeDocumentListeners(Document inputDocument) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocumentListener listener2 = (DocumentListener)element$iv;
            boolean bl = false;
            inputDocument.addDocumentListener(listener2);
        }
    }

    public final void appendText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)"Append text", (String)"intentions.write.action", () -> AutoDevInput.appendText$lambda$10(this, text), (PsiFile[])new PsiFile[0]);
    }

    private static final Unit submitAction$lambda$0(AutoDevInput this$0, AnActionEvent it) {
        ((AutoDevInputListener)this$0.editorListeners.getMulticaster()).onSubmit(this$0.inputSection, AutoDevInputTrigger.Key);
        return Unit.INSTANCE;
    }

    private static final void submitAction$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit newlineAction$lambda$2(AutoDevInput this$0, AnActionEvent it) {
        Editor editor = this$0.getEditor();
        if (editor == null) {
            return Unit.INSTANCE;
        }
        Editor editor2 = editor;
        this$0.insertNewLine(editor2);
        return Unit.INSTANCE;
    }

    private static final void newlineAction$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void insertNewLine$lambda$5$lambda$4(String $textAfterCaret, Document $document, int $caretOffset, String $eol, Editor $editor) {
        if (StringsKt.isBlank((CharSequence)$textAfterCaret)) {
            $document.insertString($caretOffset, (CharSequence)$eol);
            EditorModificationUtil.moveCaretRelatively((Editor)$editor, (int)1);
        } else {
            $document.insertString($caretOffset, (CharSequence)$eol);
            $editor.getCaretModel().moveToOffset($caretOffset + $eol.length());
        }
    }

    private static final void insertNewLine$lambda$5(Editor $editor, AutoDevInput this$0) {
        String eol = "\n";
        Document document = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int caretOffset = $editor.getCaretModel().getOffset();
        int lineEndOffset = document2.getLineEndOffset(document2.getLineNumber(caretOffset));
        String string = document2.getText(new TextRange(caretOffset, lineEndOffset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String textAfterCaret = string;
        WriteCommandAction.runWriteCommandAction((Project)this$0.getProject(), () -> AutoDevInput.insertNewLine$lambda$5$lambda$4(textAfterCaret, document2, caretOffset, eol, $editor));
    }

    private static final void _init_$lambda$6(EditorEx it) {
        it.putUserData(IncrementalFindAction.SEARCH_DISABLED, (Object)true);
        it.getColorsScheme().setLineSpacing(1.2f);
        it.getSettings().setUseSoftWraps(true);
        it.setEmbeddedIntoDialogWrapper(true);
        it.getContentComponent().setOpaque(false);
    }

    private static final void appendText$lambda$10(AutoDevInput this$0, String $text) {
        Editor editor = this$0.getEditor();
        if (editor == null || (editor = editor.getDocument()) == null) {
            return;
        }
        Editor document = editor;
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        InsertUtil.INSTANCE.insertStringAndSaveChange(project, $text, (Document)document, document.getTextLength(), false);
    }
}

