/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui.chat;

import cc.unitmesh.cf.core.llms.LlmMsg;
import cc.unitmesh.devti.agent.custom.CustomAgentChatProcessor;
import cc.unitmesh.devti.agent.custom.model.CustomAgentConfig;
import cc.unitmesh.devti.agent.custom.model.CustomAgentState;
import cc.unitmesh.devti.custom.compile.CustomVariable;
import cc.unitmesh.devti.custom.compile.VariableTemplateCompiler;
import cc.unitmesh.devti.gui.chat.NormalChatCodingPanel;
import cc.unitmesh.devti.gui.chat.message.ChatActionType;
import cc.unitmesh.devti.gui.chat.message.ChatContext;
import cc.unitmesh.devti.gui.chat.message.ChatRole;
import cc.unitmesh.devti.llms.LLMProvider;
import cc.unitmesh.devti.llms.LLMProviderAdapter;
import cc.unitmesh.devti.llms.LlmFactory;
import cc.unitmesh.devti.llms.custom.Message;
import cc.unitmesh.devti.provider.ContextPrompter;
import cc.unitmesh.devti.settings.customize.AutoDevCustomizeSettingsKt;
import cc.unitmesh.devti.util.AutoDevCoroutineScope;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J*\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0019J\u001c\u0010\"\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J*\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150'2\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00192\f\u0010*\u001a\b\u0012\u0004\u0012\u00020%0$J\u0006\u0010+\u001a\u00020\u0017J&\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150'2\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00152\b\b\u0002\u0010/\u001a\u00020\u0019J\f\u00100\u001a\b\u0012\u0004\u0012\u0002010$R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcc/unitmesh/devti/gui/chat/ChatCodingService;", "", "actionType", "Lcc/unitmesh/devti/gui/chat/message/ChatActionType;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcc/unitmesh/devti/gui/chat/message/ChatActionType;Lcom/intellij/openapi/project/Project;)V", "getActionType", "()Lcc/unitmesh/devti/gui/chat/message/ChatActionType;", "setActionType", "(Lcc/unitmesh/devti/gui/chat/message/ChatActionType;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "llmProvider", "Lcc/unitmesh/devti/llms/LLMProvider;", "counitProcessor", "Lcc/unitmesh/devti/agent/custom/CustomAgentChatProcessor;", "currentJob", "Lkotlinx/coroutines/Job;", "getLabel", "", "stop", "", "isLastAgent", "", "handlePromptAndResponse", "ui", "Lcc/unitmesh/devti/gui/chat/NormalChatCodingPanel;", "prompter", "Lcc/unitmesh/devti/provider/ContextPrompter;", "context", "Lcc/unitmesh/devti/gui/chat/message/ChatContext;", "keepHistory", "handleMsgsAndResponse", "messages", "", "Lcc/unitmesh/cf/core/llms/LlmMsg$ChatMessage;", "makeChatBotRequest", "Lkotlinx/coroutines/flow/Flow;", "requestPrompt", "newChatContext", "chatHistory", "clearSession", "sketchRequest", "systemPrompt", "userPrompt", "isFromSketch", "getAllMessages", "Lcc/unitmesh/devti/llms/custom/Message;", "core"})
@SourceDebugExtension(value={"SMAP\nChatCodingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatCodingService.kt\ncc/unitmesh/devti/gui/chat/ChatCodingService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n31#2,2:156\n766#3:158\n857#3,2:159\n766#3:161\n857#3,2:162\n1855#3,2:164\n*S KotlinDebug\n*F\n+ 1 ChatCodingService.kt\ncc/unitmesh/devti/gui/chat/ChatCodingService\n*L\n27#1:156,2\n113#1:158\n113#1:159,2\n114#1:161\n114#1:162,2\n133#1:164,2\n*E\n"})
public final class ChatCodingService {
    @NotNull
    private ChatActionType actionType;
    @NotNull
    private final Project project;
    @NotNull
    private LLMProvider llmProvider;
    @NotNull
    private final CustomAgentChatProcessor counitProcessor;
    @Nullable
    private Job currentJob;
    private boolean isLastAgent;

    public ChatCodingService(@NotNull ChatActionType actionType, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)actionType), (String)"actionType");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.actionType = actionType;
        this.project = project;
        this.llmProvider = LlmFactory.INSTANCE.create(this.project);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<CustomAgentChatProcessor> serviceClass$iv = CustomAgentChatProcessor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.counitProcessor = (CustomAgentChatProcessor)object;
    }

    @NotNull
    public final ChatActionType getActionType() {
        return this.actionType;
    }

    public final void setActionType(@NotNull ChatActionType chatActionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)chatActionType), (String)"<set-?>");
        this.actionType = chatActionType;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getLabel() {
        return this.actionType + " Code";
    }

    public final void stop() {
        Job job = this.currentJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        if (this.llmProvider instanceof LLMProviderAdapter) {
            LLMProvider lLMProvider = this.llmProvider;
            Intrinsics.checkNotNull((Object)lLMProvider, (String)"null cannot be cast to non-null type cc.unitmesh.devti.llms.LLMProviderAdapter");
            ((LLMProviderAdapter)lLMProvider).cancelCurrentRequestSync();
        }
        this.currentJob = null;
    }

    public final void handlePromptAndResponse(@NotNull NormalChatCodingPanel ui, @NotNull ContextPrompter prompter, @Nullable ChatContext context, boolean keepHistory) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)((Object)prompter), (String)"prompter");
        Ref.ObjectRef chatHistory = new Ref.ObjectRef();
        chatHistory.element = CollectionsKt.emptyList();
        Job job = this.currentJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        Ref.ObjectRef requestPrompt2 = new Ref.ObjectRef();
        requestPrompt2.element = prompter.requestPrompt();
        String displayPrompt = null;
        displayPrompt = prompter.displayPrompt();
        if (AutoDevCustomizeSettingsKt.getCustomizeSetting(this.project).getEnableCustomAgent() && ui.hasSelectedCustomAgent()) {
            CustomAgentConfig selectedCustomAgent = ui.getSelectedCustomAgent();
            if (selectedCustomAgent.getState() == CustomAgentState.START) {
                this.isLastAgent = true;
                Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> ChatCodingService.handlePromptAndResponse$lambda$1(this, prompter, ui));
                Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeOnPooledThread(...)");
                Future response = future;
                return;
            }
            if (selectedCustomAgent.getState() == CustomAgentState.FINISHED && CustomVariable.Companion.hasVariable((String)requestPrompt2.element)) {
                VariableTemplateCompiler compiler;
                VariableTemplateCompiler variableTemplateCompiler = compiler = prompter.toTemplateCompiler();
                if (variableTemplateCompiler != null) {
                    VariableTemplateCompiler variableTemplateCompiler2;
                    VariableTemplateCompiler it = variableTemplateCompiler2 = variableTemplateCompiler;
                    boolean bl = false;
                    requestPrompt2.element = CustomVariable.Companion.compile((String)requestPrompt2.element, it);
                    displayPrompt = CustomVariable.Companion.compile(displayPrompt, it);
                }
            }
        }
        if (this.isLastAgent) {
            this.isLastAgent = false;
            chatHistory.element = ui.getHistoryMessages();
        }
        ui.addMessage((String)requestPrompt2.element, true, displayPrompt);
        ApplicationManager.getApplication().executeOnPooledThread(() -> ChatCodingService.handlePromptAndResponse$lambda$3(this, requestPrompt2, keepHistory, chatHistory, ui, context));
    }

    public static /* synthetic */ void handlePromptAndResponse$default(ChatCodingService chatCodingService, NormalChatCodingPanel normalChatCodingPanel, ContextPrompter contextPrompter, ChatContext chatContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            chatContext = null;
        }
        chatCodingService.handlePromptAndResponse(normalChatCodingPanel, contextPrompter, chatContext, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void handleMsgsAndResponse(@NotNull NormalChatCodingPanel ui, @NotNull List<LlmMsg.ChatMessage> messages) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Iterable $this$filter$iv = messages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            LlmMsg.ChatMessage it = (LlmMsg.ChatMessage)element$iv$iv;
            boolean bl = false;
            if (!(it.getRole() == LlmMsg.ChatRole.User)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String requestPrompt2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, ChatCodingService::handleMsgsAndResponse$lambda$5, (int)30, null);
        Iterable $this$filter$iv2 = messages;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LlmMsg.ChatMessage it = (LlmMsg.ChatMessage)element$iv$iv;
            boolean bl = false;
            if (!(it.getRole() == LlmMsg.ChatRole.System)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        String systemPrompt = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, ChatCodingService::handleMsgsAndResponse$lambda$7, (int)30, null);
        ui.addMessage(requestPrompt2, true, requestPrompt2);
        ApplicationManager.getApplication().executeOnPooledThread(() -> ChatCodingService.handleMsgsAndResponse$lambda$8(this, requestPrompt2, systemPrompt, ui));
    }

    @NotNull
    public final Flow<String> makeChatBotRequest(@NotNull String requestPrompt2, boolean newChatContext, @NotNull List<LlmMsg.ChatMessage> chatHistory) {
        Intrinsics.checkNotNullParameter((Object)requestPrompt2, (String)"requestPrompt");
        Intrinsics.checkNotNullParameter(chatHistory, (String)"chatHistory");
        if (!((Collection)chatHistory).isEmpty()) {
            Iterable $this$forEach$iv = chatHistory;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LlmMsg.ChatMessage it = (LlmMsg.ChatMessage)element$iv;
                boolean bl = false;
                this.llmProvider.appendLocalMessage(it.getContent(), ChatRole.valueOf(it.getRole().name()));
            }
        }
        return LLMProvider.DefaultImpls.stream$default(this.llmProvider, requestPrompt2, "", !newChatContext, false, 8, null);
    }

    public final void clearSession() {
        this.stop();
        this.llmProvider = LlmFactory.INSTANCE.create(this.project);
    }

    @NotNull
    public final Flow<String> sketchRequest(@NotNull String systemPrompt, @NotNull String userPrompt, boolean isFromSketch) {
        Intrinsics.checkNotNullParameter((Object)systemPrompt, (String)"systemPrompt");
        Intrinsics.checkNotNullParameter((Object)userPrompt, (String)"userPrompt");
        return this.llmProvider.stream(userPrompt, systemPrompt, true, isFromSketch);
    }

    public static /* synthetic */ Flow sketchRequest$default(ChatCodingService chatCodingService, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return chatCodingService.sketchRequest(string, string2, bl);
    }

    @NotNull
    public final List<Message> getAllMessages() {
        return this.llmProvider.getAllMessages();
    }

    private static final Unit handlePromptAndResponse$lambda$1$lambda$0(NormalChatCodingPanel $ui) {
        $ui.resetAgent();
        $ui.moveCursorToStart();
        return Unit.INSTANCE;
    }

    private static final String handlePromptAndResponse$lambda$1(ChatCodingService this$0, ContextPrompter $prompter, NormalChatCodingPanel $ui) {
        String output = this$0.counitProcessor.handleChat($prompter, $ui, this$0.llmProvider);
        ActionsKt.runInEdt$default(null, () -> ChatCodingService.handlePromptAndResponse$lambda$1$lambda$0($ui), (int)1, null);
        return output;
    }

    private static final void handlePromptAndResponse$lambda$3(ChatCodingService this$0, Ref.ObjectRef $requestPrompt, boolean $keepHistory, Ref.ObjectRef $chatHistory, NormalChatCodingPanel $ui, ChatContext $context) {
        Flow<String> response = this$0.makeChatBotRequest((String)$requestPrompt.element, $keepHistory, (List)$chatHistory.element);
        this$0.currentJob = BuildersKt.launch$default((CoroutineScope)AutoDevCoroutineScope.Companion.scope(this$0.project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $ui, response, $context, null){
            int label;
            final /* synthetic */ ChatCodingService this$0;
            final /* synthetic */ NormalChatCodingPanel $ui;
            final /* synthetic */ Flow<String> $response;
            final /* synthetic */ ChatContext $context;
            {
                this.this$0 = $receiver;
                this.$ui = $ui;
                this.$response = $response;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (this.this$0.getActionType() != ChatActionType.REFACTOR) break;
                        this.label = 1;
                        v0 = this.$ui.updateReplaceableContent(this.$response, (Function1<? super String, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(cc.unitmesh.devti.gui.chat.message.ChatContext java.lang.String ), (Ljava/lang/String;)Lkotlin/Unit;)((ChatContext)this.$context), (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        v1 /* !! */  = Unit.INSTANCE;
                        ** GOTO lbl25
                    }
                }
                this.label = 2;
                v1 /* !! */  = this.$ui.updateMessage(this.$response, (Continuation<? super String>)((Continuation)this));
                if (v1 /* !! */  == var2_2) {
                    return var2_2;
                }
                ** GOTO lbl25
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 /* !! */  = $result;
lbl25:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(ChatContext $context, String it) {
                block0: {
                    Function1<String, Unit> function1 = $context;
                    if (function1 == null || (function1 = function1.getPostAction()) == null) break block0;
                    function1.invoke((Object)it);
                }
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    private static final CharSequence handleMsgsAndResponse$lambda$5(LlmMsg.ChatMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContent();
    }

    private static final CharSequence handleMsgsAndResponse$lambda$7(LlmMsg.ChatMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContent();
    }

    private static final void handleMsgsAndResponse$lambda$8(ChatCodingService this$0, String $requestPrompt, String $systemPrompt, NormalChatCodingPanel $ui) {
        Flow response = LLMProvider.DefaultImpls.stream$default(this$0.llmProvider, $requestPrompt, $systemPrompt, false, false, 12, null);
        this$0.currentJob = BuildersKt.launch$default((CoroutineScope)AutoDevCoroutineScope.Companion.scope(this$0.project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($ui, (Flow<String>)response, null){
            int label;
            final /* synthetic */ NormalChatCodingPanel $ui;
            final /* synthetic */ Flow<String> $response;
            {
                this.$ui = $ui;
                this.$response = $response;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$ui.updateMessage(this.$response, (Continuation<? super String>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }
}

