/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.gui;

import cc.unitmesh.devti.inlay.codecomplete.presentation.PresentationUtil;
import com.intellij.codeInsight.codeVision.CodeVisionEntry;
import com.intellij.codeInsight.codeVision.ui.model.RangeCodeVisionModel;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.CodeVisionThemeInfoProvider;
import com.intellij.codeInsight.codeVision.ui.renderers.painters.ICodeVisionEntryBasePainter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.paint.EffectPainter2D;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004JJ\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u0019"}, d2={"Lcc/unitmesh/devti/gui/LLMTextInlayPainter;", "Lcom/intellij/codeInsight/codeVision/ui/renderers/painters/ICodeVisionEntryBasePainter;", "", "<init>", "()V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "g", "Ljava/awt/Graphics;", "value", "point", "Ljava/awt/Point;", "state", "Lcom/intellij/codeInsight/codeVision/ui/model/RangeCodeVisionModel$InlayState;", "hovered", "", "hoveredEntry", "Lcom/intellij/codeInsight/codeVision/CodeVisionEntry;", "size", "Ljava/awt/Dimension;", "Companion", "core"})
public final class LLMTextInlayPainter
implements ICodeVisionEntryBasePainter<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void paint(@NotNull Editor editor, @NotNull TextAttributes textAttributes, @NotNull Graphics g, @NotNull String value, @NotNull Point point, @NotNull RangeCodeVisionModel.InlayState state, boolean hovered, @Nullable CodeVisionEntry hoveredEntry) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String[] stringArray = new String[]{"\n"};
        Companion.renderCodeBlock(editor, value, StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null), g, new Rectangle2D.Double(point.x, point.y, 0.0, 0.0), textAttributes);
    }

    @NotNull
    public Dimension size(@NotNull Editor editor, @NotNull RangeCodeVisionModel.InlayState state, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CodeVisionThemeInfoProvider themeInfoProvider = PresentationUtil.INSTANCE.getThemeInfoProvider();
        FontMetrics fontMetrics = editor.getComponent().getFontMetrics(themeInfoProvider.font(editor, 0));
        return new Dimension(fontMetrics.stringWidth(value), fontMetrics.getHeight());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJJ\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J8\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0011H\u0002J<\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u001b\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006%"}, d2={"Lcc/unitmesh/devti/gui/LLMTextInlayPainter$Companion;", "", "<init>", "()V", "calculateWidth", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "text", "", "textLines", "", "renderEffects", "", "g2d", "Ljava/awt/Graphics2D;", "x", "", "baseline", "width", "charHeight", "descent", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "font", "Ljava/awt/Font;", "renderBackground", "g", "attributes", "y", "height", "renderCodeBlock", "content", "contentLines", "Ljava/awt/Graphics;", "region", "Ljava/awt/geom/Rectangle2D;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int calculateWidth(@NotNull Editor editor, @NotNull String text, @NotNull List<String> textLines) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(textLines, (String)"textLines");
            FontMetrics metrics = PresentationUtil.INSTANCE.fontMetrics(editor, PresentationUtil.INSTANCE.getFont(editor, text));
            int maxWidth = 0;
            for (String line : textLines) {
                maxWidth = Math.max(maxWidth, metrics.stringWidth(line));
            }
            return maxWidth;
        }

        private final void renderEffects(Graphics2D g2d, double x, double baseline, double width, int charHeight, int descent, TextAttributes textAttributes, Font font) {
            block3: {
                block2: {
                    EffectType effectType = textAttributes.getEffectType();
                    if (effectType == null) break block2;
                    Object object = StyleConstants.CharacterConstants.Underline;
                    if (!(object instanceof Integer) || effectType.ordinal() != ((Number)object).intValue()) break block3;
                }
                EffectPainter2D.LINE_UNDERSCORE.paint(g2d, x, baseline, width, 5.0, (Object)font);
            }
        }

        private final void renderBackground(Graphics2D g, TextAttributes attributes, double x, double y, double width, double height) {
            Color color = attributes.getBackgroundColor();
            if (color != null) {
                g.setColor(color);
                g.fillRoundRect((int)x, (int)y, (int)width, (int)height, 1, 1);
            }
        }

        public final void renderCodeBlock(@NotNull Editor editor, @NotNull String content, @NotNull List<String> contentLines, @NotNull Graphics g, @NotNull Rectangle2D region, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter(contentLines, (String)"contentLines");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            if (((CharSequence)content).length() == 0 || contentLines.isEmpty()) {
                return;
            }
            CodeVisionThemeInfoProvider themeInfoProvider = PresentationUtil.INSTANCE.getThemeInfoProvider();
            TextAttributes attributes = editor.getSelectionModel().getTextAttributes();
            boolean inSelectedBlock = Intrinsics.areEqual((Object)textAttributes.getBackgroundColor(), (Object)attributes.getBackgroundColor());
            Color color = textAttributes.getForegroundColor();
            if (color == null) {
                if (inSelectedBlock) {
                    color = attributes.getForegroundColor();
                    if (color == null) {
                        Color color2 = editor.getColorsScheme().getDefaultForeground();
                        color = color2;
                        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
                    }
                } else {
                    color = themeInfoProvider.foregroundColor(editor, false);
                }
            }
            Color foregroundColor = color;
            Rectangle clipBounds = g.getClipBounds();
            Graphics graphics = g.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2 = (Graphics2D)graphics;
            GraphicsUtil.setupAAPainting((Graphics)g2);
            Font font = themeInfoProvider.font(editor, 0);
            g2.setFont(font);
            FontMetrics metrics = PresentationUtil.INSTANCE.fontMetrics(editor, font);
            double lineHeight = editor.getLineHeight();
            double fontBaseline = Math.ceil(font.createGlyphVector(metrics.getFontRenderContext(), "Alb").getVisualBounds().getHeight());
            double linePadding = (lineHeight - fontBaseline) / 2.0;
            double offsetX = region.getX();
            double offsetY = region.getY() + fontBaseline + linePadding;
            int lineOffset = 0;
            g2.setClip(clipBounds != null && !Intrinsics.areEqual((Object)clipBounds, (Object)region) ? (Shape)region.createIntersection(clipBounds) : (Shape)region);
            for (String line : contentLines) {
                Intrinsics.checkNotNull((Object)attributes);
                this.renderBackground(g2, attributes, offsetX, region.getY() + (double)lineOffset, region.getWidth(), lineHeight);
                g2.setColor(foregroundColor);
                g2.drawString(line, (float)offsetX, (float)(offsetY + (double)lineOffset));
                if (editor instanceof EditorImpl) {
                    this.renderEffects(g2, offsetX, offsetY + (double)lineOffset, metrics.stringWidth(line), ((EditorImpl)editor).getCharHeight(), ((EditorImpl)editor).getDescent(), attributes, font);
                }
                lineOffset = (int)((double)lineOffset + lineHeight);
            }
            g2.dispose();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

