/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.flow.kanban.impl;

import cc.unitmesh.devti.flow.kanban.Kanban;
import cc.unitmesh.devti.flow.model.SimpleStory;
import cc.unitmesh.devti.settings.devops.AutoDevDevOpsConfigurableProviderKt;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.project.Project;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/flow/kanban/impl/GitHubIssue;", "Lcc/unitmesh/devti/flow/kanban/Kanban;", "repoUrl", "", "token", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getRepoUrl", "()Ljava/lang/String;", "setRepoUrl", "(Ljava/lang/String;)V", "getToken", "gitHub", "Lorg/kohsuke/github/GitHub;", "formatUrl", "getStoryById", "Lcc/unitmesh/devti/flow/model/SimpleStory;", "storyId", "getRecentIssueIds", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGitHubIssue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubIssue.kt\ncc/unitmesh/devti/flow/kanban/impl/GitHubIssue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1#2:142\n766#3:143\n857#3,2:144\n1549#3:146\n1620#3,3:147\n*S KotlinDebug\n*F\n+ 1 GitHubIssue.kt\ncc/unitmesh/devti/flow/kanban/impl/GitHubIssue\n*L\n64#1:143\n64#1:144,2\n65#1:146\n65#1:147,3\n*E\n"})
public final class GitHubIssue
implements Kanban {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String repoUrl;
    @NotNull
    private final String token;
    @NotNull
    private final GitHub gitHub;

    public GitHubIssue(@NotNull String repoUrl, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.repoUrl = repoUrl;
        this.token = token;
        if (StringsKt.startsWith$default((String)this.repoUrl, (String)"https", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.repoUrl, (String)"git", (boolean)false, (int)2, null)) {
            this.repoUrl = this.formatUrl(this.repoUrl);
        }
        try {
            GitHub gitHub = new GitHubBuilder().withOAuthToken(this.token).build();
            Intrinsics.checkNotNullExpressionValue((Object)gitHub, (String)"build(...)");
            this.gitHub = gitHub;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize GitHub client: " + e.getMessage(), e);
        }
    }

    @NotNull
    public final String getRepoUrl() {
        return this.repoUrl;
    }

    public final void setRepoUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.repoUrl = string;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final String formatUrl(@NotNull String repoUrl) {
        String string;
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        String[] stringArray = new String[]{"/"};
        String url = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)StringsKt.split$default((CharSequence)repoUrl, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)2), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        if (StringsKt.endsWith$default((String)url, (String)".git", (boolean)false, (int)2, null)) {
            String string2 = url.substring(0, url.length() - 4);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = url;
        }
        url = string;
        return url;
    }

    @Override
    @NotNull
    public SimpleStory getStoryById(@NotNull String storyId) {
        Object v4;
        GHIssue issue;
        block5: {
            Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
            issue = this.gitHub.getRepository(this.repoUrl).getIssue(Integer.parseInt(storyId));
            if (issue.getComments().size() == 0) {
                String string = String.valueOf(issue.getNumber());
                String string2 = issue.getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTitle(...)");
                String string3 = issue.getBody();
                if (string3 == null) {
                    string3 = "";
                }
                return new SimpleStory(string, string2, string3);
            }
            List comments = issue.getComments();
            Intrinsics.checkNotNull((Object)comments);
            Iterable iterable = comments;
            for (Object t : iterable) {
                GHIssueComment it = (GHIssueComment)t;
                boolean bl = false;
                String string = it.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBody(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\u7528\u6237\u6545\u4e8b", (boolean)false, (int)2, null)) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        GHIssueComment comment = v4;
        if (comment != null) {
            String string = String.valueOf(issue.getNumber());
            String string4 = issue.getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getTitle(...)");
            String string5 = comment.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getBody(...)");
            return new SimpleStory(string, string4, string5);
        }
        String string = String.valueOf(issue.getNumber());
        String string6 = issue.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getTitle(...)");
        String string7 = issue.getBody();
        if (string7 == null) {
            string7 = "";
        }
        return new SimpleStory(string, string6, string7);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getRecentIssueIds() {
        List list;
        try {
            void $this$mapTo$iv$iv;
            GHIssue it;
            Iterable $this$filterTo$iv$iv;
            GHRepository repository = this.gitHub.getRepository(this.repoUrl);
            Instant yesterday = Instant.now().minusSeconds(86400L);
            List list2 = repository.getIssues(GHIssueState.ALL);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIssues(...)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GHIssue)element$iv$iv;
                boolean bl = false;
                if (!it.getCreatedAt().toInstant().isAfter(yesterday)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (GHIssue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(String.valueOf(it.getNumber()));
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch recent issues: " + e.getMessage(), e);
        }
        return list;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"Lcc/unitmesh/devti/flow/kanban/impl/GitHubIssue$Companion;", "", "<init>", "()V", "getGitHubRepository", "Lorg/kohsuke/github/GHRepository;", "project", "Lcom/intellij/openapi/project/Project;", "remoteUrl", "", "createGitHubConnection", "Lorg/kohsuke/github/GitHub;", "extractRepositoryPath", "parseGitHubRemoteUrl", "repository", "Lgit4idea/repo/GitRepository;", "parseGitHubRepository", "isGitHubRepository", "", "core"})
    @SourceDebugExtension(value={"SMAP\nGitHubIssue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubIssue.kt\ncc/unitmesh/devti/flow/kanban/impl/GitHubIssue$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n288#2:142\n1747#2,3:143\n289#2:146\n288#2,2:147\n*S KotlinDebug\n*F\n+ 1 GitHubIssue.kt\ncc/unitmesh/devti/flow/kanban/impl/GitHubIssue$Companion\n*L\n101#1:142\n102#1:143,3\n101#1:146\n103#1:147,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GHRepository getGitHubRepository(@NotNull Project project, @NotNull String remoteUrl) {
            GHRepository gHRepository;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)remoteUrl, (String)"remoteUrl");
            GitHub github = this.createGitHubConnection(project);
            try {
                GHRepository gHRepository2;
                String string = this.extractRepositoryPath(remoteUrl);
                if (string != null) {
                    String repoPath = string;
                    boolean bl = false;
                    gHRepository2 = github.getRepository(repoPath);
                } else {
                    gHRepository2 = null;
                }
                gHRepository = gHRepository2;
            }
            catch (Exception e) {
                gHRepository = null;
            }
            return gHRepository;
        }

        @NotNull
        public final GitHub createGitHubConnection(@NotNull Project project) {
            GitHub gitHub;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String token = AutoDevDevOpsConfigurableProviderKt.getDevopsPromptsSettings(project).getGithubToken();
            if (((CharSequence)token).length() == 0) {
                GitHub gitHub2 = GitHub.connectAnonymously();
                Intrinsics.checkNotNull((Object)gitHub2);
                gitHub = gitHub2;
            } else {
                GitHub gitHub3 = GitHub.connectUsingOAuth((String)token);
                Intrinsics.checkNotNull((Object)gitHub3);
                gitHub = gitHub3;
            }
            return gitHub;
        }

        private final String extractRepositoryPath(String remoteUrl) {
            Regex httpsPattern = new Regex("https://github\\.com/([^/]+/[^/]+)(?:\\.git)?/?");
            Regex sshPattern = new Regex("git@github\\.com:([^/]+/[^/]+)(?:\\.git)?/?");
            Object object = Regex.find$default((Regex)httpsPattern, (CharSequence)remoteUrl, (int)0, (int)2, null);
            if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                Object object2 = Regex.find$default((Regex)sshPattern, (CharSequence)remoteUrl, (int)0, (int)2, null);
                object = object2 != null && (object2 = object2.getGroupValues()) != null ? (String)object2.get(1) : null;
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String parseGitHubRemoteUrl(@NotNull GitRepository repository) {
            String string;
            List list;
            Object v3;
            block8: {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Collection collection = repository.getRemotes();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRemotes(...)");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    block7: {
                        GitRemote remote = (GitRemote)element$iv;
                        boolean bl2 = false;
                        List list2 = remote.getUrls();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getUrls(...)");
                        Iterable $this$any$iv = list2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                String it = (String)element$iv2;
                                boolean bl3 = false;
                                Intrinsics.checkNotNull((Object)it);
                                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"github.com", (boolean)false, (int)2, null)) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v3 = element$iv;
                    break block8;
                }
                v3 = null;
            }
            GitRemote gitRemote = v3;
            if (gitRemote != null && (list = gitRemote.getUrls()) != null) {
                Object v4;
                block9: {
                    void $this$firstOrNull$iv;
                    Iterable $i$f$firstOrNull = list;
                    boolean $i$f$firstOrNull2 = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"github.com", (boolean)false, (int)2, null)) continue;
                        v4 = element$iv;
                        break block9;
                    }
                    v4 = null;
                }
                string = v4;
            } else {
                string = null;
            }
            return string;
        }

        @Nullable
        public final GHRepository parseGitHubRepository(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VcsRepositoryManager vcsRepositoryManager = VcsRepositoryManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)vcsRepositoryManager, (String)"getInstance(...)");
            VcsRepositoryManager repositoryManager = vcsRepositoryManager;
            Repository repository = repositoryManager.getRepositoryForFile(project.getBaseDir());
            if (repository == null) {
                return null;
            }
            if (!(repository instanceof GitRepository)) {
                return null;
            }
            String string = this.parseGitHubRemoteUrl((GitRepository)repository);
            if (string == null) {
                return null;
            }
            String remoteUrl = string;
            return this.getGitHubRepository(project, remoteUrl);
        }

        public final boolean isGitHubRepository(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VcsRepositoryManager vcsRepositoryManager = VcsRepositoryManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)vcsRepositoryManager, (String)"getInstance(...)");
            VcsRepositoryManager repositoryManager = vcsRepositoryManager;
            Repository repository = repositoryManager.getRepositoryForFile(project.getBaseDir());
            if (repository == null) {
                return false;
            }
            if (!(repository instanceof GitRepository)) {
                return false;
            }
            String string = this.parseGitHubRemoteUrl((GitRepository)repository);
            if (string == null) {
                return false;
            }
            String remoteUrl = string;
            return StringsKt.contains$default((CharSequence)remoteUrl, (CharSequence)"github.com", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

