/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.envior;

import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\nH\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J@\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\nJ\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lcc/unitmesh/devti/envior/ShireEnvVariableFiller;", "", "<init>", "()V", "getVariableValue", "", "jsonObject", "Lcom/intellij/json/psi/JsonObject;", "name", "processVars", "", "getValueAsString", "value", "Lcom/intellij/json/psi/JsonLiteral;", "fillVariables", "messageBody", "variables", "", "", "obj", "getVariableKey", "variableRange", "Lcom/intellij/openapi/util/TextRange;", "collectVariablesRangesInMessageBody", "body", "core"})
public final class ShireEnvVariableFiller {
    @NotNull
    public static final ShireEnvVariableFiller INSTANCE = new ShireEnvVariableFiller();

    private ShireEnvVariableFiller() {
    }

    private final String getVariableValue(JsonObject jsonObject, String name, Map<String, String> processVars) {
        JsonLiteral value = (JsonLiteral)JsonUtil.getPropertyValueOfType((JsonObject)jsonObject, (String)name, JsonLiteral.class);
        String jsonResult = this.getValueAsString(value);
        if (jsonResult != null) {
            return jsonResult;
        }
        return processVars.get(name);
    }

    private final String getValueAsString(JsonLiteral value) {
        String string;
        JsonLiteral jsonLiteral = value;
        if (jsonLiteral instanceof JsonStringLiteral) {
            string = ((JsonStringLiteral)value).getValue();
        } else if (jsonLiteral instanceof JsonBooleanLiteral) {
            string = String.valueOf(((JsonBooleanLiteral)value).getValue());
        } else {
            JsonLiteral jsonLiteral2 = value;
            string = jsonLiteral2 != null ? jsonLiteral2.getText() : null;
        }
        return string;
    }

    @NotNull
    public final String fillVariables(@NotNull String messageBody, @NotNull List<? extends Set<String>> variables, @Nullable JsonObject obj, @NotNull Map<String, String> processVars) {
        Intrinsics.checkNotNullParameter((Object)messageBody, (String)"messageBody");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter(processVars, (String)"processVars");
        if (obj == null) {
            return messageBody;
        }
        if (variables.isEmpty()) {
            return messageBody;
        }
        List<TextRange> envRanges = this.collectVariablesRangesInMessageBody(messageBody);
        StringBuilder result = new StringBuilder(messageBody.length());
        int lastVariableRangeEndOffset = 0;
        for (TextRange variableRange : envRanges) {
            result.append(messageBody, lastVariableRangeEndOffset, variableRange.getStartOffset());
            String variableValue = this.getVariableValue(obj, this.getVariableKey(variableRange, messageBody), processVars);
            result.append(variableValue);
            lastVariableRangeEndOffset = variableRange.getEndOffset();
        }
        result.append(messageBody, lastVariableRangeEndOffset, messageBody.length());
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String sb = string;
        return sb;
    }

    private final String getVariableKey(TextRange variableRange, String messageBody) {
        String string = variableRange.substring(messageBody);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"${"), (CharSequence)"}");
    }

    private final List<TextRange> collectVariablesRangesInMessageBody(String body) {
        List ranges = new ArrayList();
        int startIndex = 0;
        while (startIndex < body.length()) {
            String contentInsideBraces;
            int openBraceIndex = StringsKt.indexOf$default((CharSequence)body, (String)"${", (int)startIndex, (boolean)false, (int)4, null);
            int closeBraceIndex = StringsKt.indexOf$default((CharSequence)body, (String)"}", (int)openBraceIndex, (boolean)false, (int)4, null);
            if (openBraceIndex == -1 || closeBraceIndex == -1) break;
            TextRange range = new TextRange(openBraceIndex, closeBraceIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)body.substring(openBraceIndex + 2, closeBraceIndex), (String)"substring(...)");
            if (!StringsKt.isBlank((CharSequence)contentInsideBraces)) {
                ranges.add(range);
            }
            startIndex = closeBraceIndex + 1;
        }
        return ranges;
    }
}

