/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.diff;

import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.AutoDevColors;
import cc.unitmesh.devti.diff.EditorComponentInlaysManager;
import cc.unitmesh.devti.diff.VerticalDiffBlockKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextArea;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010'\u001a\u00020\u000bJ\u000e\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u0007J\u000e\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0007J\u0016\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0007J\u0006\u0010.\u001a\u00020\u000bJ\u0006\u0010/\u001a\u00020\u000bJ\b\u00100\u001a\u00020\u000bH\u0002J\b\u00101\u001a\u00020\u000bH\u0002J\b\u00102\u001a\u00020\u000bH\u0002J\u0014\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c04H\u0002J\b\u00105\u001a\u00020\u000bH\u0002J\b\u00106\u001a\u00020\u000bH\u0002J\b\u00107\u001a\u00020\u000bH\u0002J\b\u00108\u001a\u00020\u000bH\u0002J\u0010\u00109\u001a\u00020!2\u0006\u0010-\u001a\u00020\u0016H\u0002J\u0014\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000704H\u0002J\u0018\u0010;\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010<\u001a\u00020=H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcc/unitmesh/devti/diff/VerticalDiffBlock;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "startLine", "", "onAcceptReject", "Lkotlin/Function2;", "", "", "acceptAll", "Lkotlin/Function0;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;ILkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;)V", "getStartLine", "()I", "setStartLine", "(I)V", "deletedLines", "", "", "getDeletedLines", "()Ljava/util/List;", "addedLines", "getAddedLines", "acceptButton", "Ljavax/swing/JButton;", "rejectButton", "deletionInlay", "Lcom/intellij/openapi/Disposable;", "textArea", "Ljavax/swing/JTextArea;", "hasRenderedDiffBlock", "editorComponentInlaysManager", "Lcc/unitmesh/devti/diff/EditorComponentInlaysManager;", "greenKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "clearEditorUI", "updatePosition", "newLineNumber", "deleteLineAt", "line", "addNewLine", "text", "onLastDiffLine", "handleReject", "refreshEditor", "renderDeletedLinesInlay", "renderButtons", "createButtons", "Lkotlin/Pair;", "removeButtons", "handleAccept", "revertDiff", "removeGreenHighlighters", "createDeletionTextArea", "getButtonsXYPositions", "createButton", "backgroundColor", "Lcom/intellij/ui/JBColor;", "core"})
@SourceDebugExtension(value={"SMAP\nVerticalDiffBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerticalDiffBlock.kt\ncc/unitmesh/devti/diff/VerticalDiffBlock\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n3792#2:288\n4307#2,2:289\n1855#3,2:291\n*S KotlinDebug\n*F\n+ 1 VerticalDiffBlock.kt\ncc/unitmesh/devti/diff/VerticalDiffBlock\n*L\n225#1:288\n225#1:289,2\n230#1:291,2\n*E\n"})
public final class VerticalDiffBlock {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    private int startLine;
    @NotNull
    private final Function2<VerticalDiffBlock, Boolean, Unit> onAcceptReject;
    @NotNull
    private final Function0<Unit> acceptAll;
    @NotNull
    private final List<String> deletedLines;
    @NotNull
    private final List<String> addedLines;
    @NotNull
    private final JButton acceptButton;
    @NotNull
    private final JButton rejectButton;
    @Nullable
    private Disposable deletionInlay;
    @Nullable
    private JTextArea textArea;
    private boolean hasRenderedDiffBlock;
    @NotNull
    private final EditorComponentInlaysManager editorComponentInlaysManager;
    @NotNull
    private final TextAttributesKey greenKey;

    public VerticalDiffBlock(@NotNull Editor editor, @NotNull Project project, int startLine, @NotNull Function2<? super VerticalDiffBlock, ? super Boolean, Unit> onAcceptReject, @NotNull Function0<Unit> acceptAll) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onAcceptReject, (String)"onAcceptReject");
        Intrinsics.checkNotNullParameter(acceptAll, (String)"acceptAll");
        this.editor = editor;
        this.project = project;
        this.startLine = startLine;
        this.onAcceptReject = onAcceptReject;
        this.acceptAll = acceptAll;
        this.deletedLines = new ArrayList();
        this.addedLines = new ArrayList();
        this.editorComponentInlaysManager = EditorComponentInlaysManager.Companion.from(this.editor, false);
        this.greenKey = VerticalDiffBlockKt.createTextAttributesKey("CONTINUE_DIFF_NEW_LINE", AutoDevColors.INSTANCE.getDIFF_NEW_LINE_COLOR(), this.editor);
        Pair<JButton, JButton> pair = this.createButtons();
        JButton acceptBtn = (JButton)pair.component1();
        JButton rejectBtn = (JButton)pair.component2();
        this.acceptButton = acceptBtn;
        this.rejectButton = rejectBtn;
    }

    public final int getStartLine() {
        return this.startLine;
    }

    public final void setStartLine(int n) {
        this.startLine = n;
    }

    @NotNull
    public final List<String> getDeletedLines() {
        return this.deletedLines;
    }

    @NotNull
    public final List<String> getAddedLines() {
        return this.addedLines;
    }

    public final void clearEditorUI() {
        Disposable disposable = this.deletionInlay;
        if (disposable != null) {
            disposable.dispose();
        }
        this.removeGreenHighlighters();
        this.removeButtons();
    }

    public final void updatePosition(int newLineNumber) {
        this.startLine = newLineNumber;
        Pair<Integer, Integer> pair = this.getButtonsXYPositions();
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        this.rejectButton.setLocation(new Point(x, y));
        this.acceptButton.setLocation(new Point(x + this.rejectButton.getPreferredSize().width + 5, y));
        this.refreshEditor();
    }

    public final void deleteLineAt(int line) {
        int startOffset = this.editor.getDocument().getLineStartOffset(line);
        int endOffset = Math.min(this.editor.getDocument().getLineEndOffset(line) + 1, this.editor.getDocument().getTextLength());
        String string = this.editor.getDocument().getText(new TextRange(startOffset, endOffset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String deletedText = string;
        this.deletedLines.add(((Object)StringsKt.trimEnd((CharSequence)deletedText)).toString());
        this.editor.getDocument().deleteString(startOffset, Math.min(endOffset, this.editor.getDocument().getTextLength()));
    }

    public final void addNewLine(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (line == this.editor.getDocument().getLineCount()) {
            this.editor.getDocument().insertString(this.editor.getDocument().getTextLength(), (CharSequence)"\n");
        }
        int offset = this.editor.getDocument().getLineStartOffset(line);
        this.editor.getDocument().insertString(offset, (CharSequence)(text + "\n"));
        this.editor.getMarkupModel().addLineHighlighter(this.greenKey, line, 6000);
        this.addedLines.add(text);
    }

    public final void onLastDiffLine() {
        if (this.hasRenderedDiffBlock) {
            return;
        }
        if (!((Collection)this.deletedLines).isEmpty()) {
            this.renderDeletedLinesInlay();
        }
        this.renderButtons();
        this.hasRenderedDiffBlock = true;
    }

    public final void handleReject() {
        this.revertDiff();
        this.clearEditorUI();
    }

    private final void refreshEditor() {
        this.editor.getContentComponent().revalidate();
        this.editor.getContentComponent().repaint();
    }

    private final void renderDeletedLinesInlay() {
        Disposable disposable;
        JTextArea textArea;
        this.textArea = textArea = this.createDeletionTextArea(CollectionsKt.joinToString$default((Iterable)this.deletedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        this.deletionInlay = disposable = this.editorComponentInlaysManager.insert(this.startLine, textArea, true);
    }

    private final void renderButtons() {
        Pair<Integer, Integer> pair = this.getButtonsXYPositions();
        int x = ((Number)pair.component1()).intValue();
        int y = ((Number)pair.component2()).intValue();
        this.rejectButton.setBounds(x, y, this.rejectButton.getPreferredSize().width, this.rejectButton.getPreferredSize().height);
        this.acceptButton.setBounds(x + this.rejectButton.getWidth() + 2, y, this.acceptButton.getPreferredSize().width, this.acceptButton.getPreferredSize().height);
        this.editor.getContentComponent().add(this.acceptButton);
        this.editor.getContentComponent().add(this.rejectButton);
        this.editor.getContentComponent().setComponentZOrder(this.acceptButton, 0);
        this.editor.getContentComponent().setComponentZOrder(this.rejectButton, 0);
        this.refreshEditor();
    }

    private final Pair<JButton, JButton> createButtons() {
        JButton jButton;
        JButton jButton2;
        JButton $this$createButtons_u24lambda_u241 = jButton2 = this.createButton(AutoDevBundle.message("sketch.patch.action.reject", new Object[0]), AutoDevColors.INSTANCE.getREJECT_BUTTON_COLOR());
        boolean bl = false;
        $this$createButtons_u24lambda_u241.addActionListener(arg_0 -> VerticalDiffBlock.createButtons$lambda$1$lambda$0(this, arg_0));
        JButton rejectBtn = jButton2;
        JButton $this$createButtons_u24lambda_u243 = jButton = this.createButton(AutoDevBundle.message("sketch.patch.action.accept", new Object[0]), AutoDevColors.INSTANCE.getACCEPT_BUTTON_COLOR());
        boolean bl2 = false;
        $this$createButtons_u24lambda_u243.addActionListener(arg_0 -> VerticalDiffBlock.createButtons$lambda$3$lambda$2(this, arg_0));
        JButton acceptBtn = jButton;
        return new Pair((Object)acceptBtn, (Object)rejectBtn);
    }

    private final void removeButtons() {
        this.editor.getContentComponent().remove(this.acceptButton);
        this.editor.getContentComponent().remove(this.rejectButton);
        this.refreshEditor();
    }

    private final void handleAccept() {
        this.acceptAll.invoke();
    }

    private final void revertDiff() {
        WriteCommandAction.runWriteCommandAction((Project)this.project, () -> VerticalDiffBlock.revertDiff$lambda$4(this));
    }

    /*
     * WARNING - void declaration
     */
    private final void removeGreenHighlighters() {
        void $this$filterTo$iv$iv;
        RangeHighlighter[] rangeHighlighterArray = this.editor.getMarkupModel().getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] $this$filter$iv = rangeHighlighterArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            RangeHighlighter highlighter = (RangeHighlighter)element$iv$iv;
            boolean bl = false;
            int highlighterLine = this.editor.getDocument().getLineNumber(highlighter.getStartOffset());
            int n = this.startLine;
            boolean bl2 = highlighterLine < this.startLine + this.addedLines.size() ? n <= highlighterLine : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List highlightersToRemove = (List)destination$iv$iv;
        Iterable $this$forEach$iv = highlightersToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            this.editor.getMarkupModel().removeHighlighter(it);
        }
    }

    private final JTextArea createDeletionTextArea(String text) {
        JTextArea jTextArea;
        JTextArea $this$createDeletionTextArea_u24lambda_u247 = jTextArea = new JTextArea(text);
        boolean bl = false;
        $this$createDeletionTextArea_u24lambda_u247.setEditable(false);
        $this$createDeletionTextArea_u24lambda_u247.setBackground((Color)AutoDevColors.INSTANCE.getDELETION_INLAY_COLOR());
        $this$createDeletionTextArea_u24lambda_u247.setForeground((Color)JBColor.GRAY);
        $this$createDeletionTextArea_u24lambda_u247.setBorder(BorderFactory.createEmptyBorder());
        $this$createDeletionTextArea_u24lambda_u247.setLineWrap(false);
        $this$createDeletionTextArea_u24lambda_u247.setWrapStyleWord(false);
        $this$createDeletionTextArea_u24lambda_u247.setFont(this.editor.getColorsScheme().getFont(EditorFontType.PLAIN));
        return jTextArea;
    }

    private final Pair<Integer, Integer> getButtonsXYPositions() {
        Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        JTextArea jTextArea = this.textArea;
        int textAreaHeight = jTextArea != null ? jTextArea.getHeight() : 0;
        Point point = this.editor.logicalPositionToXY(new LogicalPosition(this.startLine, 0));
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"logicalPositionToXY(...)");
        Point lineStartPosition = point;
        int xPosition = visibleArea.x + visibleArea.width - this.acceptButton.getPreferredSize().width - this.rejectButton.getPreferredSize().width - 20;
        int yPosition = lineStartPosition.y - textAreaHeight;
        return new Pair((Object)xPosition, (Object)yPosition);
    }

    private final JButton createButton(String text, JBColor backgroundColor) {
        JButton jButton;
        JButton $this$createButton_u24lambda_u248 = jButton = new JButton(text, backgroundColor){
            final /* synthetic */ JBColor $backgroundColor;
            {
                this.$backgroundColor = $backgroundColor;
                super($text);
            }

            protected void paintComponent(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2 = (Graphics2D)graphics;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor((Color)this.$backgroundColor);
                g2.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 4, 4);
                super.paintComponent(g2);
                g2.dispose();
            }
        };
        boolean bl = false;
        $this$createButton_u24lambda_u248.setForeground((Color)Gray._240);
        $this$createButton_u24lambda_u248.setFont(new Font("Arial", 1, 12));
        $this$createButton_u24lambda_u248.setContentAreaFilled(false);
        $this$createButton_u24lambda_u248.setOpaque(false);
        $this$createButton_u24lambda_u248.setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        $this$createButton_u24lambda_u248.setPreferredSize(new Dimension($this$createButton_u24lambda_u248.getPreferredSize().width - 30, 14));
        $this$createButton_u24lambda_u248.setCursor(new Cursor(12));
        return jButton;
    }

    private static final void createButtons$lambda$1$lambda$0(VerticalDiffBlock this$0, ActionEvent it) {
        this$0.handleReject();
        this$0.onAcceptReject.invoke((Object)this$0, (Object)false);
    }

    private static final void createButtons$lambda$3$lambda$2(VerticalDiffBlock this$0, ActionEvent it) {
        this$0.handleAccept();
        this$0.onAcceptReject.invoke((Object)this$0, (Object)true);
    }

    private static final void revertDiff$lambda$4(VerticalDiffBlock this$0) {
        int lineCount = this$0.editor.getDocument().getLineCount();
        int textLength = this$0.editor.getDocument().getTextLength();
        int startOffset = this$0.startLine >= lineCount ? textLength : this$0.editor.getDocument().getLineStartOffset(this$0.startLine);
        int endOffset = this$0.editor.getDocument().getLineEndOffset(Math.min(lineCount - 1, this$0.startLine + this$0.addedLines.size() - 1)) + 1;
        this$0.editor.getDocument().deleteString(startOffset, Math.min(endOffset, textLength));
        if (!((Collection)this$0.deletedLines).isEmpty()) {
            this$0.editor.getDocument().insertString(startOffset, (CharSequence)(CollectionsKt.joinToString$default((Iterable)this$0.deletedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n"));
        }
    }
}

