/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.custom.tasks;

import cc.unitmesh.cf.core.llms.LlmMsg;
import cc.unitmesh.cf.core.parser.MarkdownCode;
import cc.unitmesh.devti.AutoDevBundle;
import cc.unitmesh.devti.custom.tasks.FileGenerateTask;
import cc.unitmesh.devti.llms.LLMProvider;
import cc.unitmesh.devti.llms.LlmFactory;
import cc.unitmesh.devti.util.AutoDevCoroutineScope;
import cc.unitmesh.devti.util.parser.CodeFence;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0016H\u0004R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcc/unitmesh/devti/custom/tasks/FileGenerateTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "messages", "", "Lcc/unitmesh/cf/core/llms/LlmMsg$ChatMessage;", "fileName", "", "codeOnly", "", "taskName", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;ZLjava/lang/String;)V", "getMessages", "()Ljava/util/List;", "getFileName", "()Ljava/lang/String;", "getCodeOnly", "()Z", "getTaskName", "projectRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "refreshAndOpenInEditor", "file", "Ljava/nio/file/Path;", "parentDir", "core"})
@SourceDebugExtension(value={"SMAP\nFileGenerateTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileGenerateTask.kt\ncc/unitmesh/devti/custom/tasks/FileGenerateTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n766#2:97\n857#2,2:98\n766#2:100\n857#2,2:101\n*S KotlinDebug\n*F\n+ 1 FileGenerateTask.kt\ncc/unitmesh/devti/custom/tasks/FileGenerateTask\n*L\n36#1:97\n36#1:98,2\n37#1:100\n37#1:101,2\n*E\n"})
public final class FileGenerateTask
extends Task.Backgroundable {
    @JvmField
    @NotNull
    public final Project project;
    @NotNull
    private final List<LlmMsg.ChatMessage> messages;
    @Nullable
    private final String fileName;
    private final boolean codeOnly;
    @NotNull
    private final String taskName;
    @NotNull
    private final VirtualFile projectRoot;

    public FileGenerateTask(@NotNull Project project, @NotNull List<LlmMsg.ChatMessage> messages, @Nullable String fileName, boolean codeOnly, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        super(project, taskName);
        this.project = project;
        this.messages = messages;
        this.fileName = fileName;
        this.codeOnly = codeOnly;
        this.taskName = taskName;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        Intrinsics.checkNotNull((Object)virtualFile);
        this.projectRoot = virtualFile;
    }

    public /* synthetic */ FileGenerateTask(Project project, List list, String string, boolean bl, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string2 = AutoDevBundle.message("intentions.request.background.process.title", new Object[0]);
        }
        this(project, list, string, bl, string2);
    }

    @NotNull
    public final List<LlmMsg.ChatMessage> getMessages() {
        return this.messages;
    }

    @Nullable
    public final String getFileName() {
        return this.fileName;
    }

    public final boolean getCodeOnly() {
        return this.codeOnly;
    }

    @NotNull
    public final String getTaskName() {
        return this.taskName;
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull ProgressIndicator indicator) {
        Object object;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Iterable $this$filter$iv = this.messages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            LlmMsg.ChatMessage it = (LlmMsg.ChatMessage)element$iv$iv;
            boolean bl = false;
            if (!(it.getRole() == LlmMsg.ChatRole.User)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String requestPrompt2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, FileGenerateTask::run$lambda$1, (int)30, null);
        Iterable $this$filter$iv2 = this.messages;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LlmMsg.ChatMessage it = (LlmMsg.ChatMessage)element$iv$iv;
            boolean bl = false;
            if (!(it.getRole() == LlmMsg.ChatRole.System)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        String systemPrompt = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, FileGenerateTask::run$lambda$3, (int)30, null);
        Flow stream2 = LLMProvider.DefaultImpls.stream$default(LlmFactory.INSTANCE.create(this.project), requestPrompt2, systemPrompt, false, false, 8, null);
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = "";
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Flow<String>)stream2, (Ref.ObjectRef<String>)result, null){
            int label;
            final /* synthetic */ Flow<String> $stream;
            final /* synthetic */ Ref.ObjectRef<String> $result;
            {
                this.$stream = $stream;
                this.$result = $result;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.cancellable(this.$stream).collect(new FlowCollector(this.$result){
                            final /* synthetic */ Ref.ObjectRef<String> $result;
                            {
                                this.$result = $result;
                            }

                            public final Object emit(String it, Continuation<? super Unit> $completion) {
                                this.$result.element = this.$result.element + it;
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (this.fileName == null) {
            String language = MarkdownCode.Companion.parse((String)result.element).getLanguage();
            long timestamp = System.currentTimeMillis();
            object = "output-" + timestamp + (String)(((CharSequence)language).length() == 0 ? ".txt" : "." + language);
        } else {
            object = this.fileName;
        }
        String inferFileName = object;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        Intrinsics.checkNotNull((Object)virtualFile);
        File file = virtualFile.toNioPath().resolve(inferFileName).toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        if (this.codeOnly) {
            String code = CodeFence.Companion.parse((String)result.element).getText();
            Intrinsics.checkNotNull((Object)file);
            FilesKt.writeText$default((File)file, (String)code, null, (int)2, null);
            Path path = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            this.refreshAndOpenInEditor(path, this.projectRoot);
            return;
        }
        Intrinsics.checkNotNull((Object)file);
        FilesKt.writeText$default((File)file, (String)((String)result.element), null, (int)2, null);
        String string = this.projectRoot.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        this.refreshAndOpenInEditor(path, this.projectRoot);
    }

    protected final void refreshAndOpenInEditor(@NotNull Path file, @NotNull VirtualFile parentDir) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)parentDir, (String)"parentDir");
        BuildersKt.launch$default((CoroutineScope)AutoDevCoroutineScope.Companion.scope(this.project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, parentDir, null){
            int label;
            final /* synthetic */ FileGenerateTask this$0;
            final /* synthetic */ Path $file;
            final /* synthetic */ VirtualFile $parentDir;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$parentDir = $parentDir;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Project project = this.this$0.project;
                        ProgressManager.getInstance().run((Task)new Task.Modal(this.$file, this.$parentDir, project){
                            final /* synthetic */ Path $file;
                            final /* synthetic */ VirtualFile $parentDir;
                            {
                                this.$file = $file;
                                this.$parentDir = $parentDir;
                                super($super_call_param$1, "Refreshing Project Model", true);
                            }

                            public void run(ProgressIndicator indicator) {
                                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                                int n = 5;
                                Path path = this.$file;
                                VirtualFile virtualFile = this.$parentDir;
                                for (int i = 0; i < n; ++i) {
                                    int it = i;
                                    boolean bl = false;
                                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByNioFile(path);
                                    if (virtualFile2 == null) {
                                        VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile};
                                        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
                                        continue;
                                    }
                                    try {
                                        ActionsKt.runInEdt$default(null, () -> refreshAndOpenInEditor.1.run$lambda$1$lambda$0(this, virtualFile2), (int)1, null);
                                        return;
                                    }
                                    catch (Exception exception) {
                                    }
                                }
                            }

                            private static final Unit run$lambda$1$lambda$0(refreshAndOpenInEditor.1 this$0, VirtualFile $virtualFile) {
                                FileEditorManager.getInstance((Project)this$0.getProject()).openFile($virtualFile, true);
                                return Unit.INSTANCE;
                            }
                        });
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final CharSequence run$lambda$1(LlmMsg.ChatMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContent();
    }

    private static final CharSequence run$lambda$3(LlmMsg.ChatMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getContent();
    }
}

