/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.command.dataprovider;

import cc.unitmesh.devti.command.dataprovider.SkillFrontmatter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.velocity.VelocityContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0005J\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0001H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0016\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0001J\u001a\u0010\u001b\u001a\u00020\u00172\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcc/unitmesh/devti/command/dataprovider/SpecKitTemplateCompiler;", "", "project", "Lcom/intellij/openapi/project/Project;", "template", "", "arguments", "input", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getInput", "()Ljava/lang/String;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "velocityContext", "Lorg/apache/velocity/VelocityContext;", "compile", "resolveVariable", "key", "value", "loadFileContent", "filePath", "addProjectVariables", "", "templateCompile", "content", "putVariable", "putAllVariables", "variables", "", "core"})
@SourceDebugExtension(value={"SMAP\nSpecKitTemplateCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecKitTemplateCompiler.kt\ncc/unitmesh/devti/command/dataprovider/SpecKitTemplateCompiler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,124:1\n11#2:125\n215#3,2:126\n215#3,2:130\n13309#4,2:128\n*S KotlinDebug\n*F\n+ 1 SpecKitTemplateCompiler.kt\ncc/unitmesh/devti/command/dataprovider/SpecKitTemplateCompiler\n*L\n30#1:125\n39#1:126,2\n118#1:130,2\n103#1:128,2\n*E\n"})
public final class SpecKitTemplateCompiler {
    @NotNull
    private final Project project;
    @NotNull
    private final String template;
    @NotNull
    private final String arguments;
    @NotNull
    private final String input;
    @NotNull
    private final Logger logger;
    @NotNull
    private final VelocityContext velocityContext;

    public SpecKitTemplateCompiler(@NotNull Project project, @NotNull String template, @NotNull String arguments, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.project = project;
        this.template = template;
        this.arguments = arguments;
        this.input = input;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SpecKitTemplateCompiler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.velocityContext = new VelocityContext();
    }

    @NotNull
    public final String getInput() {
        return this.input;
    }

    @NotNull
    public final String compile() {
        Pair<SkillFrontmatter, String> pair = SkillFrontmatter.Companion.parse(this.template);
        SkillFrontmatter frontmatter = (SkillFrontmatter)pair.component1();
        String content = (String)pair.component2();
        this.velocityContext.put("ARGUMENTS", (Object)(this.arguments + " " + this.input));
        Object object = frontmatter;
        if (object != null && (object = ((SkillFrontmatter)object).getVariables()) != null) {
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Object resolvedValue = this.resolveVariable(key, value);
                this.velocityContext.put(key, resolvedValue);
            }
        }
        this.addProjectVariables();
        return this.templateCompile(content);
    }

    private final Object resolveVariable(String key, Object value) {
        String valueStr = value.toString();
        if (StringsKt.contains$default((CharSequence)valueStr, (CharSequence)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)valueStr, (String)".md", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)valueStr, (String)".txt", (boolean)false, (int)2, null)) {
            String string = this.loadFileContent(valueStr);
            if (string == null) {
                string = valueStr;
            }
            return string;
        }
        return value;
    }

    private final String loadFileContent(String filePath) {
        try {
            Object path;
            String string = this.project.getBasePath();
            if (string == null) {
                return null;
            }
            String projectPath = string;
            String[] stringArray = path = Path.of(filePath, new String[0]);
            Intrinsics.checkNotNull((Object)stringArray);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists((Path)stringArray, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                stringArray = new String[]{filePath};
                path = Path.of(projectPath, stringArray);
            }
            stringArray = path;
            Intrinsics.checkNotNull((Object)stringArray);
            linkOptionArray = new LinkOption[]{};
            if (!Files.exists((Path)stringArray, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                this.logger.warn("File not found: " + filePath);
                return null;
            }
            stringArray = path;
            Intrinsics.checkNotNull((Object)stringArray);
            return PathsKt.readText$default((Path)stringArray, null, (int)1, null);
        }
        catch (Exception e) {
            this.logger.warn("Failed to load file: " + filePath, (Throwable)e);
            return null;
        }
    }

    private final void addProjectVariables() {
        block0: {
            String string = this.project.getBasePath();
            if (string == null) break block0;
            String basePath = string;
            boolean bl = false;
            this.velocityContext.put("PROJECT_PATH", (Object)basePath);
            this.velocityContext.put("PROJECT_NAME", (Object)this.project.getName());
        }
    }

    private final String templateCompile(String content) {
        String result = null;
        result = content;
        String[] stringArray = this.velocityContext.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getKeys(...)");
        Object[] $this$forEach$iv = stringArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            Object value = this.velocityContext.get(key.toString());
            if (value == null) continue;
            result = StringsKt.replace$default((String)result, (String)("$" + key), (String)value.toString(), (boolean)false, (int)4, null);
        }
        return ((Object)StringsKt.trim((CharSequence)result)).toString();
    }

    public final void putVariable(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.velocityContext.put(key, value);
    }

    public final void putAllVariables(@NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Map<String, ? extends Object> $this$forEach$iv = variables;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            this.velocityContext.put(key, value);
        }
    }
}

