/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.command.dataprovider;

import cc.unitmesh.devti.AutoDevIcons;
import cc.unitmesh.devti.command.dataprovider.CustomCommand;
import cc.unitmesh.devti.command.dataprovider.SkillFrontmatter;
import cc.unitmesh.devti.command.dataprovider.SpecKitTemplateCompiler;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u001cJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J;\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\r\u00a8\u0006*"}, d2={"Lcc/unitmesh/devti/command/dataprovider/ClaudeSkillCommand;", "", "skillName", "", "description", "template", "skillPath", "Ljava/nio/file/Path;", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;Ljavax/swing/Icon;)V", "getSkillName", "()Ljava/lang/String;", "getDescription", "getTemplate", "getSkillPath", "()Ljava/nio/file/Path;", "getIcon", "()Ljavax/swing/Icon;", "fullCommandName", "getFullCommandName", "executeWithCompiler", "project", "Lcom/intellij/openapi/project/Project;", "arguments", "input", "toCustomCommand", "Lcc/unitmesh/devti/command/dataprovider/CustomCommand;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "core"})
public final class ClaudeSkillCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String skillName;
    @NotNull
    private final String description;
    @NotNull
    private final String template;
    @NotNull
    private final Path skillPath;
    @NotNull
    private final Icon icon;
    @NotNull
    private static final String SKILL_FILE = "SKILL.md";
    @NotNull
    private static final String USER_SKILLS_DIR = ".claude/skills";

    public ClaudeSkillCommand(@NotNull String skillName, @NotNull String description, @NotNull String template, @NotNull Path skillPath, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)skillName, (String)"skillName");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)skillPath, (String)"skillPath");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.skillName = skillName;
        this.description = description;
        this.template = template;
        this.skillPath = skillPath;
        this.icon = icon;
    }

    public /* synthetic */ ClaudeSkillCommand(String string, String string2, String string3, Path path, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            icon = AutoDevIcons.IDEA;
        }
        this(string, string2, string3, path, icon);
    }

    @NotNull
    public final String getSkillName() {
        return this.skillName;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getTemplate() {
        return this.template;
    }

    @NotNull
    public final Path getSkillPath() {
        return this.skillPath;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public final String getFullCommandName() {
        return "skill." + this.skillName;
    }

    @NotNull
    public final String executeWithCompiler(@NotNull Project project, @NotNull String arguments, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        SpecKitTemplateCompiler compiler = new SpecKitTemplateCompiler(project, this.template, arguments, input);
        return compiler.compile();
    }

    @NotNull
    public final CustomCommand toCustomCommand() {
        return new CustomCommand(this.getFullCommandName(), this.description, this.icon);
    }

    @NotNull
    public final String component1() {
        return this.skillName;
    }

    @NotNull
    public final String component2() {
        return this.description;
    }

    @NotNull
    public final String component3() {
        return this.template;
    }

    @NotNull
    public final Path component4() {
        return this.skillPath;
    }

    @NotNull
    public final Icon component5() {
        return this.icon;
    }

    @NotNull
    public final ClaudeSkillCommand copy(@NotNull String skillName, @NotNull String description, @NotNull String template, @NotNull Path skillPath, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)skillName, (String)"skillName");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)skillPath, (String)"skillPath");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return new ClaudeSkillCommand(skillName, description, template, skillPath, icon);
    }

    public static /* synthetic */ ClaudeSkillCommand copy$default(ClaudeSkillCommand claudeSkillCommand, String string, String string2, String string3, Path path, Icon icon, int n, Object object) {
        if ((n & 1) != 0) {
            string = claudeSkillCommand.skillName;
        }
        if ((n & 2) != 0) {
            string2 = claudeSkillCommand.description;
        }
        if ((n & 4) != 0) {
            string3 = claudeSkillCommand.template;
        }
        if ((n & 8) != 0) {
            path = claudeSkillCommand.skillPath;
        }
        if ((n & 0x10) != 0) {
            icon = claudeSkillCommand.icon;
        }
        return claudeSkillCommand.copy(string, string2, string3, path, icon);
    }

    @NotNull
    public String toString() {
        return "ClaudeSkillCommand(skillName=" + this.skillName + ", description=" + this.description + ", template=" + this.template + ", skillPath=" + this.skillPath + ", icon=" + this.icon + ")";
    }

    public int hashCode() {
        int result = this.skillName.hashCode();
        result = result * 31 + this.description.hashCode();
        result = result * 31 + this.template.hashCode();
        result = result * 31 + ((Object)this.skillPath).hashCode();
        result = result * 31 + this.icon.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClaudeSkillCommand)) {
            return false;
        }
        ClaudeSkillCommand claudeSkillCommand = (ClaudeSkillCommand)other;
        if (!Intrinsics.areEqual((Object)this.skillName, (Object)claudeSkillCommand.skillName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)claudeSkillCommand.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.template, (Object)claudeSkillCommand.template)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.skillPath, (Object)claudeSkillCommand.skillPath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.icon, (Object)claudeSkillCommand.icon);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcc/unitmesh/devti/command/dataprovider/ClaudeSkillCommand$Companion;", "", "<init>", "()V", "SKILL_FILE", "", "USER_SKILLS_DIR", "all", "", "Lcc/unitmesh/devti/command/dataprovider/ClaudeSkillCommand;", "project", "Lcom/intellij/openapi/project/Project;", "loadFromProjectRoot", "loadFromUserSkillsDir", "loadSkillFromFile", "skillFile", "Ljava/nio/file/Path;", "skillDir", "fromSkillName", "skillName", "fromFullName", "commandName", "isAvailable", "", "core"})
    @SourceDebugExtension(value={"SMAP\nClaudeSkillCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaudeSkillCommand.kt\ncc/unitmesh/devti/command/dataprovider/ClaudeSkillCommand$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n766#2:187\n857#2,2:188\n1603#2,9:190\n1855#2:199\n1856#2:201\n1612#2:202\n766#2:203\n857#2,2:204\n1603#2,9:206\n1855#2:215\n1856#2:217\n1612#2:218\n1#3:200\n1#3:216\n1#3:219\n*S KotlinDebug\n*F\n+ 1 ClaudeSkillCommand.kt\ncc/unitmesh/devti/command/dataprovider/ClaudeSkillCommand$Companion\n*L\n95#1:187\n95#1:188,2\n96#1:190,9\n96#1:199\n96#1:201\n96#1:202\n122#1:203\n122#1:204,2\n123#1:206,9\n123#1:215\n123#1:217\n123#1:218\n96#1:200\n123#1:216\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<ClaudeSkillCommand> all(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List skills = new ArrayList();
            skills.addAll((Collection)this.loadFromProjectRoot(project));
            skills.addAll((Collection)this.loadFromUserSkillsDir());
            return skills;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ClaudeSkillCommand> loadFromProjectRoot(Project project) {
            Iterable iterable;
            String string = project.getBasePath();
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String projectPath = string;
            Path projectRoot = Path.of(projectPath, new String[0]);
            Intrinsics.checkNotNull((Object)projectRoot);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(projectRoot, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return CollectionsKt.emptyList();
            }
            try {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                iterable = PathsKt.listDirectoryEntries$default((Path)projectRoot, null, (int)1, null);
                boolean $i$f$filter = false;
                void var6_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Path it = (Path)element$iv$iv;
                    boolean bl = false;
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ClaudeSkillCommand it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Path dir = (Path)element$iv$iv;
                    boolean bl2 = false;
                    Path skillFile = dir.resolve(ClaudeSkillCommand.SKILL_FILE);
                    Intrinsics.checkNotNull((Object)skillFile);
                    LinkOption[] linkOptionArray3 = new LinkOption[]{};
                    if ((Files.exists(skillFile, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? Companion.loadSkillFromFile(skillFile, dir) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                iterable = (List)destination$iv$iv;
            }
            catch (Exception e) {
                iterable = CollectionsKt.emptyList();
            }
            return iterable;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ClaudeSkillCommand> loadFromUserSkillsDir() {
            String string = System.getProperty("user.home");
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String userHome = string;
            Object object = new String[]{ClaudeSkillCommand.USER_SKILLS_DIR};
            Path skillsDir = Path.of(userHome, object);
            Intrinsics.checkNotNull((Object)skillsDir);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(skillsDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return CollectionsKt.emptyList();
            }
            try {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)skillsDir, null, (int)1, null);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Path it = (Path)element$iv$iv;
                    boolean bl = false;
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ClaudeSkillCommand it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Path dir = (Path)element$iv$iv;
                    boolean bl2 = false;
                    Path skillFile = dir.resolve(ClaudeSkillCommand.SKILL_FILE);
                    Intrinsics.checkNotNull((Object)skillFile);
                    LinkOption[] linkOptionArray3 = new LinkOption[]{};
                    if ((Files.exists(skillFile, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? Companion.loadSkillFromFile(skillFile, dir) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                object = (List)destination$iv$iv;
            }
            catch (Exception e) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        private final ClaudeSkillCommand loadSkillFromFile(Path skillFile, Path skillDir) {
            ClaudeSkillCommand claudeSkillCommand;
            try {
                Object object;
                Object skillName;
                String template;
                block15: {
                    block14: {
                        CharSequence charSequence;
                        SkillFrontmatter frontmatter;
                        block13: {
                            Object object2;
                            block12: {
                                CharSequence charSequence2;
                                template = PathsKt.readText$default((Path)skillFile, null, (int)1, null);
                                frontmatter = (SkillFrontmatter)SkillFrontmatter.Companion.parse(template).component1();
                                object2 = frontmatter;
                                if (object2 == null || (object2 = ((SkillFrontmatter)object2).getName()) == null) break block12;
                                CharSequence charSequence3 = (CharSequence)object2;
                                if (charSequence3.length() == 0) {
                                    boolean bl = false;
                                    charSequence2 = null;
                                } else {
                                    charSequence2 = charSequence3;
                                }
                                if ((object2 = (String)charSequence2) != null) break block13;
                            }
                            object2 = skillName = ((Object)skillDir.getFileName()).toString();
                        }
                        if ((object = frontmatter) == null || (object = ((SkillFrontmatter)object).getDescription()) == null) break block14;
                        CharSequence charSequence4 = (CharSequence)object;
                        if (charSequence4.length() == 0) {
                            boolean bl = false;
                            charSequence = null;
                        } else {
                            charSequence = charSequence4;
                        }
                        if ((object = (String)charSequence) != null) break block15;
                    }
                    object = "Claude Skill: " + (String)skillName;
                }
                Object description = object;
                claudeSkillCommand = new ClaudeSkillCommand((String)skillName, (String)description, template, skillDir, null, 16, null);
            }
            catch (Exception e) {
                claudeSkillCommand = null;
            }
            return claudeSkillCommand;
        }

        @Nullable
        public final ClaudeSkillCommand fromSkillName(@NotNull Project project, @NotNull String skillName) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)skillName, (String)"skillName");
                Iterable iterable = this.all(project);
                for (Object t : iterable) {
                    ClaudeSkillCommand it = (ClaudeSkillCommand)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSkillName(), (Object)skillName)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final ClaudeSkillCommand fromFullName(@NotNull Project project, @NotNull String commandName) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
                Iterable iterable = this.all(project);
                for (Object t : iterable) {
                    ClaudeSkillCommand it = (ClaudeSkillCommand)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFullCommandName(), (Object)commandName)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public final boolean isAvailable(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return !((Collection)this.all(project)).isEmpty();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

