/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.command;

import cc.unitmesh.devti.command.EditRequest;
import cc.unitmesh.devti.command.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcc/unitmesh/devti/command/EditRequestParser;", "", "<init>", "()V", "parse", "Lcc/unitmesh/devti/command/EditRequest;", "content", "", "parseAsYaml", "parseAsAdvancedFormat", "parseAsLegacyFormat", "extractCodeEditContent", "processEscapeSequences", "validateEditRequest", "", "targetFile", "codeEdit", "core"})
@SourceDebugExtension(value={"SMAP\nEditRequestParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditRequestParser.kt\ncc/unitmesh/devti/command/EditRequestParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
public final class EditRequestParser {
    @Nullable
    public final EditRequest parse(@NotNull String content) {
        EditRequest editRequest;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (StringsKt.isBlank((CharSequence)content)) {
            return null;
        }
        List errors = new ArrayList();
        try {
            editRequest = this.parseAsYaml(content);
            if (editRequest != null) {
                EditRequest it = editRequest;
                boolean bl = false;
                return it;
            }
        }
        catch (ParseException e) {
            errors.add(e);
        }
        try {
            editRequest = this.parseAsAdvancedFormat(content);
            if (editRequest != null) {
                EditRequest it = editRequest;
                boolean bl = false;
                return it;
            }
        }
        catch (ParseException e) {
            errors.add(e);
        }
        try {
            editRequest = this.parseAsLegacyFormat(content);
            if (editRequest != null) {
                EditRequest it = editRequest;
                boolean bl = false;
                return it;
            }
        }
        catch (ParseException e) {
            errors.add(e);
        }
        return null;
    }

    @Nullable
    public final EditRequest parseAsYaml(@NotNull String content) {
        EditRequest editRequest;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            Map map = (Map)yaml.load(content);
            if (map == null) {
                throw new ParseException.YamlParseException("YAML content is null or empty", null, 2, null);
            }
            Map data = map;
            Object v = data.get("target_file");
            String string = v instanceof String ? (String)v : null;
            if (string == null) {
                throw new ParseException.MissingFieldException("target_file", null, 2, null);
            }
            String targetFile = string;
            Object v2 = data.get("instructions");
            String string2 = v2 instanceof String ? (String)v2 : null;
            if (string2 == null) {
                string2 = "";
            }
            String instructions = string2;
            Object v3 = data.get("code_edit");
            String string3 = v3 instanceof String ? (String)v3 : null;
            if (string3 == null) {
                throw new ParseException.MissingFieldException("code_edit", null, 2, null);
            }
            String codeEdit = string3;
            String processedCodeEdit = this.processEscapeSequences(codeEdit);
            this.validateEditRequest(targetFile, processedCodeEdit);
            editRequest = new EditRequest(targetFile, instructions, processedCodeEdit);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException.YamlParseException("Failed to parse YAML: " + e.getMessage(), e);
        }
        return editRequest;
    }

    @Nullable
    public final EditRequest parseAsAdvancedFormat(@NotNull String content) {
        EditRequest editRequest;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            Regex targetFileRegex = new Regex("target_file\\s*:\\s*[\"']?([^\"'\\n]+)[\"']?");
            Regex instructionsRegex = new Regex("instructions\\s*:\\s*[\"']?([^\"'\\n]*?)[\"']?");
            Regex blockScalarPattern = new Regex("code_edit\\s*:\\s*\\|\\s*\\n(.*?)(?=\\n\\S|\\n*$)", RegexOption.DOT_MATCHES_ALL);
            Regex quotedStringPattern = new Regex("code_edit\\s*:\\s*[\"'](.*?)[\"']", RegexOption.DOT_MATCHES_ALL);
            MatchResult matchResult = Regex.find$default((Regex)targetFileRegex, (CharSequence)content, (int)0, (int)2, null);
            if (matchResult == null) {
                throw new ParseException.MissingFieldException("target_file", null, 2, null);
            }
            MatchResult targetFileMatch = matchResult;
            MatchResult instructionsMatch = Regex.find$default((Regex)instructionsRegex, (CharSequence)content, (int)0, (int)2, null);
            MatchResult matchResult2 = Regex.find$default((Regex)blockScalarPattern, (CharSequence)content, (int)0, (int)2, null);
            if (matchResult2 == null && (matchResult2 = Regex.find$default((Regex)quotedStringPattern, (CharSequence)content, (int)0, (int)2, null)) == null) {
                throw new ParseException.MissingFieldException("code_edit", null, 2, null);
            }
            MatchResult codeEditMatch = matchResult2;
            String codeEditContent = blockScalarPattern.matches((CharSequence)codeEditMatch.getValue()) ? ((Object)StringsKt.trimEnd((CharSequence)((String)codeEditMatch.getGroupValues().get(1)))).toString() : this.processEscapeSequences((String)codeEditMatch.getGroupValues().get(1));
            String targetFile = ((Object)StringsKt.trim((CharSequence)((String)targetFileMatch.getGroupValues().get(1)))).toString();
            Object object = instructionsMatch;
            if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                object = "";
            }
            Object instructions = object;
            this.validateEditRequest(targetFile, codeEditContent);
            editRequest = new EditRequest(targetFile, (String)instructions, codeEditContent);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException.RegexParseException("Failed to parse advanced format: " + e.getMessage(), e);
        }
        return editRequest;
    }

    @Nullable
    public final EditRequest parseAsLegacyFormat(@NotNull String content) {
        EditRequest editRequest;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            Regex targetFileRegex = new Regex("target_file[\"\\s]*[:=][\"\\s]*[\"']([^\"']+)[\"']");
            Regex instructionsRegex = new Regex("instructions[\"\\s]*[:=][\"\\s]*[\"']([^\"']*?)[\"']", RegexOption.DOT_MATCHES_ALL);
            MatchResult matchResult = Regex.find$default((Regex)targetFileRegex, (CharSequence)content, (int)0, (int)2, null);
            if (matchResult == null) {
                throw new ParseException.MissingFieldException("target_file", null, 2, null);
            }
            MatchResult targetFileMatch = matchResult;
            MatchResult instructionsMatch = Regex.find$default((Regex)instructionsRegex, (CharSequence)content, (int)0, (int)2, null);
            String string = this.extractCodeEditContent(content);
            if (string == null) {
                throw new ParseException.MissingFieldException("code_edit", null, 2, null);
            }
            String codeEditContent = string;
            String targetFile = (String)targetFileMatch.getGroupValues().get(1);
            Object object = instructionsMatch;
            if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
                object = "";
            }
            Object instructions = object;
            this.validateEditRequest(targetFile, codeEditContent);
            editRequest = new EditRequest(targetFile, (String)instructions, codeEditContent);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException.RegexParseException("Failed to parse legacy format: " + e.getMessage(), e);
        }
        return editRequest;
    }

    private final String extractCodeEditContent(String content) {
        try {
            MatchResult matchResult = Regex.find$default((Regex)new Regex("code_edit[\"\\s]*[:=][\"\\s]*[\"']"), (CharSequence)content, (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult codeEditStart = matchResult;
            int startIndex = codeEditStart.getRange().getLast() + 1;
            if (startIndex >= content.length()) {
                return null;
            }
            char openingQuote = content.charAt(startIndex - 1);
            boolean escapeNext = false;
            for (int index = startIndex; index < content.length(); ++index) {
                char c = content.charAt(index);
                if (escapeNext) {
                    escapeNext = false;
                    continue;
                }
                if (c == '\\') {
                    escapeNext = true;
                    continue;
                }
                if (c != openingQuote) continue;
                String string = content.substring(startIndex, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String extractedContent = string;
                return this.processEscapeSequences(extractedContent);
            }
            throw new ParseException.QuoteParseException("Unclosed quote in code_edit field", null, 2, null);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException.QuoteParseException("Failed to extract code_edit content: " + e.getMessage(), e);
        }
    }

    private final String processEscapeSequences(String content) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)content, (String)"\\n", (String)"\n", (boolean)false, (int)4, null), (String)"\\\"", (String)"\"", (boolean)false, (int)4, null), (String)"\\'", (String)"'", (boolean)false, (int)4, null), (String)"\\\\", (String)"\\", (boolean)false, (int)4, null);
    }

    private final void validateEditRequest(String targetFile, String codeEdit) {
        if (StringsKt.isBlank((CharSequence)targetFile)) {
            throw new ParseException.InvalidFieldException("target_file", targetFile, "cannot be blank", null, 8, null);
        }
        if (StringsKt.isBlank((CharSequence)codeEdit)) {
            throw new ParseException.InvalidFieldException("code_edit", codeEdit, "cannot be blank", null, 8, null);
        }
        if (StringsKt.contains$default((CharSequence)targetFile, (CharSequence)"..", (boolean)false, (int)2, null)) {
            throw new ParseException.InvalidFieldException("target_file", targetFile, "path traversal not allowed", null, 8, null);
        }
    }
}

