/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.command;

import cc.unitmesh.devti.bridge.knowledge.HistoryFunctionProviderKt;
import cc.unitmesh.devti.command.EditApply;
import cc.unitmesh.devti.command.EditRequest;
import cc.unitmesh.devti.command.EditRequestParser;
import cc.unitmesh.devti.command.EditResult;
import cc.unitmesh.devti.sketch.ui.patch.SingleFileDiffSketchKt;
import cc.unitmesh.devti.util.ProjectFileUtilKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/command/EditFileCommand;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "editApply", "Lcc/unitmesh/devti/command/EditApply;", "parser", "Lcc/unitmesh/devti/command/EditRequestParser;", "executeEdit", "Lcc/unitmesh/devti/command/EditResult;", "editRequest", "Lcc/unitmesh/devti/command/EditRequest;", "findTargetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetPath", "", "projectDir", "parseEditRequest", "content", "core"})
public final class EditFileCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final EditApply editApply;
    @NotNull
    private final EditRequestParser parser;

    public EditFileCommand(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.editApply = new EditApply();
        this.parser = new EditRequestParser();
    }

    @NotNull
    public final EditResult executeEdit(@NotNull EditRequest editRequest) {
        EditResult editResult;
        Intrinsics.checkNotNullParameter((Object)editRequest, (String)"editRequest");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        if (virtualFile == null) {
            return EditResult.Companion.error("Project directory not found");
        }
        VirtualFile projectDir = virtualFile;
        VirtualFile virtualFile2 = this.findTargetFile(editRequest.getTargetFile(), projectDir);
        if (virtualFile2 == null) {
            return EditResult.Companion.error("File not found: " + editRequest.getTargetFile());
        }
        VirtualFile targetFile = virtualFile2;
        try {
            String originalContent = SingleFileDiffSketchKt.readText(targetFile);
            String editedContent = this.editApply.applyEdit(originalContent, editRequest.getCodeEdit());
            CompletableFuture future = new CompletableFuture();
            ActionsKt.runInEdt$default(null, () -> EditFileCommand.executeEdit$lambda$1(future, targetFile, editedContent), (int)1, null);
            String writeResult = (String)future.get();
            Intrinsics.checkNotNull((Object)writeResult);
            if (StringsKt.startsWith$default((String)writeResult, (String)"error:", (boolean)false, (int)2, null)) {
                String string = writeResult.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return EditResult.Companion.error("Failed to write file: " + string);
            }
            TextFilePatch textFilePatch = SingleFileDiffSketchKt.createPatchFromCode(originalContent, editedContent);
            if (textFilePatch == null) {
                return EditResult.Companion.error("No changes detected in " + editRequest.getTargetFile());
            }
            TextFilePatch patch = textFilePatch;
            patch.setBeforeName(ProjectFileUtilKt.relativePath(targetFile, this.project));
            patch.setAfterName(ProjectFileUtilKt.relativePath(targetFile, this.project));
            editResult = EditResult.Companion.success("File edited successfully: " + editRequest.getTargetFile(), patch, targetFile);
        }
        catch (Exception e) {
            editResult = EditResult.Companion.error("Failed to apply edit to " + editRequest.getTargetFile() + ": " + e.getMessage());
        }
        return editResult;
    }

    private final VirtualFile findTargetFile(String targetPath, VirtualFile projectDir) {
        return (VirtualFile)ActionsKt.runReadAction(() -> EditFileCommand.findTargetFile$lambda$2(projectDir, targetPath, this));
    }

    @Nullable
    public final EditRequest parseEditRequest(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return this.parser.parse(content);
    }

    private static final Unit executeEdit$lambda$1$lambda$0(VirtualFile $targetFile, String $editedContent) {
        SingleFileDiffSketchKt.writeText($targetFile, $editedContent);
        return Unit.INSTANCE;
    }

    private static final Unit executeEdit$lambda$1(CompletableFuture $future, VirtualFile $targetFile, String $editedContent) {
        try {
            WriteAction.compute(() -> EditFileCommand.executeEdit$lambda$1$lambda$0($targetFile, $editedContent));
            $future.complete("success");
        }
        catch (Exception e) {
            $future.complete("error: " + e.getMessage());
        }
        return Unit.INSTANCE;
    }

    private static final VirtualFile findTargetFile$lambda$2(VirtualFile $projectDir, String $targetPath, EditFileCommand this$0) {
        VirtualFile virtualFile = $projectDir.findFileByRelativePath($targetPath);
        if (virtualFile == null) {
            virtualFile = HistoryFunctionProviderKt.lookupFile(this$0.project, $targetPath);
        }
        return virtualFile;
    }
}

