/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.bridge.utils;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.lang.html.structureView.HtmlTagTreeElement;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\n\u0010\u0018\u001a\u00060\u0013j\u0002`\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcc/unitmesh/devti/bridge/utils/StructureCommandUtil;", "", "<init>", "()V", "MAX_LINES_FOR_SHOW_LINENO", "", "getFileStructure", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "openEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "createFileEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "traverseStructure", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "element", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "depth", "sb", "formatBeforeCode", "formatLine", "psiElement", "Lcom/intellij/psi/PsiElement;", "core"})
public final class StructureCommandUtil {
    @NotNull
    public static final StructureCommandUtil INSTANCE = new StructureCommandUtil();
    private static final int MAX_LINES_FOR_SHOW_LINENO = 60;

    private StructureCommandUtil() {
    }

    @NotNull
    public final String getFileStructure(@NotNull Project project, @NotNull VirtualFile file, @NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        return (String)ActionsKt.runReadAction(() -> StructureCommandUtil.getFileStructure$lambda$1(psiFile2, project, file));
    }

    private final FileEditor openEditor(Project project, VirtualFile file) {
        Object[] objectArray = FileEditorManager.getInstance((Project)project).openFile(file, false, true);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"openFile(...)");
        Object[] fileEditors = objectArray;
        return (FileEditor)ArraysKt.firstOrNull((Object[])fileEditors);
    }

    private final TextEditor createFileEditor(Project project, VirtualFile file) {
        CompletableFuture future = new CompletableFuture();
        ActionsKt.runInEdt((ModalityState)ModalityState.any(), () -> StructureCommandUtil.createFileEditor$lambda$2(project, file, future));
        Object t = future.get();
        return t instanceof TextEditor ? (TextEditor)t : null;
    }

    private final StringBuilder traverseStructure(StructureViewTreeElement element, int depth, StringBuilder sb) {
        Object object;
        String indent = this.formatBeforeCode(element, depth);
        StructureViewTreeElement structureViewTreeElement = element;
        if (structureViewTreeElement instanceof HtmlTagTreeElement) {
            String string = ((HtmlTagTreeElement)element).getLocationString();
            object = (string != null ? string.length() == 0 : false) || ((HtmlTagTreeElement)element).getLocationString() == null ? ((HtmlTagTreeElement)element).getPresentableText() : ((HtmlTagTreeElement)element).getPresentableText() + " " + ((HtmlTagTreeElement)element).getLocationString();
        } else {
            object = structureViewTreeElement instanceof PsiTreeElementBase ? ((PsiTreeElementBase)element).getPresentableText() : element.getPresentation().getPresentableText();
        }
        String str = object;
        structureViewTreeElement = str;
        if (!(structureViewTreeElement == null || StringsKt.isBlank((CharSequence)structureViewTreeElement))) {
            sb.append(indent).append(str).append("\n");
        }
        for (TreeElement child : element.getChildren()) {
            if (!(child instanceof StructureViewTreeElement)) continue;
            this.traverseStructure((StructureViewTreeElement)child, depth + 1, sb);
        }
        return sb;
    }

    private final String formatBeforeCode(StructureViewTreeElement element, int depth) {
        Object object;
        if (element.getValue() instanceof PsiElement) {
            Object object2 = element.getValue();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
            PsiElement psiElement = (PsiElement)object2;
            String line = this.formatLine(psiElement);
            object = line + StringsKt.repeat((CharSequence)"  ", (int)depth);
        } else {
            object = StringsKt.repeat((CharSequence)"  ", (int)depth);
        }
        return object;
    }

    private final String formatLine(PsiElement psiElement) {
        PsiFile psiFile2 = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        PsiFile psiFile3 = psiFile2;
        Document document = PsiDocumentManager.getInstance((Project)psiFile3.getProject()).getDocument(psiFile3);
        if (document == null) {
            return "";
        }
        Document document2 = document;
        int start2 = document2.getLineNumber(psiElement.getTextRange().getStartOffset());
        int end = document2.getLineNumber(psiElement.getTextRange().getEndOffset());
        if (end - start2 > 60) {
            return "(" + (start2 + 1) + "-" + (end + 1) + ") ";
        }
        return "";
    }

    private static final Unit getFileStructure$lambda$1$lambda$0(Project $project, VirtualFile $file) {
        FileEditorManager.getInstance((Project)$project).closeFile($file);
        return Unit.INSTANCE;
    }

    private static final String getFileStructure$lambda$1(PsiFile $psiFile, Project $project, VirtualFile $file) {
        PsiStructureViewFactory viewFactory = (PsiStructureViewFactory)LanguageStructureViewBuilder.INSTANCE.forLanguage($psiFile.getLanguage());
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)$project).getEditors($file);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
        FileEditor fileEditor2 = (FileEditor)ArraysKt.firstOrNull((Object[])fileEditorArray);
        if (fileEditor2 == null) {
            TextEditor textEditor = (TextEditor)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TextEditor>, Object>($project, $file, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $file;
                {
                    this.$project = $project;
                    this.$file = $file;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            return StructureCommandUtil.access$createFileEditor(StructureCommandUtil.INSTANCE, this.$project, this.$file);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super TextEditor> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            if (textEditor != null) {
                fileEditor2 = (FileEditor)textEditor;
            } else {
                fileEditor2 = INSTANCE.openEditor($project, $file);
                if (fileEditor2 == null) {
                    return "No FileEditor found.";
                }
            }
        }
        FileEditor fileEditor3 = fileEditor2;
        if (viewFactory != null) {
            StructureView structureView;
            StructureViewBuilder structureViewBuilder = viewFactory.getStructureViewBuilder($psiFile);
            if (structureViewBuilder == null || (structureView = structureViewBuilder.createStructureView(fileEditor3, $project)) == null) {
                return "No StructureView found.";
            }
            StructureView view = structureView;
            ActionsKt.invokeLater$default(null, () -> StructureCommandUtil.getFileStructure$lambda$1$lambda$0($project, $file), (int)1, null);
            StructureViewTreeElement structureViewTreeElement = view.getTreeModel().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)structureViewTreeElement, (String)"getRoot(...)");
            StructureViewTreeElement root = structureViewTreeElement;
            String string = INSTANCE.traverseStructure(root, 0, new StringBuilder()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return "No StructureViewModel found.";
    }

    private static final Unit createFileEditor$lambda$2(Project $project, VirtualFile $file, CompletableFuture $future) {
        FileEditor createEditor = TextEditorProvider.Companion.getInstance().createEditor($project, $file);
        $future.complete(createEditor);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ TextEditor access$createFileEditor(StructureCommandUtil $this, Project project, VirtualFile file) {
        return $this.createFileEditor(project, file);
    }
}

