/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.agent.tool.search;

import cc.unitmesh.devti.agent.tool.search.RipgrepOutputProcessor;
import cc.unitmesh.devti.agent.tool.search.RipgrepSearchResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\tJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\tH\u0002J8\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0002JH\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0014\b\u0002\u0010\u001e\u001a\u000e\u0018\u00010\t\u00a2\u0006\u0002\b\u001f\u00a2\u0006\u0002\b J\u001e\u0010!\u001a\u00020\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0018\u0010#\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcc/unitmesh/devti/agent/tool/search/RipgrepSearcher;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "searchFiles", "Ljava/util/concurrent/CompletableFuture;", "", "project", "Lcom/intellij/openapi/project/Project;", "searchDirectory", "regexPattern", "filePattern", "findRipgrepBinary", "Ljava/nio/file/Path;", "findRipgrepBinaryOnWindows", "binName", "findRipgrepBinaryOnUnix", "findInPath", "executable", "executeRipgrep", "", "Lcc/unitmesh/devti/agent/tool/search/RipgrepSearchResult;", "rgPath", "directory", "regex", "getCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "basePath", "Lorg/jetbrains/annotations/SystemIndependent;", "Lorg/jetbrains/annotations/NonNls;", "formatResults", "searchResults", "getRelativePath", "absolutePath", "core"})
@SourceDebugExtension(value={"SMAP\nRipgrepSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RipgrepSearcher.kt\ncc/unitmesh/devti/agent/tool/search/RipgrepSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1549#2:272\n1620#2,3:273\n*S KotlinDebug\n*F\n+ 1 RipgrepSearcher.kt\ncc/unitmesh/devti/agent/tool/search/RipgrepSearcher\n*L\n239#1:272\n239#1:273,3\n*E\n"})
public final class RipgrepSearcher {
    @NotNull
    public static final RipgrepSearcher INSTANCE = new RipgrepSearcher();
    @NotNull
    private static final Logger LOG;

    private RipgrepSearcher() {
    }

    @NotNull
    public final CompletableFuture<String> searchFiles(@NotNull Project project, @NotNull String searchDirectory, @NotNull String regexPattern, @Nullable String filePattern) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchDirectory, (String)"searchDirectory");
        Intrinsics.checkNotNullParameter((Object)regexPattern, (String)"regexPattern");
        CompletableFuture<String> completableFuture = CompletableFuture.supplyAsync(() -> RipgrepSearcher.searchFiles$lambda$0(project, searchDirectory, regexPattern, filePattern));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @Nullable
    public final Path findRipgrepBinary() throws IOException {
        Path result;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String osName = string3;
        String binName = StringsKt.contains$default((CharSequence)osName, (CharSequence)"win", (boolean)false, (int)2, null) ? "rg.exe" : "rg";
        LOG.debug("Searching for ripgrep binary on OS: " + osName);
        Path path = result = StringsKt.contains$default((CharSequence)osName, (CharSequence)"win", (boolean)false, (int)2, null) ? this.findRipgrepBinaryOnWindows(binName) : this.findRipgrepBinaryOnUnix(binName);
        if (result != null) {
            LOG.debug("Found ripgrep binary at: " + result);
        } else {
            LOG.warn("Ripgrep binary not found. Please install ripgrep: https://github.com/BurntSushi/ripgrep#installation");
        }
        return result;
    }

    private final Path findRipgrepBinaryOnWindows(String binName) {
        Object path2;
        Object object;
        try {
            object = new String[]{"where", binName};
            ProcessBuilder pb = new ProcessBuilder((String[])object);
            Process process2 = pb.start();
            if (process2.waitFor(1L, TimeUnit.SECONDS) && process2.exitValue() == 0) {
                byte[] byArray = process2.getInputStream().readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                String string = (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)new String(byArray2, charset2)));
                Object object2 = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : (path2 = null);
                if (path2 != null) {
                    return Paths.get((String)path2, new String[0]);
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to locate rg using 'where' command", (Throwable)e);
        }
        object = new Path[3];
        path2 = new String[]{"ripgrep", binName};
        object[0] = Paths.get(System.getenv("ProgramFiles"), (String[])path2);
        path2 = new String[]{"ripgrep", binName};
        object[1] = Paths.get(System.getenv("ProgramFiles(x86)"), (String[])path2);
        path2 = new String[]{".cargo", "bin", binName};
        object[2] = Paths.get(System.getenv("USERPROFILE"), (String[])path2);
        List commonPaths = CollectionsKt.listOf((Object[])object);
        for (Object path2 : commonPaths) {
            if (!path2.toFile().exists()) continue;
            return path2;
        }
        return this.findInPath(binName);
    }

    private final Path findRipgrepBinaryOnUnix(String binName) {
        Object path;
        Object object;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"mac", (boolean)false, (int)2, null)) {
            object = new String[]{"/opt/homebrew/bin/rg", "/usr/local/bin/rg", "/opt/homebrew/sbin/rg", "/usr/local/sbin/rg", System.getProperty("user.home") + "/.cargo/bin/rg"};
            List macPaths = CollectionsKt.listOf((Object[])object);
            LOG.debug("Checking macOS-specific paths for ripgrep: " + macPaths);
            for (String pathStr : macPaths) {
                path = Paths.get(pathStr, new String[0]);
                LOG.debug("Checking path: " + pathStr);
                if (!path.toFile().exists() || !path.toFile().canExecute()) continue;
                LOG.debug("Found ripgrep at macOS path: " + (Path)path);
                return path;
            }
            LOG.debug("Ripgrep not found in any macOS-specific paths");
        }
        try {
            object = new String[]{"which", binName};
            ProcessBuilder pb = new ProcessBuilder((String[])object);
            Process process2 = pb.start();
            if (process2.waitFor(1L, TimeUnit.SECONDS) && process2.exitValue() == 0) {
                Path rgPath;
                byte[] byArray = process2.getInputStream().readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                path = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                String path2 = ((Object)StringsKt.trim((CharSequence)new String((byte[])path, charset2))).toString();
                if (((CharSequence)path2).length() > 0 && (rgPath = Paths.get(path2, new String[0])).toFile().exists() && rgPath.toFile().canExecute()) {
                    return rgPath;
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to locate rg using 'which' command", (Throwable)e);
        }
        return this.findInPath(binName);
    }

    private final Path findInPath(String executable) {
        String string = System.getenv("PATH");
        if (string == null) {
            return null;
        }
        String pathEnv = string;
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String pathSeparator = StringsKt.contains$default((CharSequence)string3, (CharSequence)"win", (boolean)false, (int)2, null) ? ";" : ":";
        String[] stringArray = new String[]{pathSeparator};
        for (String dir : StringsKt.split$default((CharSequence)pathEnv, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            if (StringsKt.isBlank((CharSequence)dir)) continue;
            try {
                String[] stringArray2 = new String[]{executable};
                Path path = Paths.get(dir, stringArray2);
                if (!path.toFile().exists() || !path.toFile().canExecute()) continue;
                LOG.debug("Found ripgrep binary at: " + path);
                return path;
            }
            catch (Exception e) {
                LOG.debug("Error checking path " + dir + " for " + executable, (Throwable)e);
            }
        }
        LOG.debug("Ripgrep binary not found in PATH. PATH=" + pathEnv);
        return null;
    }

    private final List<RipgrepSearchResult> executeRipgrep(Project project, Path rgPath, String directory, String regex, String filePattern) throws IOException {
        GeneralCommandLine cmd = this.getCommandLine(rgPath, regex, filePattern, directory, project.getBasePath());
        OSProcessHandler handler = (OSProcessHandler)new ColoredProcessHandler(cmd);
        RipgrepOutputProcessor processor = new RipgrepOutputProcessor();
        handler.addProcessListener((ProcessListener)processor);
        handler.startNotify();
        handler.waitFor();
        return processor.getResults();
    }

    @NotNull
    public final GeneralCommandLine getCommandLine(@NotNull Path rgPath, @Nullable String regex, @Nullable String filePattern, @Nullable String directory, @Nullable String basePath) {
        Intrinsics.checkNotNullParameter((Object)rgPath, (String)"rgPath");
        String[] stringArray = new String[]{((Object)rgPath).toString()};
        GeneralCommandLine cmd = new GeneralCommandLine(stringArray);
        cmd.withWorkDirectory(basePath);
        stringArray = new String[]{"--json"};
        cmd.addParameters(stringArray);
        if (regex != null) {
            stringArray = new String[]{"-e", regex};
            cmd.addParameters(stringArray);
        }
        if (filePattern != null) {
            stringArray = new String[]{"--glob", filePattern};
            cmd.addParameters(stringArray);
        }
        stringArray = new String[]{"--context", "1"};
        cmd.addParameters(stringArray);
        if (directory != null) {
            stringArray = new String[]{directory};
            cmd.addParameters(stringArray);
        }
        cmd.setCharset(StandardCharsets.UTF_8);
        return cmd;
    }

    public static /* synthetic */ GeneralCommandLine getCommandLine$default(RipgrepSearcher ripgrepSearcher, Path path, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        return ripgrepSearcher.getCommandLine(path, string, string2, string3, string4);
    }

    /*
     * WARNING - void declaration
     */
    private final String formatResults(List<RipgrepSearchResult> searchResults, String basePath) {
        StringBuilder output = new StringBuilder();
        Map grouped = new LinkedHashMap();
        List<RipgrepSearchResult> results2 = searchResults;
        output.append("Total results: ").append(results2.size());
        if (results2.size() > 30) {
            results2 = results2.subList(0, 30);
            output.append("Too many results, only show first 30 results\n");
        }
        for (RipgrepSearchResult ripgrepSearchResult : results2) {
            String string = ripgrepSearchResult.getFilePath();
            Intrinsics.checkNotNull((Object)string);
            String relPath = this.getRelativePath(basePath, string);
            List list = grouped.computeIfAbsent(relPath, arg_0 -> RipgrepSearcher.formatResults$lambda$2(RipgrepSearcher::formatResults$lambda$1, arg_0));
            Intrinsics.checkNotNull((Object)list);
            list.add(ripgrepSearchResult);
        }
        output.append("\n```bash\n");
        for (Map.Entry entry : grouped.entrySet()) {
            void $this$mapTo$iv$iv;
            output.append("## filepath: ").append((String)entry.getKey()).append("\n");
            String[] stringArray = new String[]{entry.getKey()};
            Path filePath = Paths.get(basePath, stringArray);
            File file = filePath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            List content = FilesKt.readLines$default((File)file, null, (int)1, null);
            Object v = entry.getValue();
            Intrinsics.checkNotNull(v);
            Iterable $this$map$iv = (Iterable)v;
            boolean $i$f$map232 = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RipgrepSearchResult ripgrepSearchResult = (RipgrepSearchResult)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v4 = it;
                Intrinsics.checkNotNull((Object)v4);
                collection.add(v4.getLine());
            }
            List lineNumbers = (List)destination$iv$iv;
            Set displayLines = new LinkedHashSet();
            Iterator $i$f$map232 = lineNumbers.iterator();
            block3: while ($i$f$map232.hasNext()) {
                int end;
                int lineNumber = ((Number)$i$f$map232.next()).intValue();
                int start2 = RangesKt.coerceAtLeast((int)1, (int)(lineNumber - 4));
                int i = start2;
                if (i > (end = RangesKt.coerceAtMost((int)content.size(), (int)(lineNumber + 4)))) continue;
                while (true) {
                    displayLines.add(i);
                    if (i == end) continue block3;
                    ++i;
                }
            }
            List sortedDisplayLines = CollectionsKt.sorted((Iterable)displayLines);
            object = sortedDisplayLines.iterator();
            while (object.hasNext()) {
                int lineNumber = ((Number)object.next()).intValue();
                String line = (String)CollectionsKt.getOrNull((List)content, (int)(lineNumber - 1));
                if (line == null) continue;
                output.append(lineNumber).append(" ").append(line).append("\n");
            }
            output.append("\n");
        }
        output.append("```\n");
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getRelativePath(String basePath, String absolutePath) {
        Path base = Paths.get(basePath, new String[0]);
        Path target = Paths.get(absolutePath, new String[0]);
        return StringsKt.replace$default((String)((Object)base.relativize(target)).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    private static final String searchFiles$lambda$0(Project $project, String $searchDirectory, String $regexPattern, String $filePattern) {
        try {
            Path rgPath = INSTANCE.findRipgrepBinary();
            if (rgPath == null) {
                return "Ripgrep binary not found, try install it first: https://github.com/BurntSushi/ripgrep?tab=readme-ov-file#installation";
            }
            List<RipgrepSearchResult> results2 = INSTANCE.executeRipgrep($project, rgPath, $searchDirectory, $regexPattern, $filePattern);
            String string = $project.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            return INSTANCE.formatResults(results2, string);
        }
        catch (Exception e) {
            LOG.error("Search failed", (Throwable)e);
            return "Search error: " + e.getMessage();
        }
    }

    private static final List formatResults$lambda$1(String k) {
        return new ArrayList();
    }

    private static final List formatResults$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(RipgrepSearcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

