/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.devti.agent.tool.search;

import cc.unitmesh.devti.agent.tool.search.RipgrepSearchResult;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/devti/agent/tool/search/RipgrepOutputProcessor;", "Lcom/intellij/execution/process/ProcessAdapter;", "<init>", "()V", "results", "", "Lcc/unitmesh/devti/agent/tool/search/RipgrepSearchResult;", "currentResult", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "jsonBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "parseJsonLine", "line", "", "getResults", "core"})
@SourceDebugExtension(value={"SMAP\nRipgrepOutputProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RipgrepOutputProcessor.kt\ncc/unitmesh/devti/agent/tool/search/RipgrepOutputProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1855#2,2:105\n*S KotlinDebug\n*F\n+ 1 RipgrepOutputProcessor.kt\ncc/unitmesh/devti/agent/tool/search/RipgrepOutputProcessor\n*L\n71#1:105,2\n*E\n"})
public final class RipgrepOutputProcessor
extends ProcessAdapter {
    @NotNull
    private final List<RipgrepSearchResult> results = new ArrayList();
    @Nullable
    private RipgrepSearchResult currentResult;
    @NotNull
    private final StringBuilder jsonBuffer = new StringBuilder();

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        if (outputType == ProcessOutputTypes.STDOUT) {
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.parseJsonLine(string);
        }
    }

    public final void parseJsonLine(@NotNull String line) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (StringsKt.isBlank((CharSequence)line)) {
            return;
        }
        this.jsonBuffer.append(line);
        try {
            jsonElement = JsonParser.parseString((String)this.jsonBuffer.toString());
        }
        catch (Exception e) {
            return;
        }
        JsonElement json = jsonElement;
        StringsKt.clear((StringBuilder)this.jsonBuffer);
        if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            String type = jsonObject.get("type").getAsString();
            String string = type;
            if (Intrinsics.areEqual((Object)string, (Object)"match")) {
                JsonObject data = jsonObject.getAsJsonObject("data");
                String path = data.getAsJsonObject("path").get("text").getAsString();
                String lines = data.getAsJsonObject("lines").get("text").getAsString();
                int lineNumber = data.get("line_number").getAsInt();
                int absoluteOffset = data.get("absolute_offset").getAsInt();
                JsonArray submatches = data.getAsJsonArray("submatches");
                Intrinsics.checkNotNull((Object)lines);
                this.currentResult = new RipgrepSearchResult(path, lineNumber, absoluteOffset, ((Object)StringsKt.trim((CharSequence)lines)).toString(), null, null, 48, null);
                Intrinsics.checkNotNull((Object)submatches);
                Iterable $this$forEach$iv = (Iterable)submatches;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonElement submatch = (JsonElement)element$iv;
                    boolean bl = false;
                    JsonObject submatchObj = submatch.getAsJsonObject();
                    String matchText = submatchObj.get("match").getAsJsonObject().get("text").getAsString();
                    RipgrepSearchResult ripgrepSearchResult = this.currentResult;
                    if (ripgrepSearchResult == null) continue;
                    ripgrepSearchResult.setMatch(matchText);
                }
                RipgrepSearchResult ripgrepSearchResult = this.currentResult;
                Intrinsics.checkNotNull((Object)ripgrepSearchResult);
                this.results.add(ripgrepSearchResult);
            } else if (Intrinsics.areEqual((Object)string, (Object)"context")) {
                JsonObject data = jsonObject.getAsJsonObject("data");
                String lines = data.getAsJsonObject("lines").get("text").getAsString();
                int lineNumber = data.get("line_number").getAsInt();
                if (this.currentResult != null) {
                    RipgrepSearchResult ripgrepSearchResult = this.currentResult;
                    Intrinsics.checkNotNull((Object)ripgrepSearchResult);
                    if (lineNumber < ripgrepSearchResult.getLine()) {
                        RipgrepSearchResult ripgrepSearchResult2 = this.currentResult;
                        Intrinsics.checkNotNull((Object)ripgrepSearchResult2);
                        List<String> list = ripgrepSearchResult2.getBeforeContext();
                        Intrinsics.checkNotNull((Object)lines);
                        v5 = list.add(((Object)StringsKt.trim((CharSequence)lines)).toString());
                    } else {
                        RipgrepSearchResult ripgrepSearchResult3 = this.currentResult;
                        Intrinsics.checkNotNull((Object)ripgrepSearchResult3);
                        List<String> list = ripgrepSearchResult3.getAfterContext();
                        Intrinsics.checkNotNull((Object)lines);
                        v5 = list.add(((Object)StringsKt.trim((CharSequence)lines)).toString());
                    }
                }
            }
        }
    }

    @NotNull
    public final List<RipgrepSearchResult> getResults() {
        if (this.currentResult != null) {
            RipgrepSearchResult ripgrepSearchResult = this.currentResult;
            Intrinsics.checkNotNull((Object)ripgrepSearchResult);
            this.results.add(ripgrepSearchResult);
        }
        return this.results;
    }
}

